/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.tools.roads;

import com.bbn.openmap.event.ProjectionEvent;
import com.bbn.openmap.event.ProjectionListener;
import com.bbn.openmap.omGraphics.OMGeometry;
import com.bbn.openmap.omGraphics.OMLine;
import com.bbn.openmap.omGraphics.OMPoint;
import com.bbn.openmap.omGraphics.OMText;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.tools.roads.Intersection;
import com.bbn.openmap.tools.roads.LayerView;
import com.bbn.openmap.tools.roads.Road;
import com.bbn.openmap.tools.roads.RoadClass;
import com.bbn.openmap.tools.roads.RoadLayer;
import com.bbn.openmap.tools.roads.RoadObject;
import com.bbn.openmap.tools.roads.RoadPoint;
import com.bbn.openmap.tools.roads.RoadServices;
import com.bbn.openmap.tools.roads.Route;
import com.bbn.openmap.tools.roads.Segment;
import com.bbn.openmap.tools.roads.Waypoint;
import com.bbn.openmap.util.quadtree.QuadTree;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RoadFinder
implements RoadServices,
ProjectionListener,
RoadLayer {
    protected RoadClasses roadClasses = new RoadClasses();
    protected RoadClass defaultRoadClass;
    protected LayerView layer;
    protected Intersections intersections = new Intersections();
    protected RoadVector roads = new RoadVector();
    protected Vector removedRoads = new Vector();
    protected float halo;
    Logger logger = Logger.getLogger(this.getClass().getName());
    boolean drawIntersections = false;
    boolean drawResults = false;
    boolean doLoopCheck = false;
    protected QuadTree interQuadTree;
    protected Map graphicToRoad;
    boolean doInterp = true;
    List toDraw = new ArrayList();
    boolean showLines = true;
    int roadsMade = 0;

    public RoadFinder(LayerView layer, boolean drawIntersections, boolean drawResults) {
        this.initRoadClasses();
        this.drawIntersections = drawIntersections;
        this.drawResults = drawResults;
        this.logger.info("drawIntersections is " + drawIntersections);
        this.logger.info("drawResults is " + drawResults);
        this.layer = layer;
    }

    protected void initRoadClasses() {
        this.roadClasses.put(new RoadClass((Serializable)((Object)"1"), Color.magenta, 2, 25.0f));
        this.defaultRoadClass = this.findRoadClass("1");
    }

    public void projectionChanged(ProjectionEvent e) {
        try {
            this.getData();
        }
        catch (Exception ee) {
            this.logger.warning("Got exception " + ee);
            ee.printStackTrace();
        }
    }

    protected synchronized void getData() throws Exception {
        this.logger.info("get Data called.");
        this.intersections.clear();
        this.removedRoads.setSize(0);
        this.roads.clear();
        this.toDraw.clear();
        this.getRoads();
        this.checkIntegrity();
        this.logger.info("showing " + this.toDraw.size() + " extra graphics.");
        this.layer.setExtraGraphics(this.toDraw);
        this.halo = 0.05f * (this.getProjection().getScale() / 20000.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getRoads() throws Exception {
        this.roadsMade = 0;
        List rectangle = this.layer.getGraphicList();
        int[] xPoints = new int[1024];
        int[] yPoints = new int[1024];
        this.interQuadTree = new QuadTree();
        this.graphicToRoad = new HashMap();
        int height = this.getProjection().getHeight();
        int width = this.getProjection().getWidth();
        int skipped = 0;
        List list = rectangle;
        synchronized (list) {
            double[] points = new double[6];
            if (this.logger.isLoggable(Level.INFO)) {
                this.logger.info("iterating over rectangle contents.");
            }
            int num = 0;
            int made = 0;
            Iterator iter = rectangle.iterator();
            while (iter.hasNext()) {
                GeneralPath shape;
                double lastXOff = 0.0;
                double lastYOff = 0.0;
                ++num;
                OMGeometry graphic = (OMGeometry)iter.next();
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine("examining " + graphic);
                }
                if ((shape = graphic.getShape()) == null) continue;
                PathIterator path = shape.getPathIterator(new AffineTransform());
                int segment = 0;
                int itemsInPath = 0;
                boolean pathValid = true;
                while (!path.isDone() && pathValid) {
                    int type = path.currentSegment(points);
                    ++itemsInPath;
                    boolean offScreen = false;
                    if (points[0] < 0.0 || points[0] >= (double)width) {
                        offScreen = true;
                    }
                    if (points[1] < 0.0 || points[1] >= (double)height) {
                        offScreen = true;
                    }
                    switch (type) {
                        case 4: {
                            this.logger.warning("got close");
                            break;
                        }
                        case 3: {
                            this.logger.warning("got cubic to");
                            break;
                        }
                        case 1: {
                            Point interpPt;
                            if (offScreen) {
                                if (segment > 0) {
                                    if (this.doInterp) {
                                        interpPt = this.interp(xPoints[segment - 1], yPoints[segment - 1], points[0], points[1], width, height);
                                        xPoints[segment] = interpPt.x;
                                        yPoints[segment++] = interpPt.y;
                                        this.makeRoad(shape, graphic, made++, xPoints, yPoints, segment);
                                        lastXOff = 0.0;
                                        lastYOff = 0.0;
                                        segment = 0;
                                    }
                                } else {
                                    lastXOff = points[0];
                                    lastYOff = points[1];
                                }
                            } else {
                                if (lastXOff != 0.0 || lastYOff != 0.0) {
                                    interpPt = this.interp(points[0], points[1], lastXOff, lastYOff, width, height);
                                    xPoints[segment] = interpPt.x;
                                    yPoints[segment++] = interpPt.y;
                                }
                                xPoints[segment] = (int)points[0];
                                yPoints[segment++] = (int)points[1];
                                lastXOff = 0.0;
                                lastYOff = 0.0;
                            }
                            if (!this.logger.isLoggable(Level.FINE)) break;
                            this.logger.fine(" line to " + points[0] + ", " + points[1]);
                            break;
                        }
                        case 0: {
                            if (offScreen) {
                                lastXOff = points[0];
                                lastYOff = points[1];
                            } else {
                                if (segment == 0) {
                                    xPoints[segment] = (int)points[0];
                                    yPoints[segment++] = (int)points[1];
                                } else {
                                    pathValid = false;
                                    this.logger.info("got invalid path.");
                                }
                                lastXOff = 0.0;
                                lastYOff = 0.0;
                            }
                            if (!this.logger.isLoggable(Level.FINE)) break;
                            this.logger.fine(" moving to " + points[0] + ", " + points[1]);
                            break;
                        }
                        case 2: {
                            this.logger.warning("got quad to");
                            break;
                        }
                        default: {
                            this.logger.warning("got another type : " + type);
                        }
                    }
                    path.next();
                }
                if (segment < 2) {
                    ++skipped;
                    this.logger.fine("Skipping line that doesn't have an end point");
                } else {
                    if (this.logger.isLoggable(Level.INFO)) {
                        this.logger.info("items in path " + itemsInPath);
                    }
                    this.makeRoad(shape, graphic, made++, xPoints, yPoints, segment);
                }
                segment = 0;
            }
            if (this.logger.isLoggable(Level.INFO)) {
                this.logger.info("num items " + num + " skipped " + skipped);
            }
        }
    }

    protected Point interp(double x1, double y1, double x2, double y2, int width, int height) {
        double deltaY = y2 - y1;
        double deltaX = x2 - x1;
        double slope = deltaY / deltaX;
        double newX = x2;
        double newY = y2;
        if (newX < 0.0) {
            newX = 0.0;
            newY = Math.round(slope * (newX - x1) + y1);
        } else if (newX >= (double)width) {
            newX = width - 1;
            newY = Math.round(slope * (newX - x1) + y1);
        }
        if (newY < 0.0) {
            newY = 0.0;
            newX = Math.round(x1 + (newY - y1) / slope);
        } else if (newY >= (double)height) {
            newY = height - 1;
            newX = Math.round(x1 + (newY - y1) / slope);
        }
        int intX = (int)newX;
        int intY = (int)newY;
        if (intX < 0) {
            this.logger.warning("new x is " + intX);
            intX = 0;
        }
        if (intX >= width) {
            this.logger.warning("new x is " + intX);
            intX = width - 1;
        }
        if (intY < 0) {
            this.logger.warning("new y is " + intY);
            intY = 0;
        }
        if (intY >= height) {
            this.logger.warning("new y is " + intY);
            intY = height - 1;
        }
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.info("from " + x1 + "," + y1 + " to " + x2 + "," + y2 + "w " + width + " h " + height + " interp " + intX + "," + intY);
        }
        return new Point(intX, intY);
    }

    protected void makeRoad(Shape shape, OMGeometry graphic, int num, int[] xPoints, int[] yPoints, int segment) {
        this.createRoadFromPoints(num, xPoints, yPoints, segment);
    }

    protected RoadObject createRoadFromPoints(int id, int[] xpoints, int[] ypoints, int nPoints) {
        RoadPoint[] roadPoints = new RoadPoint[nPoints - 2];
        Intersection from = this.findIntersection(xpoints[0], ypoints[0]);
        int fromBefore = from.getRoadCount();
        Intersection to = this.findIntersection(xpoints[nPoints - 1], ypoints[nPoints - 1]);
        int toBefore = to.getRoadCount();
        if (from == null) {
            this.logger.warning("no from intersection for " + xpoints[0] + ", " + ypoints[0]);
        }
        if (to == null) {
            this.logger.warning("no to intersection for " + xpoints[nPoints - 1] + ", " + ypoints[nPoints - 1]);
        }
        String name = "road";
        Road road = this.createRoad(id, name + "-" + id, from, to, this.defaultRoadClass);
        if (fromBefore + 1 != from.getRoadCount()) {
            this.logger.severe("huh? " + from + " had " + fromBefore + " roads before and now " + from.getRoadCount());
        }
        if (toBefore + 1 != to.getRoadCount()) {
            this.logger.severe("huh? " + to + " had " + toBefore + " roads before and now " + to.getRoadCount());
        }
        int width = this.roadsMade % 5;
        ++this.roadsMade;
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.info("road # " + this.roadsMade + " " + road + " has " + nPoints + " points");
        }
        if (!this.showLines && this.drawIntersections) {
            YellowPoint point = new YellowPoint(xpoints[0], ypoints[0], 10);
            this.toDraw.add(point);
        }
        for (int i = 1; i < nPoints - 1; ++i) {
            roadPoints[i - 1] = new RoadPoint(road, this.createLatLonPoint(xpoints[i], ypoints[i]), this);
            if (!this.drawIntersections) continue;
            if (this.showLines) {
                YellowLine line = new YellowLine(xpoints[i - 1], ypoints[i - 1], xpoints[i], ypoints[i], width);
                this.toDraw.add(line);
                this.toDraw.add(new OMText((xpoints[i - 1] - xpoints[i]) / 2 + xpoints[i - 1], (ypoints[i - 1] - ypoints[i]) / 2 + ypoints[i - 1] - 5, "" + this.roadsMade, 0));
                continue;
            }
            YellowPoint point = new YellowPoint(xpoints[i], ypoints[i], 10);
            this.toDraw.add(point);
        }
        if (this.drawIntersections) {
            if (this.showLines) {
                YellowLine line = new YellowLine(xpoints[nPoints - 2], ypoints[nPoints - 2], xpoints[nPoints - 1], ypoints[nPoints - 1], width);
                this.toDraw.add(line);
                this.toDraw.add(new OMText((xpoints[nPoints - 2] - xpoints[nPoints - 1]) / 2 + xpoints[nPoints - 2], (ypoints[nPoints - 2] - ypoints[nPoints - 1]) / 2 + ypoints[nPoints - 2] - 5, "" + this.roadsMade, 0));
                line.addArrowHead(true);
            } else {
                YellowPoint point = new YellowPoint(xpoints[nPoints - 1], ypoints[nPoints - 1], 10);
                this.toDraw.add(point);
            }
        }
        if (to == from && nPoints == 2) {
            this.deleteRoad(road);
            return null;
        }
        road.setRoadPoints(roadPoints);
        if (!road.getFirstIntersection().equals(from)) {
            this.logger.severe("huh? " + road + " first inter " + road.getFirstIntersection() + " not " + from);
        }
        if (!road.getSecondIntersection().equals(to)) {
            this.logger.severe("huh? " + road + " second inter " + road.getSecondIntersection() + " not " + to);
        }
        if (road.getPoints().length < 2) {
            this.logger.warning("Error : somehow made a road " + road + " with too few points.");
        } else if (this.logger.isLoggable(Level.INFO)) {
            // empty if block
        }
        return road;
    }

    protected LatLonPoint createLatLonPoint(int x, int y) {
        return this.getProjection().inverse(x, y, new LatLonPoint.Double());
    }

    protected Intersection findIntersection(LatLonPoint loc, String name) {
        if (name == null) {
            return this.findIntersection(loc);
        }
        Intersection intersection = this.intersections.get(name);
        if (intersection != null) {
            LatLonPoint foundLoc = intersection.getLocation();
            float distance = Math.abs(foundLoc.getLatitude() - loc.getLatitude()) + Math.abs(foundLoc.getLongitude() - loc.getLongitude());
            if (distance * (float)Intersection.GRID > 0.1f) {
                intersection = this.findIntersection(loc);
                System.out.println("Using " + intersection.getName() + " instead of " + name + " distance = " + distance);
                return intersection;
            }
        } else {
            intersection = new Intersection(loc, name, this);
            this.intersections.put(intersection);
            this.interQuadTree.put(intersection.getLatitude(), intersection.getLongitude(), intersection);
        }
        return intersection;
    }

    protected Intersection findIntersection(int x, int y) {
        LatLonPoint fromLoc = this.createLatLonPoint(x, y);
        Intersection from = this.findIntersection(fromLoc);
        return from;
    }

    protected Intersection findIntersection(LatLonPoint loc) {
        String name = Intersection.getLatLonPointName(loc);
        Intersection intersection = this.intersections.get(name);
        if (intersection == null) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("making new intersection for " + loc);
            }
            intersection = new Intersection(loc, name, this);
            this.interQuadTree.put(intersection.getLatitude(), intersection.getLongitude(), intersection);
            this.intersections.put(intersection);
        } else if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("found existing intersection for " + loc + " with " + intersection.getRoadCount() + " roads coming out of it.");
        }
        return intersection;
    }

    protected void deleteIntersection(Intersection intersection) {
        if (intersection.getRoadCount() > 0) {
            throw new IllegalArgumentException("Attempt to delete connected intersection");
        }
        this.intersections.remove(intersection);
    }

    public Road createRoad(Intersection from) {
        return this.createRoad(-1, null, from, null, null);
    }

    protected Road createRoad(int id, String name, Intersection from, Intersection to, RoadClass cl_ss) {
        if (id < 0) {
            id = this.findUnusedRoadID();
        }
        if (name == null) {
            name = "Road_" + id;
        }
        if (from == null) {
            from = this.findIntersection(to.getLocation(), to.getName() + ".drag");
        }
        if (to == null) {
            to = this.findIntersection(from.getLocation(), from.getName() + ".drag");
        }
        if (cl_ss == null) {
            cl_ss = this.defaultRoadClass;
        }
        Road road = new Road(id, name, from, to, cl_ss, this);
        road.setModified(true);
        from.addRoad(road);
        to.addRoad(road);
        this.roads.add(road);
        return road;
    }

    public void deleteRoad(Road road) {
        Intersection intersection1 = road.getFirstIntersection();
        Intersection intersection2 = road.getSecondIntersection();
        intersection1.removeRoad(road);
        intersection2.removeRoad(road);
        if (intersection1.getRoadCount() == 0) {
            this.deleteIntersection(intersection1);
        }
        if (intersection2.getRoadCount() == 0) {
            this.deleteIntersection(intersection2);
        }
        if (intersection1.getRoadCount() == 2 && intersection1.getRoad(0).getRoadClass() == intersection1.getRoad(1).getRoadClass()) {
            this.joinRoads(intersection1);
        }
        if (intersection2.getRoadCount() == 2 && intersection2.getRoad(0).getRoadClass() == intersection2.getRoad(1).getRoadClass()) {
            this.joinRoads(intersection2);
        }
        this.removedRoads.addElement(road);
        this.roads.remove(road);
    }

    public Intersection splitRoad(Road road, RoadPoint rp) {
        RoadPoint[] pointsBefore = road.getPointsBefore(rp);
        RoadPoint[] pointsAfter = road.getPointsAfter(rp);
        Intersection newIntersection = this.findIntersection(rp.getLocation(), null);
        Intersection firstIntersection = road.getFirstIntersection();
        Intersection secondIntersection = road.getSecondIntersection();
        road.setIntersections(firstIntersection, newIntersection);
        road.setRoadPoints(pointsBefore);
        secondIntersection.removeRoad(road);
        newIntersection.addRoad(road);
        Road newRoad = this.createRoad(-1, null, newIntersection, secondIntersection, road.getRoadClass());
        newRoad.setRoadPoints(pointsAfter);
        return newIntersection;
    }

    public void joinRoads(Intersection intersection) {
        Intersection firstIntersection;
        Road road1;
        if (intersection.getRoadCount() != 2) {
            throw new IllegalArgumentException("Illegal intersection conversion");
        }
        Road road0 = intersection.getRoad(0);
        if (road0 == (road1 = intersection.getRoad(1))) {
            this.roads.remove(road1);
            this.intersections.remove(intersection);
            return;
        }
        if (road0.getRoadClass() != road1.getRoadClass()) {
            throw new IllegalArgumentException("Illegal intersection conversion");
        }
        this.intersections.remove(intersection);
        this.roads.remove(road1);
        RoadPoint[] road0Points = road0.getRoadPoints();
        RoadPoint[] road1Points = road1.getRoadPoints();
        RoadPoint[] innerPoints = new RoadPoint[road0Points.length + road1Points.length + 1];
        int j = 0;
        if (intersection == road0.getFirstIntersection()) {
            firstIntersection = road0.getSecondIntersection();
            int i = road0Points.length;
            while (--i >= 0) {
                innerPoints[j++] = road0Points[i];
            }
        } else {
            firstIntersection = road0.getFirstIntersection();
            System.arraycopy(road0Points, 0, innerPoints, j, road0Points.length);
            j += road0Points.length;
        }
        Intersection otherIntersection = road1.getOtherIntersection(intersection);
        otherIntersection.removeRoad(road1);
        road0.setIntersections(firstIntersection, otherIntersection);
        otherIntersection.addRoad(road0);
        innerPoints[j++] = new RoadPoint(road0, intersection.getLocation(), this);
        if (intersection == road1.getFirstIntersection()) {
            System.arraycopy(road1Points, 0, innerPoints, j, road1Points.length);
            j += road1Points.length;
        } else {
            int i = road1Points.length;
            while (--i >= 0) {
                innerPoints[j++] = road1Points[i];
            }
        }
        road0.setRoadPoints(innerPoints);
        road0.setName(this.mergeRoadNames(road0.getName(), road1.getName()));
    }

    protected String mergeRoadNames(String name0, String name1) {
        return name0 + "+" + name1;
    }

    public RoadClass findRoadClass(Object className) {
        RoadClass cl_ss = (RoadClass)this.roadClasses.get(className);
        if (cl_ss == null) {
            return this.defaultRoadClass;
        }
        return cl_ss;
    }

    public int findUnusedRoadID() {
        return this.roads.findUnusedID();
    }

    public List displayPathOnRoad(Point start, Point end, Route route, List segments) {
        ArrayList newPoints;
        try {
            if (route == null) {
                RedPoint point = new RedPoint(start.x, start.y, 5);
                this.toDraw.add(point);
                point = new RedPoint(end.x, end.y, 5);
                this.toDraw.add(point);
                return null;
            }
            if (this.drawResults) {
                YellowPoint point = new YellowPoint(start.x, start.y, 10);
                this.toDraw.add(point);
                point = new YellowPoint(end.x, end.y, 10);
                this.toDraw.add(point);
            }
            newPoints = new ArrayList();
            this.populatePointsAndSegments(route, newPoints, segments);
            if (this.drawResults) {
                Point last = null;
                Point first = null;
                for (Point pt : newPoints) {
                    if (last != null) {
                        BlueLine line = new BlueLine(last.x, last.y, pt.x, pt.y);
                        this.toDraw.add(line);
                    }
                    if (first == null) {
                        first = pt;
                    }
                    last = pt;
                }
                if (first != null && last != null) {
                    YellowLine line = new YellowLine(start.x, start.y, first.x, first.y, 10);
                    this.toDraw.add(line);
                    line = new YellowLine(last.x, last.y, end.x, end.y, 10);
                    this.toDraw.add(line);
                }
            }
        }
        catch (Exception e) {
            this.logger.warning("Got exception " + e);
            e.printStackTrace();
            return null;
        }
        return newPoints;
    }

    public List getPathOnRoad(Point start, Point end, List segments) {
        List newPoints;
        try {
            Route bestRoute = this.getRouteBetweenPoints(start, end);
            newPoints = this.displayPathOnRoad(start, end, bestRoute, segments);
        }
        catch (Exception e) {
            this.logger.warning("Got exception " + e);
            e.printStackTrace();
            return null;
        }
        return newPoints;
    }

    public Route getPathOnRoad(LatLonPoint start, LatLonPoint end) {
        Intersection startTemp = this.findClosestIntersection(start);
        Intersection endTemp = this.findClosestIntersection(end);
        Route bestRoute = null;
        if (startTemp != null && endTemp != null) {
            if (this.roadClasses == null) {
                this.logger.warning("huh? road classes is null???");
                return bestRoute;
            }
            bestRoute = Route.getBestRoute(startTemp, endTemp, this.roadClasses.getBestConvoySpeed(), this.roadClasses.getWorstConvoySpeed());
        }
        if (bestRoute == null) {
            if (this.logger.isLoggable(Level.INFO)) {
                this.logger.info("no route from " + startTemp + " to " + endTemp);
            }
        } else if (this.logger.isLoggable(Level.INFO)) {
            this.logger.info("route from " + startTemp + " to " + endTemp + " is " + bestRoute);
        }
        if (this.logger.isLoggable(Level.INFO) && bestRoute != null) {
            float length = 0.0f;
            for (int i = 0; i < bestRoute.getRoads().length; ++i) {
                Road road = bestRoute.getRoads()[i];
                length = (float)((double)length + road.getLengthInKilometers());
            }
            this.logger.info("best route from " + bestRoute.getOriginIntersection() + " - start " + start + " to " + bestRoute.getDestinationIntersection() + " - end " + end + " was " + length + " kilometers.");
        }
        return bestRoute;
    }

    public Route getRouteBetweenPoints(Point start, Point end) {
        return this.getPathOnRoad(this.createLatLonPoint(start.x, start.y), this.createLatLonPoint(end.x, end.y));
    }

    protected Intersection findClosestIntersection(int x, int y) {
        return this.findClosestIntersection(this.createLatLonPoint(x, y));
    }

    protected Intersection findClosestIntersection(LatLonPoint latLon) {
        Intersection inter = (Intersection)this.interQuadTree.get(latLon.getLatitude(), latLon.getLongitude());
        if (inter == null) {
            this.logger.warning("no intersection at " + latLon);
        }
        return inter;
    }

    protected void populatePointsAndSegments(Route bestRoute, List newPoints, List segments) {
        Projection proj = this.getProjection();
        Intersection origin = bestRoute.getOriginIntersection();
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.info("adding " + bestRoute.roads.length + " new roads.");
        }
        Road road = null;
        Waypoint from = origin;
        Waypoint to = null;
        HashSet<Waypoint> loopSet = new HashSet<Waypoint>();
        if (this.doLoopCheck) {
            loopSet.add(origin);
        }
        HashSet<Point> ptSet = new HashSet<Point>();
        for (int i = 0; i < bestRoute.roads.length; ++i) {
            road = bestRoute.roads[i];
            if (!from.equals(road.getFirstIntersection()) && !from.equals(road.getSecondIntersection())) {
                this.logger.severe("huh? " + from + " is not an intersection on road " + road);
            }
            Point pt = this.createPoint((Point)proj.forward(from.getLocation(), new Point()));
            if (this.doLoopCheck) {
                if (ptSet.contains(pt)) {
                    this.logger.warning("pt set has duplicate at " + pt);
                }
                ptSet.add(pt);
            }
            newPoints.add(pt);
            to = road.getOtherIntersection((Intersection)from);
            if (this.doLoopCheck) {
                if (loopSet.contains(to)) {
                    this.logger.warning("road has a cycle at " + to);
                }
                loopSet.add(to);
            }
            boolean reverse = from.equals(road.getSecondIntersection());
            Segment path = this.getPathSegment(proj, road, reverse);
            if (this.logger.isLoggable(Level.INFO)) {
                this.logger.info("created path " + path);
            }
            segments.add(path);
            from = to;
        }
        if (to != null) {
            Point pt = this.createPoint((Point)proj.forward(to.getLocation(), new Point()));
            if (ptSet.contains(pt)) {
                this.logger.warning("pt set has duplicate at " + pt);
            }
            newPoints.add(pt);
            if (this.logger.isLoggable(Level.INFO)) {
                this.logger.info(" now " + newPoints.size() + " points and " + segments.size() + " segments.");
            }
        }
    }

    protected Segment getPathSegment(Projection proj, Road road, boolean reverse) {
        RoadPoint[] roadPoints = road.getRoadPoints();
        ArrayList<Point> newPoints = new ArrayList<Point>();
        if (reverse) {
            for (int i = roadPoints.length - 1; i > 0; --i) {
                newPoints.add(this.createPoint((Point)proj.forward(roadPoints[i].getLocation(), new Point())));
            }
        } else {
            for (int i = 0; i < roadPoints.length; ++i) {
                newPoints.add(this.createPoint((Point)proj.forward(roadPoints[i].getLocation(), new Point())));
            }
        }
        return this.createSegment(newPoints);
    }

    protected Segment createSegment(List newPoints) {
        return new Segment(newPoints);
    }

    protected Point createPoint(Point pt) {
        return new Point(pt);
    }

    public Projection getProjection() {
        return this.layer.getProjection();
    }

    protected void checkIntegrity() {
        Road road;
        PrintStream errors = System.err;
        Hashtable<Road, Object> otherIntersections = new Hashtable<Road, Object>();
        Object bothIntersections = new Object();
        Object inRoadsVector = new Object();
        Enumeration e = this.intersections.elements();
        while (e.hasMoreElements()) {
            Intersection intersection = (Intersection)e.nextElement();
            int nRoads = intersection.getRoadCount();
            if (nRoads == 0) {
                errors.println("Dangling intersection");
                errors.println("  Intersection = " + intersection);
                continue;
            }
            for (int i = 0; i < nRoads; ++i) {
                Road road2 = intersection.getRoad(i);
                Object other = otherIntersections.get(road2);
                if (other == null) {
                    otherIntersections.put(road2, road2.getOtherIntersection(intersection));
                    continue;
                }
                if (other == intersection) {
                    otherIntersections.put(road2, bothIntersections);
                    continue;
                }
                errors.println("Misconnected");
                errors.println("          Road = " + road2);
                errors.println("    Road.Other = " + other);
                errors.println("  Intersection = " + intersection);
            }
        }
        e = this.roads.elements();
        while (e.hasMoreElements()) {
            road = (Road)e.nextElement();
            Object other = otherIntersections.get(road);
            if (other == null) {
                errors.println("Road not found in intersections");
                errors.println("          Road = " + road);
            } else if (other != bothIntersections) {
                errors.println("Road incompletely connected");
                errors.println("          Road = " + road);
                errors.println("    Road.Other = " + other);
            } else if (other == inRoadsVector) {
                errors.println("Road doubly listed");
                errors.println("          Road = " + road);
            }
            otherIntersections.put(road, inRoadsVector);
        }
        e = otherIntersections.keys();
        while (e.hasMoreElements()) {
            road = (Road)e.nextElement();
            Object other = otherIntersections.get(road);
            if (other == inRoadsVector) continue;
            errors.println("Road not listed");
            errors.println("          Road = " + road);
        }
    }

    public boolean isEditing() {
        return false;
    }

    public static class RoadClasses
    extends Hashtable {
        float bestConvoySpeed = 0.0f;
        float worstConvoySpeed = Float.MAX_VALUE;

        public void put(RoadClass roadClass) {
            this.put(roadClass.getName(), roadClass);
            if (roadClass.getConvoySpeed() > this.bestConvoySpeed) {
                this.bestConvoySpeed = roadClass.getConvoySpeed();
            }
            if (roadClass.getConvoySpeed() < this.worstConvoySpeed) {
                this.worstConvoySpeed = roadClass.getConvoySpeed();
            }
        }

        public float getBestConvoySpeed() {
            return this.bestConvoySpeed;
        }

        public float getWorstConvoySpeed() {
            return this.worstConvoySpeed;
        }
    }

    public static class Intersections {
        private Hashtable intersections = new Hashtable();

        public void put(Intersection intersection) {
            int suffix = 0;
            String name = intersection.getName();
            while (this.intersections.containsKey(name)) {
                name = intersection.getName() + "," + ++suffix;
            }
            intersection.setName(name);
            this.intersections.put(name, intersection);
        }

        public void remove(Intersection intersection) {
            this.intersections.remove(intersection.getName());
        }

        public Intersection get(String name) {
            return (Intersection)this.intersections.get(name);
        }

        public Enumeration elements() {
            return this.intersections.elements();
        }

        public boolean contains(Intersection intersection) {
            return this.intersections.get(intersection.getName()) == intersection;
        }

        public void clear() {
            this.intersections.clear();
        }

        public int size() {
            return this.intersections.size();
        }
    }

    static class RoadVector {
        Road[] roads = new Road[0];
        private int look = 0;
        private int roadCount = 0;

        RoadVector() {
        }

        public void clear() {
            for (int i = 0; i < this.roads.length; ++i) {
                this.roads[i] = null;
            }
            this.look = 0;
            this.roadCount = 0;
        }

        public void add(Road r) {
            int id = r.getID();
            if (id >= this.roads.length) {
                Road[] oldRoads = this.roads;
                this.roads = new Road[id + 100 + this.roads.length];
                System.arraycopy(oldRoads, 0, this.roads, 0, oldRoads.length);
                for (int i = oldRoads.length; i < this.roads.length; ++i) {
                    this.roads[i] = null;
                }
            }
            if (this.roads[id] == null) {
                ++this.roadCount;
            }
            this.roads[id] = r;
        }

        public void remove(Road r) {
            int id = r.getID();
            if (this.roads[id] != null) {
                this.roads[id] = null;
                if (id < this.look) {
                    this.look = id;
                }
                --this.roadCount;
            }
        }

        public int findUnusedID() {
            while (this.look < this.roads.length && this.roads[this.look] != null) {
                ++this.look;
            }
            return this.look;
        }

        public Road elementAt(int n) {
            return this.roads[n];
        }

        public Enumeration elements() {
            return new Enumeration(){
                private int i = 0;

                public boolean hasMoreElements() {
                    while (this.i < RoadVector.this.roads.length) {
                        if (RoadVector.this.roads[this.i] != null) {
                            return true;
                        }
                        ++this.i;
                    }
                    return false;
                }

                public Object nextElement() {
                    return RoadVector.this.roads[this.i++];
                }
            };
        }

        public int size() {
            return this.roadCount;
        }
    }

    protected class BlueLine
    extends OMLine {
        int width;

        public BlueLine(int x, int y, int x2, int y2) {
            super(x, y, x2, y2);
            this.width = 5;
        }

        public void render(Graphics g) {
            float[] dash1 = new float[this.width + 1];
            dash1[0] = 10.0f;
            for (int i = 1; i < this.width; ++i) {
                dash1[i] = 2.0f;
            }
            BasicStroke dashed = new BasicStroke(5.0f, 0, 0, 10.0f, dash1, 0.0f);
            ((Graphics2D)g).setStroke(dashed);
            this.setGraphicsColor(g, Color.BLUE);
            this.draw(g, this.getShape());
        }
    }

    protected class RedPoint
    extends OMPoint {
        public RedPoint(int x, int y, int radius) {
            super(x, y, radius);
        }

        public void render(Graphics g) {
            this.setGraphicsColor(g, Color.RED);
            this.draw(g, this.getShape());
        }
    }

    protected class YellowLine
    extends OMLine {
        int width;

        public YellowLine(int x, int y, int x2, int y2, int width) {
            super(x, y, x2, y2);
            this.width = width;
        }

        public void render(Graphics g) {
            float[] dash1 = new float[this.width + 1];
            dash1[0] = 10.0f;
            for (int i = 1; i < this.width; ++i) {
                dash1[i] = 2.0f;
            }
            BasicStroke dashed = new BasicStroke(5.0f, 0, 0, 10.0f, dash1, 0.0f);
            ((Graphics2D)g).setStroke(dashed);
            this.setGraphicsColor(g, Color.YELLOW);
            this.draw(g, this.getShape());
        }
    }

    protected class YellowPoint
    extends OMPoint {
        public YellowPoint(int x, int y, int radius) {
            super(x, y, radius);
        }

        public void render(Graphics g) {
            this.setGraphicsColor(g, Color.YELLOW);
            this.draw(g, this.getShape());
        }
    }
}

