/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.time;

import com.bbn.openmap.OMComponent;
import com.bbn.openmap.time.RealTimeHandler;
import com.bbn.openmap.time.TimeBounds;
import com.bbn.openmap.time.TimeBoundsEvent;
import com.bbn.openmap.time.TimeBoundsHandler;
import com.bbn.openmap.time.TimeBoundsListener;
import com.bbn.openmap.time.TimeBoundsProvider;
import com.bbn.openmap.time.TimeEvent;
import com.bbn.openmap.time.TimeEventListener;
import com.bbn.openmap.time.TimerRateHolder;
import com.bbn.openmap.time.TimerStatus;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.beancontext.BeanContextChildSupport;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.swing.Timer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Clock
extends OMComponent
implements RealTimeHandler,
ActionListener,
PropertyChangeListener,
TimeBoundsHandler,
Serializable {
    public static final int DEFAULT_TIME_INTERVAL = 1000;
    public static final String TimeFormatProperty = "timeFormat";
    protected SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss");
    protected Timer timer;
    protected long startTime = Long.MAX_VALUE;
    protected long endTime = Long.MIN_VALUE;
    protected long time = 0L;
    protected int timeIncrement = 1000;
    protected boolean timeWrap = false;
    protected int clockDirection = 1;
    protected List<TimerRateHolder> timerRates;
    protected transient List<TimeBoundsProvider> timeBoundsProviders;
    protected transient List<TimeBoundsListener> timeBoundsListeners;
    protected transient List<TimeEventListener> timeEventListeners;
    protected int updateInterval = 1000;
    protected long systemTime = 0L;
    protected long simTime = 0L;

    public Clock() {
        this.beanContextChildSupport = new BeanContextChildSupport();
        this.createTimer();
        this.timerRates = new LinkedList<TimerRateHolder>();
        this.timeBoundsProviders = new Vector<TimeBoundsProvider>();
        this.timeBoundsListeners = new Vector<TimeBoundsListener>();
        this.timeEventListeners = new Vector<TimeEventListener>();
    }

    @Override
    public void setUpdateInterval(int delay) {
        this.updateInterval = delay;
        if (this.timer != null) {
            this.timer.setDelay(this.updateInterval);
            if (this.timer.isRunning()) {
                this.timer.restart();
            }
        }
    }

    @Override
    public int getUpdateInterval() {
        return this.updateInterval;
    }

    @Override
    public void setPace(int pace) {
        this.timeIncrement = pace;
    }

    @Override
    public int getPace() {
        return this.timeIncrement;
    }

    @Override
    public void setTime(long t) {
        this.setTime(t, TimerStatus.UPDATE);
    }

    protected void setTime(long t, TimerStatus timeStatus) {
        if (t == this.time) {
            return;
        }
        if (Debug.debugging("clock")) {
            Debug.output("Clock.setTime: " + t + " for " + timeStatus);
        }
        this.time = t;
        this.fireClockUpdate(timeStatus);
    }

    protected void fireClockUpdate(TimerStatus timerStatus) {
        this.fireUpdateTime(TimeEvent.create(this, this.time, this.systemTime, this.simTime, timerStatus));
    }

    @Override
    public long getTime() {
        return this.time;
    }

    @Override
    public void startClock() {
        if (!this.timer.isRunning()) {
            this.firePropertyChange("TIMER_STATUS_PROPERTY", TimerStatus.STOPPED, this.getClockDirection() > 0 ? TimerStatus.FORWARD : TimerStatus.BACKWARD);
            this.fireClockUpdate(this.getClockDirection() > 0 ? TimerStatus.FORWARD : TimerStatus.BACKWARD);
        }
        if (Debug.debugging("clock")) {
            Debug.output("Clock: Starting clock");
        }
        this.timer.restart();
    }

    @Override
    public void stopClock() {
        if (this.timer.isRunning()) {
            this.firePropertyChange("TIMER_STATUS_PROPERTY", this.getClockDirection() > 0 ? TimerStatus.FORWARD : TimerStatus.BACKWARD, TimerStatus.STOPPED);
            this.fireClockUpdate(TimerStatus.STOPPED);
            this.timer.stop();
        }
    }

    @Override
    public void setClockDirection(int direction) {
        TimerStatus newDirection;
        TimerStatus oldDirection = this.clockDirection > 0 ? TimerStatus.FORWARD : TimerStatus.BACKWARD;
        this.clockDirection = direction >= 0 ? 1 : -1;
        TimerStatus timerStatus = newDirection = this.clockDirection > 0 ? TimerStatus.FORWARD : TimerStatus.BACKWARD;
        if (this.timer.isRunning() && oldDirection != newDirection) {
            this.firePropertyChange("TIMER_STATUS_PROPERTY", oldDirection, newDirection);
            this.fireClockUpdate(newDirection);
        }
    }

    @Override
    public int getClockDirection() {
        return this.clockDirection;
    }

    @Override
    public void stepForward() {
        this.changeTimeBy(this.timeIncrement, this.timeWrap, TimerStatus.STEP_FORWARD);
    }

    @Override
    public void stepBackward() {
        this.changeTimeBy(-this.timeIncrement, this.timeWrap, TimerStatus.STEP_BACKWARD);
    }

    protected void changeTimeBy(long amount) {
        this.changeTimeBy(amount, this.timeWrap, amount >= 0L ? TimerStatus.FORWARD : TimerStatus.BACKWARD);
    }

    protected void changeTimeBy(long amount, boolean wrapAroundTimeLimits) {
        this.changeTimeBy(amount, wrapAroundTimeLimits, amount >= 0L ? TimerStatus.FORWARD : TimerStatus.BACKWARD);
    }

    protected void changeTimeBy(long amount, boolean wrapAroundTimeLimits, TimerStatus timeStatus) {
        long oldTime = this.getTime();
        boolean stopClock = false;
        long newTime = oldTime + amount;
        if (newTime > this.endTime || newTime < this.startTime) {
            if (wrapAroundTimeLimits) {
                newTime = amount >= 0L ? this.startTime : this.endTime;
            } else {
                newTime = amount >= 0L ? this.endTime : this.startTime;
                stopClock = true;
            }
        }
        if (Debug.debugging("clock")) {
            Debug.output("Clock " + (stopClock ? "stopping clock at (" + newTime : "changing time by [" + amount + "] to (" + newTime) + ") : " + timeStatus);
        }
        this.setTime(newTime, timeStatus);
        if (stopClock) {
            this.stopClock();
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.getTimer()) {
            this.changeTimeBy(this.timeIncrement * this.clockDirection, this.timeWrap, this.clockDirection < 0 ? TimerStatus.UPDATE : TimerStatus.FORWARD);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        this.resetTimeBounds();
    }

    @Override
    public void addTimeBoundsProvider(TimeBoundsProvider tbp) {
        if (!this.timeBoundsProviders.contains(tbp)) {
            this.timeBoundsProviders.add(tbp);
            this.resetTimeBounds();
        }
    }

    @Override
    public void removeTimeBoundsProvider(TimeBoundsProvider tbp) {
        this.timeBoundsProviders.remove(tbp);
        this.resetTimeBounds();
    }

    @Override
    public void clearTimeBoundsProviders() {
        this.timeBoundsProviders.clear();
        this.resetTimeBounds();
    }

    public void addTimeBoundsListener(TimeBoundsListener tbl) {
        if (!this.timeBoundsListeners.contains(tbl)) {
            this.timeBoundsListeners.add(tbl);
        }
    }

    public void removeTimeBoundsListener(TimeBoundsListener tbl) {
        this.timeBoundsListeners.remove(tbl);
    }

    public void clearTimeBoundsListeners() {
        this.timeBoundsListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireUpdateTimeBounds(TimeBoundsEvent tbe) {
        if (this.timeBoundsListeners != null) {
            ArrayList<TimeBoundsListener> copy;
            List<TimeBoundsListener> list = this.timeBoundsListeners;
            synchronized (list) {
                copy = new ArrayList<TimeBoundsListener>(this.timeBoundsListeners);
            }
            Iterator it = copy.iterator();
            while (it.hasNext()) {
                ((TimeBoundsListener)it.next()).updateTimeBounds(tbe);
            }
        }
    }

    @Override
    public void addTimeEventListener(TimeEventListener tel) {
        if (!this.timeEventListeners.contains(tel)) {
            this.timeEventListeners.add(tel);
        }
    }

    @Override
    public void removeTimeEventListener(TimeEventListener tel) {
        this.timeEventListeners.remove(tel);
    }

    public void clearTimeEventListeners() {
        this.timeEventListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireUpdateTime(TimeEvent te) {
        if (this.timeEventListeners != null) {
            ArrayList<TimeEventListener> copy;
            List<TimeEventListener> list = this.timeEventListeners;
            synchronized (list) {
                copy = new ArrayList<TimeEventListener>(this.timeEventListeners);
            }
            Iterator it = copy.iterator();
            while (it.hasNext()) {
                ((TimeEventListener)it.next()).updateTime(te);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetTimeBounds() {
        ArrayList<TimeBoundsProvider> copy;
        TimeBounds oldtb = new TimeBounds(this.startTime, this.endTime);
        this.startTime = Long.MAX_VALUE;
        this.endTime = Long.MIN_VALUE;
        int activeTimeBoundsProviderCount = 0;
        List<TimeBoundsProvider> list = this.timeBoundsProviders;
        synchronized (list) {
            copy = new ArrayList<TimeBoundsProvider>(this.timeBoundsProviders);
        }
        for (TimeBoundsProvider tbp : copy) {
            if (tbp.isActive()) {
                ++activeTimeBoundsProviderCount;
                TimeBounds bounds = tbp.getTimeBounds();
                if (bounds == null || bounds.isUnset()) continue;
                this.addTime(bounds.getStartTime());
                this.addTime(bounds.getEndTime());
                if (!Debug.debugging("clock")) continue;
                Debug.output("Clock.resetTimeBounds(" + tbp.getClass().getName() + ") adding " + bounds);
                continue;
            }
            if (!Debug.debugging("clock")) continue;
            Debug.output("Clock.resetTimeBounds(" + tbp.getClass().getName() + ") not active");
        }
        this.systemTime = this.startTime;
        TimeBounds tb = new TimeBounds(this.startTime, this.endTime);
        Iterator it = copy.iterator();
        while (it.hasNext()) {
            ((TimeBoundsProvider)it.next()).handleTimeBounds(tb);
        }
        long currentTime = this.time;
        if (activeTimeBoundsProviderCount == 0) {
            this.setTime(this.startTime);
        } else if (currentTime < this.startTime || currentTime == Long.MAX_VALUE) {
            this.setTime(this.startTime);
        } else if (currentTime > this.endTime) {
            this.setTime(this.endTime);
        }
        this.fireUpdateTimeBounds(new TimeBoundsEvent(this, tb, oldtb));
        if (tb.isUnset()) {
            this.fireUpdateTime(TimeEvent.NO_TIME);
        }
    }

    public void addTimeToBounds(long timeStamp) {
        long oldStartTime = this.startTime;
        long oldEndTime = this.endTime;
        this.addTime(timeStamp);
        if (oldStartTime != this.startTime || oldEndTime != this.endTime) {
            this.fireUpdateTimeBounds(new TimeBoundsEvent(this, new TimeBounds(oldStartTime, oldEndTime), new TimeBounds(this.startTime, this.endTime)));
        }
    }

    protected void addTime(long timeStamp) {
        if (timeStamp < this.startTime) {
            if (Debug.debugging("clock")) {
                Debug.output("Clock: setting startTime: " + timeStamp);
            }
            this.startTime = timeStamp;
        }
        if (timeStamp > this.endTime) {
            if (Debug.debugging("clock")) {
                Debug.output("Clock: setting endTime: " + timeStamp);
            }
            this.endTime = timeStamp;
        }
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setBaseTimesForTimeEvent(long sysTime, long simulationTime) {
        this.systemTime = sysTime;
        this.simTime = simulationTime;
    }

    public long getSimTime() {
        return this.simTime;
    }

    public long getSystemTime() {
        return this.systemTime;
    }

    public Timer getTimer() {
        return this.timer;
    }

    public void setTimer(Timer t) {
        if (this.timer != null) {
            this.timer.stop();
            this.timer.removeActionListener(this);
        }
        this.timer = t;
        if (this.timer != null) {
            this.timer.removeActionListener(this);
            this.timer.addActionListener(this);
        }
    }

    public void createTimer() {
        Timer t = new Timer(this.updateInterval, this);
        t.setInitialDelay(0);
        this.setTimer(t);
    }

    public List<TimerRateHolder> getTimerRates() {
        return this.timerRates;
    }

    public void setTimerRates(List<TimerRateHolder> rates) {
        this.timerRates = rates;
    }

    @Override
    public void setProperties(String prefix, Properties properties) {
        super.setProperties(prefix, properties);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        String timeFormatString = properties.getProperty(prefix + TimeFormatProperty, this.timeFormat.toPattern());
        this.timeFormat = new SimpleDateFormat(timeFormatString);
        this.timerRates = TimerRateHolder.getTimerRateHolders(prefix, properties);
    }

    @Override
    public void findAndInit(Object someObj) {
        super.findAndInit(someObj);
        if (someObj instanceof TimeBoundsProvider) {
            if (Debug.debugging("clock")) {
                Debug.output("Clock.findAndInit(TimeBoundsProvider): " + someObj.getClass().getName());
            }
            this.addTimeBoundsProvider((TimeBoundsProvider)someObj);
        }
    }

    @Override
    public void findAndUndo(Object someObj) {
        super.findAndUndo(someObj);
        if (someObj instanceof TimeBoundsProvider) {
            this.removeTimeBoundsProvider((TimeBoundsProvider)someObj);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        if (Debug.debugging("clock")) {
            Debug.output("Clock: adding property change listener");
        }
        super.addPropertyChangeListener("TIMER_STATUS_PROPERTY", pcl);
        this.initializePropertyChangeListener(pcl);
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener pcl) {
        super.addPropertyChangeListener(propertyName, pcl);
        this.initializePropertyChangeListener(pcl);
    }

    protected void initializePropertyChangeListener(PropertyChangeListener pcl) {
        TimerStatus runningStatus = this.timer.isRunning() ? (this.getClockDirection() > 0 ? TimerStatus.FORWARD : TimerStatus.BACKWARD) : TimerStatus.STOPPED;
        this.firePropertyChange("TIMER_STATUS_PROPERTY", null, runningStatus);
        this.fireClockUpdate(runningStatus);
    }

    public boolean isRunning() {
        return this.timer.isRunning();
    }
}

