/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.proj;

import com.bbn.openmap.Environment;
import com.bbn.openmap.proj.DrawUtil;
import com.bbn.openmap.proj.GreatCircle;
import com.bbn.openmap.proj.Length;
import com.bbn.openmap.proj.Mercator;
import com.bbn.openmap.proj.Planet;
import com.bbn.openmap.proj.Proj;
import com.bbn.openmap.proj.ProjMath;
import com.bbn.openmap.proj.RhumbCalculator;
import com.bbn.openmap.proj.coords.GeoCoordTransformation;
import com.bbn.openmap.proj.coords.LatLonGCT;
import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.util.Debug;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GeoProj
extends Proj {
    protected static transient int NUM_DEFAULT_CIRCLE_VERTS = 64;
    public static final transient float NORTH_POLE = 1.5707964f;
    public static final transient float SOUTH_POLE = -1.5707964f;
    public static final transient float DATELINE = (float)Math.PI;
    protected static transient int NUM_DEFAULT_GREAT_SEGS = 512;
    protected double pixelsPerMeter;
    protected double planetRadius;
    protected double planetPixelRadius;
    protected double planetPixelCircumference;
    protected double scaled_radius;
    protected Mercator mercator = null;
    protected static transient int XTHRESHOLD = 16384;
    protected transient int XSCALE_THRESHOLD = 1000000;

    public GeoProj(LatLonPoint center, float s, int w, int h) {
        super(center, s, w, h);
        if (!(this instanceof Mercator)) {
            this.mercator = new Mercator(center, (float)this.scale, this.width, this.height);
        }
    }

    @Override
    protected void init() {
        this.centerX = GeoProj.wrapLongitude(Math.toRadians(this.centerX));
        this.centerY = this.normalizeLatitude(Math.toRadians(this.centerY));
        this.pixelsPerMeter = Planet.defaultPixelsPerMeter;
        this.planetRadius = 6378137.0;
        this.planetPixelRadius = this.planetRadius * this.pixelsPerMeter;
        this.planetPixelCircumference = Math.PI * 2 * this.planetPixelRadius;
        this.scaled_radius = this.planetPixelRadius / this.scale;
        this.maxscale = this.planetPixelCircumference / (double)this.width;
    }

    public void setPPM(double ppm) {
        this.pixelsPerMeter = ppm;
        if (this.pixelsPerMeter < 1.0) {
            this.pixelsPerMeter = 1.0;
        }
        this.computeParameters();
    }

    public double getPPM() {
        return this.pixelsPerMeter;
    }

    public void setPlanetRadius(double radius) {
        this.planetRadius = radius;
        if (this.planetRadius < 1.0) {
            this.planetRadius = 1.0;
        }
        this.computeParameters();
    }

    public double getPlanetRadius() {
        return this.planetRadius;
    }

    public double getPlanetPixelRadius() {
        return this.planetPixelRadius;
    }

    public double getPlanetPixelCircumference() {
        return this.planetPixelCircumference;
    }

    public void setCenter(float lat, float lon) {
        this.setCenter(lat, lon, false);
    }

    @Override
    public void setCenter(double lat, double lon) {
        this.setCenter(lat, lon, false);
    }

    public void setCenter(double lat, double lon, boolean isRadians) {
        if (!isRadians) {
            lat = Math.toRadians(lat);
            lon = Math.toRadians(lon);
        }
        this.centerX = GeoProj.wrapLongitude(lon);
        this.centerY = this.normalizeLatitude(lat);
        this.computeParameters();
        this.projID = null;
    }

    @Override
    public LatLonPoint getCenter() {
        return new LatLonPoint.Double(this.centerY, this.centerX, true);
    }

    @Override
    public <T extends Point2D> T getCenter(T center) {
        center.setLocation(Math.toDegrees(this.centerX), Math.toDegrees(this.centerY));
        return center;
    }

    public float normalizeLatitude(float lat) {
        return (float)this.normalizeLatitude((double)lat);
    }

    public abstract double normalizeLatitude(double var1);

    public static final float wrapLongitude(float lon) {
        return ProjMath.wrapLongitude(lon);
    }

    public static final double wrapLongitude(double lon) {
        return ProjMath.wrapLongitude(lon);
    }

    public static final double wrapLongitudeDeg(double lon) {
        return ProjMath.wrapLongitudeDeg(lon);
    }

    public final double normalize_latitude(double lat) {
        return this.normalizeLatitude(lat);
    }

    public static final double wrap_longitude(double lon) {
        return GeoProj.wrapLongitude(lon);
    }

    @Override
    public void pan(double Az, double c) {
        this.setCenter(RhumbCalculator.calculatePointOnRhumbLine(this.getCenter(), Math.toRadians(Az), Math.toRadians(c)));
    }

    @Override
    public void pan(double Az) {
        double angle = Math.toRadians(90.0 - Az);
        int w2 = this.getWidth() / 2;
        int h2 = this.getHeight() / 2;
        LatLonPoint newLoc = this.inverse((double)w2 + (double)w2 * Math.cos(angle), (double)h2 + (double)h2 * Math.sin(angle));
        double dist = RhumbCalculator.getDistanceBetweenPoints(this.getCenter(), newLoc);
        this.pan(Az, Math.toDegrees(dist));
    }

    @Override
    public String toString() {
        return " radius=" + this.planetRadius + " ppm=" + this.pixelsPerMeter + " center(" + this.centerY + ":" + this.centerX + ") scale=" + this.scale + " maxscale=" + this.maxscale + " minscale=" + this.minscale + " width=" + this.width + " height=" + this.height + "]";
    }

    @Override
    public Object clone() {
        GeoProj proj = (GeoProj)super.clone();
        if (this.mercator != null) {
            proj.mercator = (Mercator)this.mercator.clone();
        }
        return proj;
    }

    @Override
    public boolean isPlotable(Point2D point) {
        if (point instanceof LatLonPoint) {
            return this.isPlotable(point.getY(), point.getX());
        }
        return false;
    }

    protected ArrayList<float[]> forwardRhumbPoly(float[] rawllpts, int nsegs, boolean isFilled) {
        if (this instanceof Mercator) {
            return this._forwardPoly(rawllpts, 1, nsegs, isFilled);
        }
        int flag = 0;
        int xadj = 0;
        int totalpts = 0;
        Point from = new Point(0, 0);
        Point to = new Point(0, 0);
        int len = rawllpts.length;
        float[][] augllpts = new float[len >>> 1][0];
        this.mercator.forward(rawllpts[0], rawllpts[1], (Point2D)from, true);
        int xp = from.x;
        int i = 0;
        for (int n = 2; n < len; n += 2) {
            this.mercator.forward(rawllpts[n], rawllpts[n + 1], (Point2D)to, true);
            if (Math.abs(xp - to.x) >= this.mercator.half_world) {
                xadj = (flag += xp < to.x ? -1 : 1) * this.mercator.world.x;
            }
            xp = to.x;
            if (flag != 0) {
                to.x += xadj;
            }
            augllpts[i] = this.mercator.rhumbProject(from, to, false, nsegs);
            totalpts += augllpts[i].length;
            from.x = to.x;
            from.y = to.y;
            ++i;
        }
        LatLonPoint.Double llp = new LatLonPoint.Double();
        this.mercator.inverse(from.x, from.y, llp);
        augllpts[i] = new float[2];
        augllpts[i][0] = (float)((LatLonPoint)llp).getRadLat();
        augllpts[i][1] = (float)((LatLonPoint)llp).getRadLon();
        float[] newllpts = new float[totalpts += 2];
        int pos = 0;
        for (i = 0; i < augllpts.length; ++i) {
            System.arraycopy(augllpts[i], 0, newllpts, pos, augllpts[i].length);
            pos += augllpts[i].length;
        }
        augllpts = null;
        return this._forwardPoly(newllpts, 1, -1, isFilled);
    }

    protected ArrayList<float[]> forwardRhumbPoly(double[] rawllpts, int nsegs, boolean isFilled) {
        if (this instanceof Mercator) {
            return this._forwardPoly(rawllpts, 1, nsegs, isFilled);
        }
        int flag = 0;
        int xadj = 0;
        int totalpts = 0;
        Point from = new Point(0, 0);
        Point to = new Point(0, 0);
        int len = rawllpts.length;
        double[][] augllpts = new double[len >>> 1][0];
        this.mercator.forward(rawllpts[0], rawllpts[1], (Point2D)from, true);
        int xp = from.x;
        int i = 0;
        for (int n = 2; n < len; n += 2) {
            this.mercator.forward(rawllpts[n], rawllpts[n + 1], (Point2D)to, true);
            if (Math.abs(xp - to.x) >= this.mercator.half_world) {
                xadj = (flag += xp < to.x ? -1 : 1) * this.mercator.world.x;
            }
            xp = to.x;
            if (flag != 0) {
                to.x += xadj;
            }
            augllpts[i] = this.mercator.rhumbProjectDouble(from, to, false, nsegs);
            totalpts += augllpts[i].length;
            from.x = to.x;
            from.y = to.y;
            ++i;
        }
        LatLonPoint.Double llp = new LatLonPoint.Double();
        this.mercator.inverse(from, llp);
        augllpts[i] = new double[2];
        augllpts[i][0] = ((LatLonPoint)llp).getRadLat();
        augllpts[i][1] = ((LatLonPoint)llp).getRadLon();
        double[] newllpts = new double[totalpts += 2];
        int pos = 0;
        for (i = 0; i < augllpts.length; ++i) {
            System.arraycopy(augllpts[i], 0, newllpts, pos, augllpts[i].length);
            pos += augllpts[i].length;
        }
        augllpts = null;
        return this._forwardPoly(newllpts, 1, -1, isFilled);
    }

    protected ArrayList<float[]> forwardGreatPoly(float[] rawllpts, int nsegs, boolean isFilled) {
        int totalpts = 0;
        Point from = new Point();
        Point to = new Point();
        int end = rawllpts.length >>> 1;
        float[][] augllpts = new float[end][0];
        --end;
        this.forward(rawllpts[0], rawllpts[1], (Point2D)from, true);
        int i = 0;
        int j = 0;
        int k = 2;
        while (i < end) {
            this.forward(rawllpts[k], rawllpts[k + 1], (Point2D)to, true);
            augllpts[i] = this.getGreatVertices(rawllpts[j], rawllpts[j + 1], rawllpts[k], rawllpts[k + 1], from, to, false, nsegs);
            from.x = to.x;
            from.y = to.y;
            totalpts += augllpts[i].length;
            ++i;
            j += 2;
            k += 2;
        }
        augllpts[i] = new float[2];
        augllpts[i][0] = rawllpts[j];
        augllpts[i][1] = rawllpts[j + 1];
        float[] newllpts = new float[totalpts += 2];
        int pos = 0;
        for (i = 0; i < augllpts.length; ++i) {
            System.arraycopy(augllpts[i], 0, newllpts, pos, augllpts[i].length);
            pos += augllpts[i].length;
        }
        augllpts = null;
        return this._forwardPoly(newllpts, 1, -1, isFilled);
    }

    protected ArrayList<float[]> forwardGreatPoly(double[] rawllpts, int nsegs, boolean isFilled) {
        int totalpts = 0;
        Point from = new Point();
        Point to = new Point();
        int end = rawllpts.length >>> 1;
        double[][] augllpts = new double[end][0];
        --end;
        this.forward(rawllpts[0], rawllpts[1], (Point2D)from, true);
        int i = 0;
        int j = 0;
        int k = 2;
        while (i < end) {
            this.forward(rawllpts[k], rawllpts[k + 1], (Point2D)to, true);
            augllpts[i] = this.getGreatVertices(rawllpts[j], rawllpts[j + 1], rawllpts[k], rawllpts[k + 1], from, to, false, nsegs);
            from.x = to.x;
            from.y = to.y;
            totalpts += augllpts[i].length;
            ++i;
            j += 2;
            k += 2;
        }
        augllpts[i] = new double[2];
        augllpts[i][0] = rawllpts[j];
        augllpts[i][1] = rawllpts[j + 1];
        double[] newllpts = new double[totalpts += 2];
        int pos = 0;
        for (i = 0; i < augllpts.length; ++i) {
            System.arraycopy(augllpts[i], 0, newllpts, pos, augllpts[i].length);
            pos += augllpts[i].length;
        }
        augllpts = null;
        return this._forwardPoly(newllpts, 1, -1, isFilled);
    }

    private float[] getGreatVertices(float latp, float lonp, float latn, float lonn, Point from, Point to, boolean include_last, int nsegs) {
        if (nsegs < 1) {
            int dist = DrawUtil.pixel_distance(from.x, from.y, to.x, to.y);
            nsegs = dist >> 3;
            if (nsegs == 0) {
                nsegs = 1;
            } else if (nsegs > NUM_DEFAULT_GREAT_SEGS) {
                nsegs = NUM_DEFAULT_GREAT_SEGS;
            }
        }
        return GreatCircle.greatCircle(latp, lonp, latn, lonn, nsegs, include_last);
    }

    private double[] getGreatVertices(double latp, double lonp, double latn, double lonn, Point from, Point to, boolean include_last, int nsegs) {
        if (nsegs < 1) {
            int dist = DrawUtil.pixel_distance(from.x, from.y, to.x, to.y);
            nsegs = dist >> 3;
            if (nsegs == 0) {
                nsegs = 1;
            } else if (nsegs > NUM_DEFAULT_GREAT_SEGS) {
                nsegs = NUM_DEFAULT_GREAT_SEGS;
            }
        }
        return GreatCircle.greatCircle(latp, lonp, latn, lonn, nsegs, include_last);
    }

    public boolean isComplicatedLineType(int ltype) {
        switch (ltype) {
            case 1: {
                return false;
            }
            case 2: {
                return this.getClass() != Mercator.class;
            }
            case 3: {
                return true;
            }
        }
        Debug.error("Proj.isComplicatedLineType: invalid LineType!");
        return false;
    }

    protected ArrayList<float[]> doPolyDispatch(float[] rawllpts, int ltype, int nsegs, boolean isFilled) {
        switch (ltype) {
            case 2: {
                return this.forwardRhumbPoly(rawllpts, nsegs, isFilled);
            }
            case 3: {
                return this.forwardGreatPoly(rawllpts, nsegs, isFilled);
            }
            case 1: {
                Debug.error("Proj.doPolyDispatch: Bad Dispatch!\n");
                return new ArrayList<float[]>(0);
            }
        }
        Debug.error("Proj.doPolyDispatch: Invalid LType!\n");
        return new ArrayList<float[]>(0);
    }

    protected ArrayList<float[]> doPolyDispatch(double[] rawllpts, int ltype, int nsegs, boolean isFilled) {
        switch (ltype) {
            case 2: {
                return this.forwardRhumbPoly(rawllpts, nsegs, isFilled);
            }
            case 3: {
                return this.forwardGreatPoly(rawllpts, nsegs, isFilled);
            }
            case 1: {
                Debug.error("Proj.doPolyDispatch: Bad Dispatch!\n");
                return new ArrayList<float[]>(0);
            }
        }
        Debug.error("Proj.doPolyDispatch: Invalid LType!\n");
        return new ArrayList<float[]>(0);
    }

    @Override
    public float getScale(Point2D ll1, Point2D ll2, Point2D point1, Point2D point2) {
        try {
            double lon2;
            double lon1;
            double dx = Math.abs(point2.getX() - point1.getX());
            double dy = Math.abs(point2.getY() - point1.getY());
            if (point1.getX() > point2.getX()) {
                double lat1 = ll1.getY();
                lon1 = ll1.getX();
                ll1.setLocation(ll2);
                ll2.setLocation(lon1, lat1);
            }
            double dlon = (lon1 = ll1.getX()) > (lon2 = ll2.getX()) ? 180.0 - lon1 + (180.0 + lon2) : lon2 - lon1;
            double deltaDegrees = dlon;
            double deltaPix = dx;
            double pixPerDegree = this.getPlanetPixelCircumference() / 360.0;
            return (float)(pixPerDegree / ((double)this.getWidth() / deltaDegrees));
        }
        catch (NullPointerException npe) {
            Debug.error("ProjMath.getScale(): caught null pointer exception.");
            return Float.MAX_VALUE;
        }
    }

    @Override
    public Point2D forward(Point2D llp, Point2D pt) {
        return this.forward(llp.getY(), llp.getX(), pt, false);
    }

    @Override
    public Point2D forward(Point2D llp) {
        return this.forward(llp.getY(), llp.getX(), (Point2D)new Point2D.Double(), false);
    }

    @Override
    public Point2D forward(double lat, double lon, Point2D pt) {
        return this.forward(lat, lon, pt, false);
    }

    public Point2D forward(float lat, float lon, Point2D pt, boolean isRadian) {
        return this.forward((double)lat, (double)lon, pt, isRadian);
    }

    public abstract Point2D forward(double var1, double var3, Point2D var5, boolean var6);

    @Override
    public LatLonPoint inverse(Point2D point) {
        return this.inverse(point.getX(), point.getY(), new LatLonPoint.Double());
    }

    @Override
    public LatLonPoint inverse(double x, double y) {
        return this.inverse(x, y, new LatLonPoint.Double());
    }

    protected LatLonPoint assertLatLonPoint(Point2D p2d) {
        if (p2d instanceof LatLonPoint) {
            return (LatLonPoint)p2d;
        }
        return new LatLonPoint.Double(p2d.getY(), p2d.getX());
    }

    public ArrayList<float[]> forwardLine(LatLonPoint ll1, LatLonPoint ll2, int ltype, int nsegs) {
        double[] rawllpts = new double[]{ll1.getRadLat(), ll1.getRadLon(), ll2.getRadLat(), ll2.getRadLon()};
        return this.forwardPoly(rawllpts, ltype, nsegs, false);
    }

    public ArrayList<float[]> forwardLine(LatLonPoint ll1, LatLonPoint ll2, int ltype) {
        return this.forwardLine(ll1, ll2, ltype, -1);
    }

    public ArrayList<float[]> forwardRect(LatLonPoint ll1, LatLonPoint ll2, int ltype, int nsegs, boolean isFilled) {
        double[] rawllpts = new double[]{ll1.getRadLat(), ll1.getRadLon(), ll1.getRadLat(), ll2.getRadLon(), ll2.getRadLat(), ll2.getRadLon(), ll2.getRadLat(), ll1.getRadLon(), ll1.getRadLat(), ll1.getRadLon()};
        return this.forwardPoly(rawllpts, ltype, nsegs, isFilled);
    }

    public ArrayList<float[]> forwardRect(LatLonPoint ll1, LatLonPoint ll2, int ltype) {
        return this.forwardRect(ll1, ll2, ltype, -1, false);
    }

    public ArrayList<float[]> forwardRect(LatLonPoint ll1, LatLonPoint ll2, int ltype, int nsegs) {
        return this.forwardRect(ll1, ll2, ltype, nsegs, false);
    }

    public ArrayList<float[]> forwardArc(LatLonPoint c, boolean radians, double radius, double start, double extent) {
        return this.forwardArc(c, radians, radius, -1, start, extent, 0);
    }

    public ArrayList<float[]> forwardArc(LatLonPoint c, boolean radians, double radius, int nverts, double start, double extent) {
        return this.forwardArc(c, radians, radius, nverts, start, extent, 0);
    }

    public ArrayList<float[]> forwardArc(LatLonPoint c, boolean radians, double radius, int nverts, double start, double extent, int arcType) {
        double[] rawllpts;
        if (nverts < 3) {
            nverts = NUM_DEFAULT_CIRCLE_VERTS;
        }
        switch (arcType) {
            case 2: {
                rawllpts = new double[(nverts << 1) + 4];
                break;
            }
            case 1: {
                rawllpts = new double[(nverts << 1) + 2];
                break;
            }
            default: {
                rawllpts = new double[nverts << 1];
            }
        }
        GreatCircle.earthCircle(c.getRadLat(), c.getRadLon(), radians ? radius : ProjMath.degToRad(radius), radians ? start : ProjMath.degToRad(start), radians ? extent : ProjMath.degToRad(extent), nverts, rawllpts);
        int linetype = 1;
        boolean isFilled = false;
        switch (arcType) {
            case 2: {
                rawllpts[rawllpts.length - 4] = c.getRadLat();
                rawllpts[rawllpts.length - 3] = c.getRadLon();
            }
            case 1: {
                rawllpts[rawllpts.length - 2] = rawllpts[0];
                rawllpts[rawllpts.length - 1] = rawllpts[1];
                linetype = 3;
                isFilled = true;
                break;
            }
        }
        return this.forwardPoly(rawllpts, linetype, -1, isFilled);
    }

    public ArrayList<float[]> forwardCircle(LatLonPoint c, boolean radians, double radius) {
        return this.forwardCircle(c, radians, radius, -1, false);
    }

    public ArrayList<float[]> forwardCircle(LatLonPoint c, boolean radians, double radius, int nverts) {
        return this.forwardCircle(c, radians, radius, nverts, false);
    }

    public ArrayList<float[]> forwardCircle(LatLonPoint c, boolean radians, double radius, int nverts, boolean isFilled) {
        if (nverts < 3) {
            nverts = NUM_DEFAULT_CIRCLE_VERTS;
        }
        double[] rawllpts = new double[(nverts << 1) + 2];
        GreatCircle.earthCircle(c.getRadLat(), c.getRadLon(), radians ? radius : ProjMath.degToRad(radius), nverts, rawllpts);
        rawllpts[rawllpts.length - 2] = rawllpts[0];
        rawllpts[rawllpts.length - 1] = rawllpts[1];
        return this.forwardPoly(rawllpts, 1, -1, isFilled);
    }

    public ArrayList<float[]> forwardPoly(float[] rawllpts, int ltype, int nsegs, boolean isFilled) {
        ArrayList<float[]> stuff = this._forwardPoly(rawllpts, ltype, nsegs, isFilled);
        if (Environment.doingXWindowsWorkaround && this.scale <= (double)this.XSCALE_THRESHOLD) {
            int size = stuff.size();
            for (int i = 0; i < size; i += 2) {
                float[] xpts = stuff.get(i);
                float[] ypts = stuff.get(i + 1);
                for (int j = 0; j < xpts.length; ++j) {
                    if (xpts[j] <= (float)(-XTHRESHOLD)) {
                        xpts[j] = -XTHRESHOLD;
                    } else if (xpts[j] >= (float)XTHRESHOLD) {
                        xpts[j] = XTHRESHOLD;
                    }
                    if (ypts[j] <= (float)(-XTHRESHOLD)) {
                        ypts[j] = -XTHRESHOLD;
                        continue;
                    }
                    if (!(ypts[j] >= (float)XTHRESHOLD)) continue;
                    ypts[j] = XTHRESHOLD;
                }
                stuff.set(i, xpts);
                stuff.set(i + 1, ypts);
            }
        }
        return stuff;
    }

    public ArrayList<float[]> forwardPoly(double[] rawllpts, int ltype, int nsegs, boolean isFilled) {
        ArrayList<float[]> stuff = this._forwardPoly(rawllpts, ltype, nsegs, isFilled);
        if (Environment.doingXWindowsWorkaround && this.scale <= (double)this.XSCALE_THRESHOLD) {
            int size = stuff.size();
            for (int i = 0; i < size; i += 2) {
                float[] xpts = stuff.get(i);
                float[] ypts = stuff.get(i + 1);
                for (int j = 0; j < xpts.length; ++j) {
                    if (xpts[j] <= (float)(-XTHRESHOLD)) {
                        xpts[j] = -XTHRESHOLD;
                    } else if (xpts[j] >= (float)XTHRESHOLD) {
                        xpts[j] = XTHRESHOLD;
                    }
                    if (ypts[j] <= (float)(-XTHRESHOLD)) {
                        ypts[j] = -XTHRESHOLD;
                        continue;
                    }
                    if (!(ypts[j] >= (float)XTHRESHOLD)) continue;
                    ypts[j] = XTHRESHOLD;
                }
                stuff.set(i, xpts);
                stuff.set(i + 1, ypts);
            }
        }
        return stuff;
    }

    public ArrayList<float[]> forwardLLPoly(double[] llpts, int ltype, int nsegs, boolean isFilled) {
        double[] rawllpts = new double[llpts.length];
        System.arraycopy(llpts, 0, rawllpts, 0, llpts.length);
        ProjMath.arrayDegToRad(rawllpts);
        return this.forwardPoly(rawllpts, ltype, nsegs, isFilled);
    }

    protected abstract ArrayList<float[]> _forwardPoly(float[] var1, int var2, int var3, boolean var4);

    protected abstract ArrayList<float[]> _forwardPoly(double[] var1, int var2, int var3, boolean var4);

    @Override
    public Length getUcuom() {
        return Length.DECIMAL_DEGREE;
    }

    @Override
    public void setUcuom(Length ucuom) {
    }

    public <T extends GeoCoordTransformation> T getGCTForProjection() {
        return (T)new LatLonGCT();
    }

    public double getReferenceLon() {
        return this.getCenter().getX();
    }
}

