/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.shape;

import com.bbn.openmap.io.FormatException;
import com.bbn.openmap.layer.policy.StandardPCPolicy;
import com.bbn.openmap.layer.shape.ShapeLayer;
import com.bbn.openmap.layer.shape.SpatialIndex;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.proj.ProjMath;
import com.bbn.openmap.proj.Projection;
import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;

public class BufferedShapeLayer
extends ShapeLayer {
    private static final long serialVersionUID = 1L;
    protected OMGraphicList bufferedList = null;

    public BufferedShapeLayer() {
        this.setProjectionChangePolicy(new StandardPCPolicy(this));
    }

    public BufferedShapeLayer(String pathToShpFile) {
        super(pathToShpFile);
        this.setProjectionChangePolicy(new StandardPCPolicy(this));
    }

    protected OMGraphicList getWholePlanet() throws IOException, FormatException {
        this.spatialIndex.readIndexFile(null, this.coordTransform);
        return this.spatialIndex.getAllOMGraphics(null, this.drawingAttributes, null, this.coordTransform);
    }

    public synchronized OMGraphicList prepare() {
        OMGraphicList list;
        block16: {
            list = this.getList();
            if (list != null) {
                list.clear();
            } else {
                list = new OMGraphicList();
            }
            if (this.spatialIndex == null) {
                return list;
            }
            try {
                if (this.bufferedList == null) {
                    this.bufferedList = this.getWholePlanet();
                }
            }
            catch (FormatException fe) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(fe.getMessage());
                }
                return list;
            }
            catch (IOException ioe) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(ioe.getMessage());
                }
                return list;
            }
            Projection proj = this.getProjection();
            Object ul = proj.getUpperLeft();
            Object lr = proj.getLowerRight();
            double ulLat = ((Point2D)ul).getY();
            double ulLon = ((Point2D)ul).getX();
            double lrLat = ((Point2D)lr).getY();
            double lrLon = ((Point2D)lr).getX();
            try {
                if (ProjMath.isCrossingDateline(ulLon, lrLon, proj.getScale())) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine(this.getName() + ": Dateline is on screen");
                    }
                    double ymin = Math.min(ulLat, lrLat);
                    double ymax = Math.max(ulLat, lrLat);
                    this.checkSpatialIndexEntries(ulLon, ymin, 180.0, ymax, list, proj);
                    this.checkSpatialIndexEntries(-180.0, ymin, lrLon, ymax, list, proj);
                } else {
                    double xmin = Math.min(ulLon, lrLon);
                    double xmax = Math.max(ulLon, lrLon);
                    double ymin = Math.min(ulLat, lrLat);
                    double ymax = Math.max(ulLat, lrLat);
                    this.checkSpatialIndexEntries(xmin, ymin, xmax, ymax, list, proj);
                }
            }
            catch (FormatException fe) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(fe.getMessage());
                }
            }
            catch (IOException ioe) {
                if (!logger.isLoggable(Level.FINE)) break block16;
                logger.fine(ioe.getMessage());
            }
        }
        return list;
    }

    protected void checkSpatialIndexEntries(double xmin, double ymin, double xmax, double ymax, OMGraphicList retList, Projection proj) throws IOException, FormatException {
        Iterator<SpatialIndex.Entry> entryIt = this.spatialIndex.entryIterator();
        Iterator omgIt = this.bufferedList.iterator();
        OMGraphicList labels = null;
        if (this.spatialIndex.getDbf() != null) {
            labels = new OMGraphicList();
            retList.add(labels);
        }
        while (entryIt.hasNext() && omgIt.hasNext()) {
            SpatialIndex.Entry entry = entryIt.next();
            OMGraphic omg = (OMGraphic)omgIt.next();
            if (!entry.intersects(xmin, ymin, xmax, ymax)) continue;
            this.drawingAttributes.setTo(omg);
            if ((omg = this.spatialIndex.evaluate(omg, labels, proj)) == null) continue;
            omg.generate(proj);
            retList.add(omg);
        }
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd == "redrawCmd") {
            this.setList(null);
        }
        super.actionPerformed(e);
    }

    protected void setFileProperties(String realPrefix, Properties props) {
        this.bufferedList = null;
        super.setFileProperties(realPrefix, props);
    }

    public void setSpatialIndex(SpatialIndex si) {
        this.bufferedList = null;
        super.setSpatialIndex(si);
    }
}

