/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.policy;

import com.bbn.openmap.OMComponent;
import com.bbn.openmap.layer.OMGraphicHandlerLayer;
import com.bbn.openmap.layer.policy.RenderPolicy;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.proj.Projection;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StandardRenderPolicy
extends OMComponent
implements RenderPolicy {
    public static Logger logger = Logger.getLogger("com.bbn.openmap.layer.policy.RenderPolicy");
    protected OMGraphicHandlerLayer layer;
    protected Composite composite;

    public StandardRenderPolicy() {
    }

    public StandardRenderPolicy(OMGraphicHandlerLayer layer) {
        this();
        this.setLayer(layer);
    }

    public void setLayer(OMGraphicHandlerLayer l) {
        this.layer = l;
    }

    public OMGraphicHandlerLayer getLayer() {
        return this.layer;
    }

    public Composite getComposite() {
        return this.composite;
    }

    public void setComposite(Composite composite) {
        this.composite = composite;
    }

    protected void setCompositeOnGraphics(Graphics2D g) {
        if (this.composite != null) {
            g.setComposite(this.composite);
        }
    }

    public void prePrepare(Projection newProj) {
    }

    public OMGraphicList prepare() {
        if (this.layer != null) {
            return this.layer.prepare();
        }
        return null;
    }

    public void paint(Graphics g) {
        if (this.layer != null) {
            OMGraphicList list = this.layer.getList();
            Projection proj = this.layer.getProjection();
            if (list != null && this.layer.isProjectionOK(proj)) {
                this.setCompositeOnGraphics((Graphics2D)g);
                list.render(g);
            } else if (logger.isLoggable(Level.FINE)) {
                logger.fine(this.layer.getName() + ".paint(): " + (list == null ? "NULL list, skipping..." : " skipping due to projection."));
            }
        } else {
            logger.fine("RenderPolicy.paint():  NULL layer, skipping...");
        }
    }
}

