/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.plotLayer;

import com.bbn.openmap.layer.plotLayer.GLOBEData;
import com.bbn.openmap.layer.plotLayer.GLOBESite;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class GLOBETempData
extends GLOBEData {
    private static float NO_VALUE = -99.0f;
    private Hashtable site_table = new Hashtable();
    public float overall_min_year_ = Float.NaN;
    public float overall_max_year_ = Float.NaN;
    public float overall_min_temp_ = Float.NaN;
    public float overall_max_temp_ = Float.NaN;

    protected void parseDataFromStream(String line) {
        StringTokenizer tokenizer = new StringTokenizer(line);
        DecimalFormat dec_format = new DecimalFormat();
        try {
            int i;
            for (i = 0; i < 2; ++i) {
                tokenizer.nextToken();
            }
            dec_format.parse(tokenizer.nextToken()).intValue();
            for (i = 0; i < 2; ++i) {
                tokenizer.nextToken();
            }
            float time = dec_format.parse(tokenizer.nextToken()).floatValue();
            float latitude = dec_format.parse(tokenizer.nextToken()).floatValue();
            float longitude = dec_format.parse(tokenizer.nextToken()).floatValue();
            tokenizer.nextToken();
            float current_temp = dec_format.parse(tokenizer.nextToken()).floatValue();
            GLOBESite site = this.findSite(latitude, longitude);
            if (current_temp != NO_VALUE) {
                site.addCurrentTemp(time, current_temp);
                this.checkLimits(current_temp, time);
            }
        }
        catch (NoSuchElementException e) {
            System.err.println(e + ": " + e.getMessage());
        }
        catch (ParseException e) {
            System.err.println(e);
        }
    }

    private void checkLimits(float temp, float year) {
        if (Float.isNaN(this.overall_max_temp_) || temp > this.overall_max_temp_) {
            this.overall_max_temp_ = temp;
        }
        if (Float.isNaN(this.overall_min_temp_) || temp < this.overall_min_temp_) {
            this.overall_min_temp_ = temp;
        }
        if (Float.isNaN(this.overall_max_year_) || year > this.overall_max_year_) {
            this.overall_max_year_ = year;
        }
        if (Float.isNaN(this.overall_min_year_) || year < this.overall_min_year_) {
            this.overall_min_year_ = year;
        }
    }

    private GLOBESite findSite(float latitude, float longitude) {
        GLOBESite site = new GLOBESite(latitude, longitude);
        GLOBESite hashed_site = (GLOBESite)this.site_table.get(site.hash());
        if (hashed_site == null) {
            this.site_table.put(site.hash(), site);
            hashed_site = site;
        }
        return hashed_site;
    }

    public Enumeration getAllSites() {
        return this.site_table.elements();
    }
}

