/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.location;

import com.bbn.openmap.Environment;
import com.bbn.openmap.I18n;
import com.bbn.openmap.OMComponent;
import com.bbn.openmap.layer.location.Location;
import com.bbn.openmap.layer.location.LocationHandler;
import com.bbn.openmap.layer.location.LocationLayer;
import com.bbn.openmap.omGraphics.GraphicAttributes;
import com.bbn.openmap.util.PropUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLocationHandler
extends OMComponent
implements LocationHandler {
    protected static Logger logger = Logger.getLogger("com.bbn.openmap.layer.location.LocationHandler");
    protected LocationLayer zLayer;
    private boolean showNames = false;
    private boolean showLocations = true;
    public static final String RenderAttributesListProperty = "renderAttributesList";
    Map<String, GraphicAttributes> renderAttributes = new HashMap<String, GraphicAttributes>();
    private boolean forceGlobal = true;
    private String prettyName = "";
    protected transient I18n i18n = Environment.getI18n();

    protected AbstractLocationHandler() {
        GraphicAttributes nAttributes = new GraphicAttributes();
        nAttributes.setRenderType(1);
        this.renderAttributes.put("name", nAttributes);
        GraphicAttributes lAttributes = new GraphicAttributes();
        lAttributes.setRenderType(1);
        this.renderAttributes.put("location", lAttributes);
    }

    @Override
    public void setLayer(LocationLayer l) {
        this.zLayer = l;
    }

    @Override
    public LocationLayer getLayer() {
        return this.zLayer;
    }

    @Override
    public boolean isShowNames() {
        return this.showNames;
    }

    @Override
    public void setShowNames(boolean set) {
        this.showNames = set;
    }

    @Override
    public boolean isShowLocations() {
        return this.showLocations;
    }

    @Override
    public void setShowLocations(boolean set) {
        this.showLocations = set;
    }

    @Override
    public boolean isForceGlobal() {
        return this.forceGlobal;
    }

    @Override
    public void setForceGlobal(boolean set) {
        this.forceGlobal = set;
    }

    public void setNameColor(Color nColor) {
        this.renderAttributes.get("name").setLinePaint(nColor);
    }

    public Color getNameColor() {
        return (Color)this.renderAttributes.get("name").getLinePaint();
    }

    public void setLocationColor(Color lColor) {
        this.renderAttributes.get("location").setLinePaint(lColor);
    }

    public Color getLocationColor() {
        return (Color)this.renderAttributes.get("location").getLinePaint();
    }

    @Override
    public List<Component> getItemsForPopupMenu(Location loc) {
        return null;
    }

    @Override
    public void removed(Container cont) {
    }

    @Override
    public void setProperties(Properties props) {
        this.setProperties(null, props);
    }

    @Override
    public void setProperties(String prefix, Properties properties) {
        this.propertyPrefix = prefix;
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.showLocations = PropUtils.booleanFromProperties(properties, prefix + "showLocations", this.showLocations);
        this.showNames = PropUtils.booleanFromProperties(properties, prefix + "showNames", this.showNames);
        this.renderAttributes.get("name").setProperties(prefix + "name", properties);
        this.renderAttributes.get("location").setProperties(prefix + "location", properties);
        this.forceGlobal = PropUtils.booleanFromProperties(properties, prefix + "override", this.forceGlobal);
        this.setPrettyName(properties.getProperty(prefix + "prettyName", this.getPrettyName()));
        Vector<String> renAttKeys = PropUtils.parseSpacedMarkers(properties.getProperty(prefix + RenderAttributesListProperty));
        if (renAttKeys != null) {
            for (String renAttKey : renAttKeys) {
                String key = prefix + renAttKey;
                this.renderAttributes.put(key, new GraphicAttributes(key, properties));
            }
        }
    }

    @Override
    public Properties getProperties(Properties props) {
        if (props == null) {
            props = new Properties();
        }
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        props.put(prefix + "showNames", new Boolean(this.showNames).toString());
        props.put(prefix + "showLocations", new Boolean(this.showLocations).toString());
        props.put(prefix + "override", new Boolean(this.forceGlobal).toString());
        props.put(prefix + "prettyName", this.getPrettyName());
        StringBuilder renAttList = new StringBuilder();
        for (String key : this.renderAttributes.keySet()) {
            if (!key.equals("name") && !key.equals("location")) {
                renAttList.append(key).append(" ");
            }
            GraphicAttributes ga = this.renderAttributes.get(key);
            ga.getProperties(props);
        }
        if (renAttList.length() > 0) {
            props.put(prefix + RenderAttributesListProperty, renAttList.toString());
        }
        return props;
    }

    @Override
    public Properties getPropertyInfo(Properties list) {
        if (list == null) {
            list = new Properties();
        }
        PropUtils.setI18NPropertyInfo(this.i18n, list, AbstractLocationHandler.class, "showNames", "Show names", "Display all the location name labels.", "com.bbn.openmap.util.propertyEditor.YesNoPropertyEditor");
        PropUtils.setI18NPropertyInfo(this.i18n, list, AbstractLocationHandler.class, "showLocations", "Show locations", "Display all the location markers.", "com.bbn.openmap.util.propertyEditor.YesNoPropertyEditor");
        PropUtils.setI18NPropertyInfo(this.i18n, list, AbstractLocationHandler.class, "override", "Layer Override", "Layer settings override map object settings.", "com.bbn.openmap.util.propertyEditor.YesNoPropertyEditor");
        PropUtils.setI18NPropertyInfo(this.i18n, list, AbstractLocationHandler.class, "prettyName", "Pretty Name", "Name for Data Set.", null);
        this.renderAttributes.get("name").getPropertyInfo(list);
        this.renderAttributes.get("location").getPropertyInfo(list);
        return list;
    }

    @Override
    public void setPropertyPrefix(String prefix) {
        this.propertyPrefix = prefix;
    }

    @Override
    public String getPropertyPrefix() {
        return this.propertyPrefix;
    }

    public GraphicAttributes getLocationDrawingAttributes() {
        return this.renderAttributes.get("location");
    }

    public void setLocationDrawingAttributes(GraphicAttributes lda) {
        this.renderAttributes.put("location", lda);
    }

    public GraphicAttributes getNameDrawingAttributes() {
        return this.renderAttributes.get("name");
    }

    public void setNameDrawingAttributes(GraphicAttributes nda) {
        this.renderAttributes.put("name", nda);
    }

    @Override
    public void setPrettyName(String prettyName) {
        this.prettyName = prettyName;
    }

    @Override
    public String getPrettyName() {
        return this.prettyName;
    }
}

