/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.dted;

import com.bbn.openmap.PropertyConsumer;
import com.bbn.openmap.dataAccess.dted.DTEDFrameUtil;
import com.bbn.openmap.io.BinaryFile;
import com.bbn.openmap.layer.dted.DTEDSubframedFrame;
import com.bbn.openmap.proj.EqualArc;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import com.bbn.openmap.util.cacheHandler.CacheHandler;
import com.bbn.openmap.util.cacheHandler.CacheObject;
import java.awt.geom.Point2D;
import java.util.Properties;

public class DTEDFrameCache
extends CacheHandler
implements PropertyConsumer {
    public static final int NO_DATA = -500;
    public static final int MAX_DTED_LEVEL = 1;
    protected String[] dtedDirPaths;
    protected int numXSubframes;
    protected int numYSubframes;
    public static final String DTEDPathsProperty = "paths";
    public static final String DTEDFrameCacheSizeProperty = "cacheSize";
    protected String propertyPrefix = null;

    public DTEDFrameCache() {
    }

    public DTEDFrameCache(String[] dtedPaths, int max_size) {
        super(max_size);
        this.dtedDirPaths = dtedPaths;
    }

    public void setDtedDirPaths(String[] paths) {
        this.dtedDirPaths = paths;
    }

    public String findFileName(double lat, double lon, int level) {
        String lonString = DTEDFrameUtil.lonToFileString((float)lon);
        String latString = DTEDFrameUtil.latToFileString((float)lat, level);
        String partialFile = "/" + lonString + "/" + latString;
        String ret = this.findFileName(this.dtedDirPaths, partialFile);
        return ret;
    }

    protected String findFileName(String[] searchPaths, String partialFile) {
        if (searchPaths == null || searchPaths.length == 0) {
            return null;
        }
        for (int i = 0; i < searchPaths.length; ++i) {
            String dtedFileName = searchPaths[i] + partialFile;
            if (!BinaryFile.exists(dtedFileName)) continue;
            return dtedFileName;
        }
        return null;
    }

    public DTEDSubframedFrame get(double lat, double lon, int level) {
        String name = this.findFileName(lat, lon, level);
        if (name != null) {
            return (DTEDSubframedFrame)this.get(name);
        }
        return null;
    }

    public CacheObject load(Object key) {
        if (key != null) {
            String dtedFramePath = key.toString();
            DTEDSubframedFrame frame = new DTEDSubframedFrame(dtedFramePath, dtedFramePath.endsWith("dt0"));
            frame.initSubframes(this.numXSubframes, this.numYSubframes);
            if (frame.frame_is_valid) {
                return new DTEDCacheObject(dtedFramePath, frame);
            }
        }
        return null;
    }

    public void resizeCache(int max_size, int num_x_subframes, int num_y_subframes) {
        boolean destructive = false;
        if (num_x_subframes > 0 && num_y_subframes > 0) {
            this.numXSubframes = num_x_subframes;
            this.numYSubframes = num_y_subframes;
            destructive = true;
            Debug.message("dted", "DTEDFrameCache: destructive resizing");
        } else {
            Debug.message("dted", "DTEDFrameCache: passive resizing");
        }
        CacheObject[] oldObjs = this.objs;
        if (max_size != this.objs.length && max_size > 0) {
            this.objs = new CacheObject[max_size];
        }
        for (int i = 0; i < this.objs.length && i < oldObjs.length; ++i) {
            DTEDCacheObject dco = (DTEDCacheObject)oldObjs[i];
            if (dco == null) {
                this.objs[i] = null;
                continue;
            }
            DTEDSubframedFrame frame = (DTEDSubframedFrame)dco.obj;
            dco.cachedTime = 0;
            if (frame == null) {
                Debug.output("DTEDFrameCache: No Frame for key!");
                continue;
            }
            if (destructive) {
                frame.initSubframes(num_x_subframes, num_y_subframes);
            } else if (oldObjs == this.objs) continue;
            this.objs[i] = i < oldObjs.length ? oldObjs[i] : null;
        }
        oldObjs = null;
    }

    public void resizeCache(int max_size) {
        this.resizeCache(max_size, 0, 0);
    }

    public int getElevation(float lat, float lon) {
        for (int i = 2; i >= 0; --i) {
            DTEDSubframedFrame frame = null;
            String dtedFileName = this.findFileName(lat, lon, i);
            if (dtedFileName != null) {
                frame = (DTEDSubframedFrame)this.get(dtedFileName);
            }
            if (frame == null) continue;
            return frame.elevationAt(lat, lon);
        }
        return -500;
    }

    public short[][] getElevations(EqualArc proj, int dtedLevel) {
        Object ul = proj.getUpperLeft();
        Object lr = proj.getLowerRight();
        return this.getElevations((float)((Point2D)ul).getY(), (float)((Point2D)ul).getX(), (float)((Point2D)lr).getY(), (float)((Point2D)lr).getX(), dtedLevel);
    }

    public short[][] getElevations(float ullat, float ullon, float lrlat, float lrlon, int dtedLevel) {
        return this.getElevations(ullat, ullon, lrlat, lrlon, dtedLevel, null);
    }

    protected short[][] getElevations(float ullat, float ullon, float lrlat, float lrlon, int dtedLevel, DTEDSubframedFrame refFrame) {
        int y;
        int x;
        float upper = ullat;
        float lower = lrlat;
        float right = lrlon;
        float left = ullon;
        if (ullon > lrlon) {
            if (ullon > 0.0f && lrlon < 0.0f) {
                Debug.error("DTEDFrameCache: getElevations: Stradling dateline not handled!");
                return null;
            }
            right = ullon;
            left = lrlon;
        }
        if (lrlat > ullat) {
            upper = lrlat;
            lower = ullat;
        }
        float upperlat = 0.0f;
        float upperlon = 0.0f;
        float lowerlat = 0.0f;
        float lowerlon = 0.0f;
        int xSize = (int)(Math.ceil(right) - Math.floor(left));
        int ySize = (int)(Math.ceil(upper) - Math.floor(lower));
        int[] xLengths = new int[xSize];
        int[] yLengths = new int[ySize];
        short[][][][] es = new short[xSize][ySize][][];
        DTEDSubframedFrame frame = null;
        boolean needCalc = false;
        for (x = 0; x < xSize; ++x) {
            lowerlon = x == 0 ? left : (float)Math.floor(left) + (float)x;
            upperlon = x == xSize - 1 ? right : (float)Math.floor(left) + (float)(x + 1);
            for (y = 0; y < ySize; ++y) {
                lowerlat = y == 0 ? lower : (float)Math.floor(lower) + (float)y;
                upperlat = y == ySize - 1 ? upper : (float)Math.floor(lower) + (float)(y + 1);
                DTEDSubframedFrame thisFrame = this.get(lowerlat, lowerlon, dtedLevel);
                if (thisFrame != null) {
                    es[x][y] = thisFrame.getElevations(upperlat, lowerlon, lowerlat, upperlon);
                    xLengths[x] = es[x][y].length;
                    yLengths[y] = es[x][y][0].length;
                    frame = thisFrame;
                    continue;
                }
                if (refFrame != null) {
                    Debug.output("DTEDFrameCache: Missing frames, going to use reference frame");
                    int[] indexes = refFrame.getIndexesFromLatLons(upperlat, lowerlon, lowerlat, upperlon);
                    xLengths[x] = indexes[2] - indexes[0] + 1;
                    yLengths[y] = indexes[3] - indexes[1] + 1;
                    continue;
                }
                if (frame != null) {
                    return this.getElevations(ullat, ullon, lrlat, lrlon, dtedLevel, frame);
                }
                needCalc = true;
            }
        }
        if (needCalc && frame != null) {
            return this.getElevations(ullat, ullon, lrlat, lrlon, dtedLevel, frame);
        }
        int xLength = 0;
        int yLength = 0;
        for (x = 0; x < xLengths.length; ++x) {
            xLength += xLengths[x];
        }
        for (y = 0; y < yLengths.length; ++y) {
            yLength += yLengths[y];
        }
        short[][] matrix = new short[xLength][yLength];
        int xspacer = 0;
        for (x = 0; x < es.length; ++x) {
            int yspacer = 0;
            for (y = 0; y < es[x].length; ++y) {
                if (es[x][y] != null) {
                    for (int i = 0; i < es[x][y].length; ++i) {
                        System.arraycopy(es[x][y][i], 0, matrix[i + xspacer], yspacer, es[x][y][i].length);
                    }
                    yspacer += yLengths[y];
                    continue;
                }
                yspacer += xLengths[y];
            }
            xspacer += xLengths[x];
        }
        return matrix;
    }

    public void setPropertyPrefix(String prefix) {
        this.propertyPrefix = prefix;
    }

    public String getPropertyPrefix() {
        return this.propertyPrefix;
    }

    public void setProperties(Properties props) {
        this.setProperties(null, props);
    }

    public void setProperties(String prefix, Properties props) {
        this.setPropertyPrefix(prefix);
        prefix = PropUtils.getScopedPropertyPrefix(this);
        String[] paths = PropUtils.initPathsFromProperties(props, prefix + DTEDPathsProperty);
        this.setDtedDirPaths(paths);
        this.resetCache(PropUtils.intFromProperties(props, prefix + DTEDFrameCacheSizeProperty, 20));
    }

    public Properties getProperties(Properties props) {
        if (props == null) {
            props = new Properties();
        }
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        props.put(prefix + DTEDFrameCacheSizeProperty, Integer.toString(this.getCacheSize()));
        String prop = null;
        StringBuffer pathString = new StringBuffer();
        if (this.dtedDirPaths != null && this.dtedDirPaths.length > 0) {
            for (String path : this.dtedDirPaths) {
                if (pathString.length() > 0) {
                    pathString.append(';');
                }
                pathString.append(path);
            }
        }
        props.put(prefix + prop, pathString.toString());
        return props;
    }

    public Properties getPropertyInfo(Properties props) {
        if (props == null) {
            props = new Properties();
        }
        props.put(DTEDPathsProperty, "Paths to the DTED directories");
        props.put(DTEDFrameCacheSizeProperty, "Size of the frame cache");
        return props;
    }

    public static void main(String[] args) {
        Debug.init();
        if (args.length < 1) {
            Debug.output("DTEDFrameCache:  Need a path/filename");
            System.exit(0);
        }
        Debug.output("DTEDFrameCache: " + args[0]);
        DTEDFrameCache dfc = new DTEDFrameCache(args, 10);
        float ullat = 37.002f;
        float ullon = -121.002f;
        float lrlat = 35.998f;
        float lrlon = -119.998f;
        short[][] e = dfc.getElevations(ullat, ullon, lrlat, lrlon, 0);
        if (e != null) {
            for (int i = e[0].length - 1; i >= 0; --i) {
                int col = 0;
                System.out.print("r" + i + "-");
                for (int j = 0; j < e.length; ++j) {
                    System.out.print(e[j][i] + " ");
                    ++col;
                }
                System.out.println(" - " + col);
            }
        }
    }

    private static class DTEDCacheObject
    extends CacheObject {
        public DTEDCacheObject(String id, DTEDSubframedFrame obj) {
            super(id, obj);
        }

        protected void finalize() {
            ((DTEDSubframedFrame)this.obj).dispose();
        }
    }
}

