/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.geo;

import com.bbn.openmap.MoreMath;
import com.bbn.openmap.geo.BoundingCircle;
import com.bbn.openmap.geo.Geo;
import com.bbn.openmap.geo.GeoArray;
import com.bbn.openmap.geo.GeoExtent;
import com.bbn.openmap.geo.GeoPath;
import com.bbn.openmap.geo.GeoPoint;
import com.bbn.openmap.geo.GeoRegion;
import com.bbn.openmap.geo.GeoSegment;
import com.bbn.openmap.omGraphics.OMGraphicAdapter;
import com.bbn.openmap.proj.GeoProj;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.util.Debug;
import java.awt.Point;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public abstract class OMGeo
extends OMGraphicAdapter
implements GeoExtent {
    protected GeoExtent extent;
    protected Object id = this;

    protected OMGeo() {
        this.setRenderType(1);
    }

    protected OMGeo(GeoExtent ge) {
        this();
        this.setExtent(ge);
    }

    public GeoExtent getExtent() {
        return this.extent;
    }

    public void setExtent(GeoExtent ge) {
        this.extent = ge;
    }

    public BoundingCircle getBoundingCircle() {
        return this.getExtent().getBoundingCircle();
    }

    public Object getID() {
        return this.id;
    }

    public void setID(Object id) {
        this.id = id;
    }

    public static class Polygon
    extends Polyline
    implements GeoRegion {
        public Polygon(GeoPath gp) {
            super(gp);
        }

        public Polygon(Geo[] gs) {
            super(new GeoRegion.Impl(gs));
        }

        public Polygon(GeoArray points) {
            super(new GeoRegion.Impl(points));
        }

        public boolean isPointInside(Geo point) {
            return ((GeoRegion)this.getExtent()).isPointInside(point);
        }
    }

    public static class Polyline
    extends OMGeo
    implements GeoPath {
        public Polyline(GeoPath gp) {
            super(gp);
        }

        public Polyline(Geo[] gs) {
            super(new GeoPath.Impl(gs));
        }

        public Polyline(GeoArray points) {
            super(new GeoPath.Impl(points));
        }

        public GeoArray getPoints() {
            return ((GeoPath)this.getExtent()).getPoints();
        }

        public boolean generate(Projection proj) {
            this.setNeedToRegenerate(true);
            boolean isPolygon = this.getExtent() instanceof GeoRegion;
            if (proj == null) {
                Debug.message("omgraphic", "GeoOMGraphic.Poly: null projection in generate!");
                return false;
            }
            ArrayList<float[]> vector = proj instanceof GeoProj ? ((GeoProj)proj).forwardPoly(this.getPoints().toLLRadians(), this.lineType, -1, isPolygon) : proj.forwardPoly(this.getPoints().toLLDegrees(), isPolygon);
            int size = vector.size();
            float[][] xpoints = new float[size / 2][0];
            float[][] ypoints = new float[xpoints.length][0];
            int i = 0;
            int j = 0;
            while (i < size) {
                xpoints[j] = vector.get(i);
                ypoints[j] = vector.get(i + 1);
                i += 2;
                ++j;
            }
            this.initLabelingDuringGenerate();
            size = xpoints.length;
            GeneralPath projectedShape = null;
            for (int i2 = 0; i2 < size; ++i2) {
                GeneralPath gp = Polyline.createShape(xpoints[i2], ypoints[i2], isPolygon);
                projectedShape = Polyline.appendShapeEdge(projectedShape, gp, false);
            }
            this.setShape(projectedShape);
            this.setLabelLocation(xpoints[0], ypoints[0], proj);
            this.setNeedToRegenerate(false);
            return true;
        }

        protected boolean isGeometryClosed(float[] rawllpts) {
            int l;
            boolean geometryClosed = false;
            if (rawllpts != null && (l = rawllpts.length) > 4) {
                geometryClosed = MoreMath.approximately_equal(rawllpts[0], rawllpts[l - 2]) && MoreMath.approximately_equal(rawllpts[1], rawllpts[l - 1]);
            }
            return geometryClosed;
        }

        public boolean isSegmentNear(GeoSegment s, double epsilon) {
            return ((GeoPath)this.getExtent()).isSegmentNear(s, epsilon);
        }

        public int length() {
            return ((GeoPath)this.getExtent()).length();
        }

        public GeoPath.PointIterator pointIterator() {
            return ((GeoPath)this.getExtent()).pointIterator();
        }

        public GeoPath.SegmentIterator segmentIterator() {
            return ((GeoPath)this.getExtent()).segmentIterator();
        }
    }

    public static class Line
    extends OMGeo
    implements GeoSegment {
        public Line(GeoSegment gs) {
            super(gs);
        }

        public Line(Geo[] gs) {
            super(new GeoSegment.Impl(gs));
        }

        public Geo[] getGeoArray() {
            return ((GeoSegment)this.getExtent()).getSeg();
        }

        public boolean generate(Projection proj) {
            this.setNeedToRegenerate(true);
            if (proj == null) {
                Debug.message("omgraphic", "GeoOMGraphic.Line: null projection in generate!");
                return false;
            }
            this.initLabelingDuringGenerate();
            double[] latlons = this.getSegArray();
            ArrayList<float[]> lines = null;
            lines = proj instanceof GeoProj ? ((GeoProj)proj).forwardLine(new LatLonPoint.Double(latlons[0], latlons[1]), new LatLonPoint.Double(latlons[2], latlons[3]), this.lineType, -1) : proj.forwardLine(new Point2D.Double(latlons[1], latlons[0]), new Point2D.Double(latlons[3], latlons[2]));
            int size = lines.size();
            float[][] xpoints = new float[size / 2][0];
            float[][] ypoints = new float[xpoints.length][0];
            GeneralPath projectedShape = null;
            int i = 0;
            int j = 0;
            while (i < size) {
                float[] xps = lines.get(i);
                float[] yps = lines.get(i + 1);
                xpoints[j] = xps;
                ypoints[j] = yps;
                GeneralPath gp = Line.createShape(xps, yps, false);
                if (projectedShape == null) {
                    projectedShape = gp;
                } else {
                    projectedShape.append(gp, false);
                }
                i += 2;
                ++j;
            }
            this.setShape(projectedShape);
            this.setLabelLocation(projectedShape, proj);
            this.setNeedToRegenerate(false);
            return true;
        }

        public Geo[] getSeg() {
            return ((GeoSegment)this.getExtent()).getSeg();
        }

        public double[] getSegArray() {
            return ((GeoSegment)this.getExtent()).getSegArray();
        }
    }

    public static class Pt
    extends OMGeo
    implements GeoPoint {
        protected int radius = 2;
        protected boolean isOval = true;

        public Pt(GeoPoint gp) {
            super(gp);
        }

        public Pt(Geo g) {
            super(new GeoPoint.Impl(g));
        }

        public Pt(double lat, double lon, boolean isDegrees) {
            super(new GeoPoint.Impl(lat, lon, isDegrees));
        }

        public Geo getGeo() {
            return ((GeoPoint)this.getExtent()).getPoint();
        }

        public boolean generate(Projection proj) {
            double lon;
            this.setNeedToRegenerate(true);
            if (proj == null) {
                Debug.message("omgraphic", "GeoOMGraphic.Point: null projection in generate!");
                return false;
            }
            Geo geo = this.getPoint();
            double lat = geo.getLatitude();
            if (!proj.isPlotable(lat, lon = geo.getLongitude())) {
                this.setNeedToRegenerate(true);
                return false;
            }
            Point2D.Double p1 = new Point2D.Double();
            proj.forward(lat, lon, (Point2D)p1);
            double x1 = ((Point2D)p1).getX() - (double)this.radius;
            double y1 = ((Point2D)p1).getY() - (double)this.radius;
            double x2 = ((Point2D)p1).getX() + (double)this.radius;
            double y2 = ((Point2D)p1).getY() + (double)this.radius;
            if (this.isOval) {
                this.setShape(new GeneralPath(new Ellipse2D.Float((float)Math.min(x2, x1), (float)Math.min(y2, y1), (float)Math.abs(x2 - x1), (float)Math.abs(y2 - y1))));
            } else {
                this.setShape(Pt.createBoxShape((int)Math.min(x2, x1), (int)Math.min(y2, y1), (int)Math.abs(x2 - x1), (int)Math.abs(y2 - y1)));
            }
            this.initLabelingDuringGenerate();
            this.setLabelLocation(new Point((int)x2, (int)y1), proj);
            this.setNeedToRegenerate(false);
            return true;
        }

        public boolean isOval() {
            return this.isOval;
        }

        public void setOval(boolean isOval) {
            this.isOval = isOval;
        }

        public int getRadius() {
            return this.radius;
        }

        public void setRadius(int radius) {
            this.radius = radius;
        }

        public Geo getPoint() {
            return ((GeoPoint)this.getExtent()).getPoint();
        }
    }
}

