/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.event;

import com.bbn.openmap.MapBean;
import com.bbn.openmap.event.CoordMouseMode;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.coords.LatLonPoint;
import java.awt.Color;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;

public class ZoomMouseMode
extends CoordMouseMode {
    protected double squareWidth = 50.0;
    public static final transient String modeID = "Zoom";
    protected MapBean theMap = null;

    public ZoomMouseMode() {
        super(modeID, true);
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getSource() instanceof MapBean) {
            int currX = e.getX();
            int currY = e.getY();
            this.theMap = (MapBean)e.getSource();
            if (e.getClickCount() == 2 && e.getButton() == 1) {
                int squareCenterX = currX;
                int squareCenterY = currY;
                double aspect = (double)this.theMap.getHeight() / (double)this.theMap.getWidth();
                double squareWidth = this.squareWidth;
                double squareHeight = this.squareWidth;
                if (aspect > 1.0) {
                    squareHeight *= aspect;
                } else {
                    squareWidth /= aspect;
                }
                int squareUpperLeftX = squareCenterX - (int)squareWidth / 2;
                int squareUpperLeftY = squareCenterY - (int)squareHeight / 2;
                if (squareUpperLeftX < 1) {
                    squareUpperLeftX = 1;
                    squareCenterX = (int)((double)squareUpperLeftX + squareWidth / 2.0);
                } else if ((double)squareUpperLeftX + squareWidth >= (double)this.theMap.getWidth()) {
                    squareUpperLeftX = (int)((double)this.theMap.getWidth() - squareWidth - 1.0);
                    squareCenterX = (int)((double)squareUpperLeftX + squareWidth / 2.0);
                }
                if (squareUpperLeftY < 1) {
                    squareUpperLeftY = 1;
                    squareCenterY = (int)((double)squareUpperLeftY + squareHeight / 2.0);
                } else if ((double)squareUpperLeftY + squareHeight >= (double)this.theMap.getHeight()) {
                    squareUpperLeftY = (int)((double)this.theMap.getHeight() - squareHeight - 1.0);
                    squareCenterY = (int)((double)squareUpperLeftY + squareHeight / 2.0);
                }
                Projection proj = this.theMap.getProjection();
                LatLonPoint.Double upperLeft = proj.inverse(squareUpperLeftX, squareUpperLeftY, new LatLonPoint.Double());
                LatLonPoint.Double lowerRight = proj.inverse(squareUpperLeftX + (int)squareWidth, squareUpperLeftY + (int)squareHeight, new LatLonPoint.Double());
                Object center = proj.inverse(squareCenterX, squareCenterY);
                double necessaryScale = proj.getScale(upperLeft, lowerRight, proj.forward(upperLeft), proj.forward(lowerRight));
                final Projection newProj = this.theMap.getProjectionFactory().makeProjection((Class<? extends Projection>)proj.getClass(), (Point2D)center, (float)necessaryScale, this.theMap.getWidth(), this.theMap.getHeight());
                Thread delayThread = new Thread(){

                    public void run() {
                        ZoomMouseMode.this.theMap.setProjection(newProj);
                    }
                };
                BufferedImage bi = this.theMap.getGraphicsConfiguration().createCompatibleImage(this.theMap.getWidth(), this.theMap.getHeight(), 1);
                this.theMap.paintAll(bi.getGraphics());
                BufferedImage bi2 = bi.getSubimage(squareUpperLeftX, squareUpperLeftY, (int)squareWidth, (int)squareHeight);
                BufferedImage square = new BufferedImage((int)squareWidth, (int)squareHeight, 1);
                square.getGraphics().drawImage(bi2, 0, 0, (int)squareWidth, (int)squareHeight, null);
                square.getGraphics().setColor(new Color(0, 255, 0, 255));
                square.getGraphics().drawRect(0, 0, square.getWidth() - 1, square.getHeight() - 1);
                delayThread.start();
                double iterations = 10.0;
                double widthIncrease = (double)this.theMap.getWidth() - squareWidth;
                double heightIncrease = (double)this.theMap.getHeight() - squareHeight;
                double widthInc = widthIncrease / iterations;
                double heightInc = heightIncrease / iterations;
                double leftInc = (double)squareUpperLeftX / iterations;
                double upInc = (double)squareUpperLeftY / iterations;
                int i = 0;
                while ((double)i < iterations + 1.0) {
                    this.theMap.getGraphics(true).drawImage(square, squareUpperLeftX - (int)(leftInc * (double)i), squareUpperLeftY - (int)(upInc * (double)i), (int)squareWidth + (int)(widthInc * (double)i), (int)squareHeight + (int)(heightInc * (double)i), null);
                    try {
                        Thread.sleep(50L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++i;
                }
            }
        }
    }
}

