/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.event;

import com.bbn.openmap.MapBean;
import com.bbn.openmap.event.CoordMouseMode;
import com.bbn.openmap.geo.Geo;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.omGraphics.OMCircle;
import com.bbn.openmap.omGraphics.OMPoint;
import com.bbn.openmap.omGraphics.OMText;
import com.bbn.openmap.proj.Length;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.util.PropUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.text.DecimalFormat;
import java.text.Format;
import java.util.Properties;

public class RangeRingsMouseMode
extends CoordMouseMode {
    private static final long serialVersionUID = 6208201699394207932L;
    public static final transient String modeID = "RangeRings";
    public static final String NUM_RINGS_PROPERTY = "numRings";
    public static final String UNITS_PROPERTY = "units";
    public transient DecimalFormat df = new DecimalFormat("0.###");
    protected Format distanceFormat;
    protected int numRings = 3;
    protected Point2D origin = null;
    protected Point2D intermediateDest = null;
    protected Point2D destination = null;
    protected DrawingAttributes rrAttributes = DrawingAttributes.getDefaultClone();

    public RangeRingsMouseMode() {
        this(true);
    }

    public RangeRingsMouseMode(boolean shouldConsumeEvents) {
        super(modeID, shouldConsumeEvents);
        this.init();
    }

    public RangeRingsMouseMode(String name, boolean shouldConsumeEvents) {
        super(name, shouldConsumeEvents);
        this.init();
    }

    protected void init() {
        this.setModeCursor(Cursor.getPredefinedCursor(1));
        this.rrAttributes.setLinePaint(Color.GRAY);
        this.rrAttributes.setMattingPaint(Color.LIGHT_GRAY);
        this.rrAttributes.setMatted(true);
    }

    public Format getDistanceFormat() {
        return this.distanceFormat;
    }

    public void setDistanceFormat(Format distanceFormat) {
        this.distanceFormat = distanceFormat;
    }

    public int getNumRings() {
        return this.numRings;
    }

    public void setNumRings(int numRings) {
        this.numRings = numRings;
    }

    public void setActive(boolean active) {
        if (!active) {
            this.cleanUp();
        }
    }

    public void mouseClicked(MouseEvent e) {
        MapBean theMap;
        MapBean mapBean = theMap = e.getSource() instanceof MapBean ? (MapBean)e.getSource() : null;
        if (theMap != null && e.getClickCount() >= 2) {
            this.cleanUp();
            theMap.repaint();
        }
    }

    public void mousePressed(MouseEvent e) {
        Object obj = e.getSource();
        if (obj instanceof MapBean) {
            MapBean theMap = (MapBean)obj;
            if (this.origin == null) {
                Point pnt = e.getPoint();
                this.origin = theMap.inverse(pnt.getX(), pnt.getY(), new LatLonPoint.Double());
                theMap.addPaintListener(this);
            }
        }
    }

    public void mouseReleased(MouseEvent e) {
        Object obj = e.getSource();
        if (obj instanceof MapBean) {
            MapBean theMap = (MapBean)obj;
            if (this.origin != null && this.destination == null) {
                Point pnt = e.getPoint();
                Point2D originPnt = theMap.getProjection().forward(this.origin);
                if (Math.abs(originPnt.getX() - pnt.getX()) > 5.0 && Math.abs(originPnt.getY() - pnt.getY()) > 5.0) {
                    this.destination = theMap.inverse(pnt.getX(), pnt.getY(), new LatLonPoint.Double());
                    this.intermediateDest = null;
                }
            }
            theMap.repaint();
        }
    }

    public void mouseDragged(MouseEvent e) {
        this.mouseMoved(e);
    }

    public void mouseMoved(MouseEvent e) {
        Object obj = e.getSource();
        if (obj instanceof MapBean) {
            MapBean theMap = (MapBean)obj;
            if (this.origin != null && this.destination == null) {
                Point pnt = e.getPoint();
                this.intermediateDest = theMap.inverse(pnt.getX(), pnt.getY(), new LatLonPoint.Double());
                this.fireMouseLocation(e);
                theMap.repaint();
            } else {
                this.fireMouseLocation(e);
            }
        }
    }

    public void listenerPaint(Object source, Graphics g) {
        MapBean theMap;
        MapBean mapBean = theMap = source instanceof MapBean ? (MapBean)source : null;
        if (theMap != null) {
            if (this.origin != null) {
                this.paintOrigin(this.origin, g, theMap);
                if (this.destination != null) {
                    this.paintRangeRings(this.origin, this.destination, g, theMap);
                } else if (this.intermediateDest != null) {
                    this.paintRangeRings(this.origin, this.intermediateDest, g, theMap);
                }
            } else {
                theMap.removePaintListener(this);
            }
        }
    }

    protected void paintOrigin(Point2D llp, Graphics graphics, MapBean theMap) {
        this.paintOriginPoint(llp, graphics, theMap);
        this.paintOriginLabel(llp, graphics, theMap);
    }

    protected void paintOriginPoint(Point2D originPnt, Graphics graphics, MapBean theMap) {
        if (theMap != null && originPnt != null) {
            OMPoint pt = new OMPoint(originPnt.getY(), originPnt.getX());
            this.preparePoint(pt);
            pt.generate(theMap.getRotatedProjection());
            pt.render(graphics);
        }
    }

    protected void paintOriginLabel(Point2D originPnt, Graphics graphics, MapBean theMap) {
        if (theMap != null && originPnt != null) {
            OMText text = new OMText(originPnt.getY(), originPnt.getX(), this.getOriginLabel(), 1);
            text.setBaseline(0);
            text.putAttribute("norotate", Boolean.TRUE);
            this.prepareLabel(text);
            text.generate(theMap.getRotatedProjection());
            text.render(graphics);
        }
    }

    protected void paintRangeRings(Point2D originPnt, Point2D dest, Graphics graphics, MapBean theMap) {
        Geo originGeo = new Geo(originPnt.getY(), originPnt.getX(), true);
        Geo destGeo = new Geo(dest.getY(), dest.getX(), true);
        double distance = originGeo.distance(destGeo);
        for (int i = 1; i <= Math.max(1, this.numRings); ++i) {
            double ringDist = distance * (double)i;
            this.paintCircle(originGeo, ringDist, graphics, theMap);
            this.paintLabel(originGeo, ringDist, graphics, theMap);
        }
    }

    protected void paintCircle(Geo originGeo, double distance, Graphics graphics, MapBean theMap) {
        OMCircle circle = new OMCircle(originGeo.getLatitude(), originGeo.getLongitude(), Length.DECIMAL_DEGREE.fromRadians(distance));
        this.prepareCircle(circle);
        circle.generate(theMap.getRotatedProjection());
        circle.render(graphics);
    }

    protected void paintLabel(Geo originGeo, double distance, Graphics graphics, MapBean theMap) {
        Geo ringGeo = originGeo.offset(distance, Math.PI);
        OMText text = new OMText(ringGeo.getLatitude(), ringGeo.getLongitude(), this.getLabelFor(distance), 1);
        text.putAttribute("norotate", Boolean.TRUE);
        text.setBaseline(0);
        this.prepareLabel(text);
        text.generate(theMap.getRotatedProjection());
        text.render(graphics);
    }

    protected void preparePoint(OMPoint point) {
        this.rrAttributes.setTo(point);
    }

    protected void prepareCircle(OMCircle circle) {
        this.rrAttributes.setTo(circle);
    }

    protected void prepareLabel(OMText text) {
        this.rrAttributes.setTo(text);
        text.setLinePaint(this.rrAttributes.getLinePaint());
        text.setTextMatteColor((Color)this.rrAttributes.getMattingPaint());
        text.setTextMatteStroke(new BasicStroke(4.0f));
    }

    protected String getOriginLabel() {
        return "(" + this.df.format(this.origin.getY()) + ", " + this.df.format(this.origin.getX()) + ")";
    }

    protected String getLabelFor(double distance) {
        Format distFormat = this.getDistanceFormat();
        if (distFormat == null) {
            return Double.toString(distance);
        }
        return distFormat.format(new Double(distance));
    }

    protected void cleanUp() {
        this.origin = null;
        this.intermediateDest = null;
        this.destination = null;
    }

    private AffineTransform getTranslation(Point2D pt1, Point2D pt2, Projection proj) {
        Point2D p1 = proj.forward(pt1);
        Point2D p2 = proj.forward(pt2);
        return AffineTransform.getTranslateInstance(p2.getX() - p1.getX(), p2.getY() - p1.getY());
    }

    private LatLonPoint translate(Point2D pt, AffineTransform xyTranslation, Projection proj) {
        Point2D p = proj.forward(pt);
        xyTranslation.transform(p, p);
        return proj.inverse(p, new LatLonPoint.Double());
    }

    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
        this.rrAttributes.setProperties(prefix, props);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.numRings = PropUtils.intFromProperties(props, prefix + NUM_RINGS_PROPERTY, this.numRings);
    }

    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        this.rrAttributes.getProperties(props);
        String prefix = PropUtils.getScopedPropertyPrefix(this.getPropertyPrefix());
        props.setProperty(prefix + NUM_RINGS_PROPERTY, Integer.toString(this.numRings));
        return props;
    }

    public Properties getPropertyInfo(Properties list) {
        list = super.getPropertyInfo(list);
        list = this.rrAttributes.getPropertyInfo(list);
        list.setProperty(NUM_RINGS_PROPERTY, "Number of range rings to be drawn (minimum=1; default=3).");
        list.setProperty("initProperties", "units showCircle showAngle lineColor mattingColor matted");
        return list;
    }
}

