/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.event;

import com.bbn.openmap.InformationDelegator;
import com.bbn.openmap.MapBean;
import com.bbn.openmap.event.CoordMouseMode;
import com.bbn.openmap.event.InfoDisplayEvent;
import com.bbn.openmap.event.PaintListener;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.omGraphics.OMCircle;
import com.bbn.openmap.omGraphics.OMLine;
import com.bbn.openmap.proj.GreatCircle;
import com.bbn.openmap.proj.Length;
import com.bbn.openmap.proj.ProjMath;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.text.DecimalFormat;
import java.util.Properties;
import java.util.Vector;

public class DistanceMouseMode
extends CoordMouseMode
implements PaintListener {
    public static final transient String modeID = "Distance";
    public static final String UnitProperty = "units";
    public static final String ShowCircleProperty = "showCircle";
    public static final String ShowAngleProperty = "showAngle";
    public static final String RepaintToCleanProperty = "repaintToClean";
    public transient DecimalFormat df = new DecimalFormat("0.###");
    public static final String AllUnitsPropertyValue = "all";
    protected Point2D rPoint1;
    protected Point2D rPoint2;
    protected boolean drawDistanceObjects = false;
    protected Vector<Point2D> segments = new Vector();
    protected double distance = 0.0;
    protected double totalDistance = 0.0;
    int lineType = 3;
    boolean displayCircle = true;
    Length unit = Length.MILE;
    boolean showAngle = true;
    protected DrawingAttributes renderAttributes = DrawingAttributes.getDefaultClone();
    transient MapBean theMap;

    public DistanceMouseMode() {
        this(true);
        this.renderAttributes.setLinePaint(Color.GRAY);
        this.renderAttributes.setMattingPaint(Color.LIGHT_GRAY);
        this.renderAttributes.setMatted(true);
    }

    public DistanceMouseMode(boolean consumeEvents) {
        super(modeID, consumeEvents);
    }

    public DistanceMouseMode(String name, boolean consumeEvents) {
        super(name, consumeEvents);
    }

    public DistanceMouseMode(boolean consumeEvents, InformationDelegator id, Length units) {
        super(modeID, consumeEvents);
        this.infoDelegator = id;
        this.unit = units;
    }

    public DistanceMouseMode(boolean consumeEvents, InformationDelegator id, Length units, int lType) {
        super(modeID, consumeEvents);
        this.infoDelegator = id;
        this.unit = units;
        this.lineType = lType;
    }

    public DistanceMouseMode(boolean consumeEvents, InformationDelegator id) {
        super(modeID, consumeEvents);
        this.infoDelegator = id;
    }

    public DistanceMouseMode(String name, boolean consumeEvents, InformationDelegator id) {
        super(name, consumeEvents);
        this.infoDelegator = id;
    }

    public void mouseClicked(MouseEvent e) {
        this.mouseSupport.fireMapMouseClicked(e);
        if (e.getSource() instanceof MapBean && e.getClickCount() >= 2) {
            this.drawDistanceObjects = false;
            this.cleanUp();
            ((MapBean)e.getSource()).repaint();
        }
    }

    public void mousePressed(MouseEvent e) {
        this.mouseSupport.fireMapMousePressed(e);
        e.getComponent().requestFocus();
        if (e.getSource() instanceof MapBean) {
            this.drawDistanceObjects = true;
            if (this.theMap == null) {
                this.theMap = (MapBean)e.getSource();
                this.theMap.addPaintListener(this);
            }
            this.rPoint1 = this.theMap.getCoordinates(e);
            this.rPoint2 = null;
            this.segments.addElement(this.rPoint1);
            this.totalDistance += this.distance;
            this.theMap.repaint();
        }
    }

    public void mouseMoved(MouseEvent e) {
        this.mouseSupport.fireMapMouseMoved(e);
        if (e.getSource() instanceof MapBean) {
            if (this.drawDistanceObjects && this.theMap != null) {
                this.rPoint2 = this.theMap.getCoordinates(e);
                this.theMap.repaint();
                if (this.infoDelegator != null) {
                    Debug.message("mousemodedetail", "DistanceMouseMode: firing mouse location");
                    double lat1 = this.rPoint1.getY();
                    double long1 = this.rPoint1.getX();
                    double lat2 = this.rPoint2.getY();
                    double long2 = this.rPoint2.getX();
                    this.distance = GreatCircle.sphericalDistance(ProjMath.degToRad(lat1), ProjMath.degToRad(long1), ProjMath.degToRad(lat2), ProjMath.degToRad(long2));
                    double azimuth = this.getSphericalAzimuth(lat1, long1, lat2, long2);
                    double tmpDistance = this.totalDistance + this.distance;
                    String infoLine = this.createDistanceInformationLine(this.rPoint2, tmpDistance, azimuth);
                    InfoDisplayEvent info = new InfoDisplayEvent(this, infoLine, 1);
                    this.infoDelegator.requestInfoLine(info);
                }
            } else {
                this.fireMouseLocation(e);
            }
        }
    }

    protected String createDistanceInformationLine(Point2D llp, double distance, double azimuth) {
        String unitInfo = null;
        unitInfo = this.unit == null ? this.df.format(Length.NM.fromRadians((float)distance)) + Length.NM.getAbbr() + ",  " + this.df.format(Length.KM.fromRadians((float)distance)) + Length.KM.getAbbr() + ",  " + this.df.format(Length.MILE.fromRadians((float)distance)) + Length.MILE.getAbbr() + "  " : this.unit.fromRadians((float)distance) + " " + this.unit.getAbbr();
        StringBuffer infoLine = new StringBuffer();
        infoLine.append("Lat, Lon (").append(this.df.format(llp.getY())).append(", ").append(this.df.format(llp.getX())).append("), distance (");
        infoLine.append(unitInfo).append(")");
        if (this.showAngle) {
            infoLine.append(", angle (").append(this.df.format(azimuth)).append(")");
        }
        return infoLine.toString();
    }

    public void mouseExited(MouseEvent e) {
        this.mouseSupport.fireMapMouseExited(e);
        if (e.getSource() instanceof MapBean) {
            this.rPoint2 = null;
        }
    }

    public void setActive(boolean active) {
        if (!active) {
            this.cleanUp();
        }
    }

    public void listenerPaint(Object source, Graphics g) {
        if (this.drawDistanceObjects) {
            for (int i = 0; i < this.segments.size() - 1; ++i) {
                this.paintLine((LatLonPoint)this.segments.elementAt(i), (LatLonPoint)this.segments.elementAt(i + 1), g);
            }
            if (this.rPoint1 != null && this.rPoint2 != null) {
                this.paintRubberband(this.rPoint1, this.rPoint2, g);
            }
        }
    }

    public void paintLine(Point2D pt1, Point2D pt2, Graphics graphics) {
        Graphics2D g = (Graphics2D)graphics;
        if (pt1 != null && pt2 != null && this.theMap != null) {
            OMLine cLine = new OMLine(pt1.getY(), pt1.getX(), pt2.getY(), pt2.getX(), this.lineType);
            this.renderAttributes.setTo(cLine);
            Projection proj = this.theMap.getRotatedProjection();
            cLine.generate(proj);
            cLine.render(g);
        }
    }

    public void paintCircle(Point2D pt1, Point2D pt2, Graphics graphics) {
        if (this.displayCircle && this.theMap != null) {
            Graphics2D g = (Graphics2D)graphics;
            if (pt1 != null && pt2 != null) {
                double radphi1 = ProjMath.degToRad(pt1.getY());
                double radlambda0 = ProjMath.degToRad(pt1.getX());
                double radphi = ProjMath.degToRad(pt2.getY());
                double radlambda = ProjMath.degToRad(pt2.getX());
                double dRad = GreatCircle.sphericalDistance(radphi1, radlambda0, radphi, radlambda);
                double rad = ProjMath.radToDeg(dRad);
                OMCircle circle = new OMCircle(pt1.getY(), pt1.getX(), rad);
                this.renderAttributes.setTo(circle);
                Projection proj = this.theMap.getRotatedProjection();
                circle.generate(proj);
                circle.render(g);
            }
        }
    }

    public void paintRubberband(Point2D pt1, Point2D pt2, Graphics g) {
        this.paintLine(pt1, pt2, g);
        this.paintCircle(pt1, pt2, g);
    }

    public void cleanUp() {
        this.segments = new Vector();
        this.totalDistance = 0.0;
        this.distance = 0.0;
        if (this.theMap != null) {
            this.theMap.removePaintListener(this);
            this.theMap.repaint();
            this.theMap = null;
        }
    }

    public double getGreatCircleDist(double phi1, double lambda0, double phi, double lambda, int units) {
        double dist = 0.0;
        double radphi1 = ProjMath.degToRad(phi1);
        double radlambda0 = ProjMath.degToRad(lambda0);
        double radphi = ProjMath.degToRad(phi);
        double radlambda = ProjMath.degToRad(lambda);
        double distRad = GreatCircle.sphericalDistance(radphi1, radlambda0, radphi, radlambda);
        if (units == 0) {
            dist = distRad * 21638.77734375 / 6.2831854820251465;
        }
        if (units == 1) {
            dist = distRad * 40075.015625 / 6.2831854820251465;
        }
        if (units == 2) {
            dist = distRad * 24901.4609375 / 6.2831854820251465;
        }
        return dist;
    }

    public double getSphericalAzimuth(double phi1, double lambda0, double phi, double lambda) {
        double radphi1 = ProjMath.degToRad(phi1);
        double radlambda0 = ProjMath.degToRad(lambda0);
        double radphi = ProjMath.degToRad(phi);
        double radlambda = ProjMath.degToRad(lambda);
        double az = GreatCircle.sphericalAzimuth(radphi1, radlambda0, radphi, radlambda);
        return ProjMath.radToDeg(az);
    }

    protected void setMapBean(MapBean aMap) {
        this.theMap = aMap;
    }

    protected MapBean getMapBean() {
        return this.theMap;
    }

    public void setUnit(Length units) {
        this.unit = units;
    }

    public Length getUnit() {
        return this.unit;
    }

    public void showAzimuth(boolean onOff) {
        this.showAngle = onOff;
    }

    public boolean getShowAzimuth() {
        return this.showAngle;
    }

    public void setLineType(int lype) {
        this.lineType = lype;
    }

    public int getLineType() {
        return this.lineType;
    }

    public void showCircle(boolean onOff) {
        this.displayCircle = onOff;
    }

    public boolean getShowCircle() {
        return this.displayCircle;
    }

    public boolean isDisplayCircle() {
        return this.displayCircle;
    }

    public void setDisplayCircle(boolean displayCircle) {
        this.displayCircle = displayCircle;
    }

    public boolean isShowAngle() {
        return this.showAngle;
    }

    public void setShowAngle(boolean showAngle) {
        this.showAngle = showAngle;
    }

    public double getTotalDistance() {
        return this.totalDistance;
    }

    public void setTotalDistance(double totalDistance) {
        this.totalDistance = totalDistance;
    }

    public void setProperties(String prefix, Properties setList) {
        super.setProperties(prefix, setList);
        this.renderAttributes.setProperties(prefix, setList);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        String name = setList.getProperty(prefix + UnitProperty);
        if (name != null) {
            Length length = Length.get(name);
            if (length != null) {
                this.setUnit(length);
            } else if (name.equals(AllUnitsPropertyValue)) {
                this.setUnit(null);
            }
        }
        this.showCircle(PropUtils.booleanFromProperties(setList, prefix + ShowCircleProperty, true));
        this.showAzimuth(PropUtils.booleanFromProperties(setList, prefix + ShowAngleProperty, true));
    }

    public Properties getProperties(Properties getList) {
        if (getList == null) {
            getList = new Properties();
        }
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        String unitValue = this.unit != null ? this.unit.toString() : AllUnitsPropertyValue;
        getList.put(prefix + UnitProperty, unitValue);
        getList.put(prefix + ShowCircleProperty, new Boolean(this.getShowCircle()).toString());
        getList.put(prefix + ShowAngleProperty, new Boolean(this.getShowAzimuth()).toString());
        this.renderAttributes.getProperties(getList);
        return getList;
    }

    public Properties getPropertyInfo(Properties list) {
        list = super.getPropertyInfo(list);
        list.put(UnitProperty, "Units to use for measurements, from Length.name possibilities.");
        list.put(ShowCircleProperty, "Flag to set whether the range circle is drawn at the end of the line (true/false).");
        list.put(ShowAngleProperty, "Flag to note the azimuth angle of the line in the information line (true/false).");
        this.renderAttributes.getPropertyInfo(list);
        list.put("initProperties", "units showCircle showAngle lineColor mattingColor matted");
        return list;
    }
}

