/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.shape;

import com.bbn.openmap.dataAccess.shape.EsriGraphic;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.omGraphics.OMPoly;
import com.bbn.openmap.proj.ProjMath;

public class EsriPolygon
extends OMPoly
implements Cloneable,
EsriGraphic {
    protected double[] extents;

    public EsriPolygon(double[] points, int units, int lineType) {
        super(points, units, lineType);
    }

    public void setExtents(double[] extents) {
        this.extents = extents;
    }

    public double[] getExtents() {
        if (this.extents == null) {
            this.extents = new double[]{90.0, 180.0, -90.0, -180.0};
            double[] points = super.getLatLonArray();
            double[] degreePoints = new double[points.length];
            System.arraycopy(points, 0, degreePoints, 0, points.length);
            this.addExtents(ProjMath.arrayRadToDeg(degreePoints));
        }
        return this.extents;
    }

    public void setType(int t) {
    }

    public int getType() {
        return 5;
    }

    public void addExtents(double[] graphicExtents) {
        double[] ex = this.getExtents();
        for (int i = 0; i < graphicExtents.length - 1; i += 2) {
            if (ex[0] > graphicExtents[i]) {
                ex[0] = graphicExtents[i];
            }
            if (ex[1] > graphicExtents[i + 1]) {
                ex[1] = graphicExtents[i + 1];
            }
            if (ex[2] < graphicExtents[i]) {
                ex[2] = graphicExtents[i];
            }
            if (!(ex[3] < graphicExtents[i + 1])) continue;
            ex[3] = graphicExtents[i + 1];
        }
    }

    public static EsriPolygon convert(OMPoly ompoly) {
        if (ompoly.getRenderType() == 1) {
            double[] rawLL = ompoly.getLatLonArray();
            double[] degreePoints = new double[rawLL.length];
            System.arraycopy(rawLL, 0, degreePoints, 0, rawLL.length);
            EsriPolygon ePoly = new EsriPolygon(degreePoints, 1, ompoly.getLineType());
            DrawingAttributes attributes = new DrawingAttributes();
            attributes.setFrom(ompoly);
            attributes.setTo(ePoly);
            ePoly.setAttributes(ompoly.getAttributes());
            ePoly.setIsPolygon(true);
            return ePoly;
        }
        return null;
    }

    public EsriGraphic shallowCopy() {
        return this.shallowCopyPolygon();
    }

    public EsriPolygon shallowCopyPolygon() {
        return (EsriPolygon)this.clone();
    }
}

