/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.mapTile;

import com.bbn.openmap.dataAccess.mapTile.MapTileCoordinateTransform;
import com.bbn.openmap.dataAccess.mapTile.OSMMapTileCoordinateTransform;
import com.bbn.openmap.proj.Mercator;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.coords.LatLonPoint;
import java.awt.geom.Point2D;

public abstract class AbstractMapTileCoordinateTransform
implements MapTileCoordinateTransform {
    int tileSize = 256;
    int DEFAULT_ZOOM_LEVEL_TILE_SIZE = 350;

    public Point2D latLonToTileUV(Point2D latlon, int zoom) {
        return this.latLonToTileUV(latlon, zoom, null);
    }

    public Point2D tileUVToLatLon(Point2D tileUV, int zoom) {
        return this.tileUVToLatLon(tileUV, zoom, null);
    }

    public float getScaleForZoom(int zoom) {
        Mercator proj = new Mercator(new LatLonPoint.Double(), 1000000.0f, 256, 256);
        return this.getScaleForZoomAndProjection(proj, zoom);
    }

    public float getScaleForZoomAndProjection(Projection proj, int zoom) {
        OSMMapTileCoordinateTransform mtct = new OSMMapTileCoordinateTransform();
        Point2D originLLUL = mtct.tileUVToLatLon(new Point2D.Double(0.0, 0.0), zoom);
        Point2D originLLLR = mtct.tileUVToLatLon(new Point2D.Double(1.0, 1.0), zoom);
        return proj.getScale(originLLUL, originLLLR, UVUL, UVLR);
    }

    public int getZoomLevelForProj(Projection proj) {
        return this.getZoomLevelForProj(proj, this.DEFAULT_ZOOM_LEVEL_TILE_SIZE);
    }

    public int getZoomLevelForProj(Projection proj, int zoomLevelTileSize) {
        int low = 1;
        int high = 20;
        float currentScale = proj.getScale();
        int ret = low;
        for (int currentZoom = low; currentZoom <= high; ++currentZoom) {
            Point2D nttc = this.latLonToTileUV((Point2D)proj.getCenter(), currentZoom);
            double nttcX = Math.floor(nttc.getX());
            double nttcY = Math.floor(nttc.getY());
            Point2D originLLUL = this.tileUVToLatLon(new Point2D.Double(nttcX, nttcY), currentZoom);
            Point2D originLLLR = this.tileUVToLatLon(new Point2D.Double(nttcX + 1.0, nttcY + 1.0), currentZoom);
            Point2D projUVUL = proj.forward(originLLUL);
            Point2D projLLLR = proj.forward(originLLLR);
            if (!(Math.abs(projUVUL.getX() - projLLLR.getX()) <= (double)zoomLevelTileSize)) continue;
            return currentZoom;
        }
        return ret;
    }

    public float[] getScalesForZoomLevels(Projection proj, int highZoomLevel) {
        float[] ret = new float[highZoomLevel + 1];
        for (int i = 0; i <= highZoomLevel; ++i) {
            ret[i] = this.getScaleForZoomAndProjection(proj, i);
        }
        return ret;
    }

    public int getTileSize() {
        return this.tileSize;
    }
}

