/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.util.quadtree;

import com.bbn.openmap.MoreMath;
import com.bbn.openmap.util.DataOrganizer;
import com.bbn.openmap.util.quadtree.QuadTreeNode;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuadTree<T>
implements DataOrganizer<T>,
Serializable {
    static final long serialVersionUID = -7707825592455579873L;
    protected QuadTreeNode<T> top;

    public QuadTree() {
        this(90.0, -180.0, -90.0, 180.0, 20, -1.0);
    }

    public QuadTree(double north, double west, double south, double east, int maxItems) {
        this(north, west, south, east, maxItems, -1.0);
    }

    public QuadTree(int up, int left, int down, int right, int maxItems) {
        this(up, left, down, right, maxItems, 5.0);
    }

    public QuadTree(double north, double west, double south, double east, int maxItems, double minSize) {
        this.top = new QuadTreeNode(north, west, south, east, maxItems, minSize);
    }

    @Override
    public boolean put(double lat, double lon, T obj) {
        return this.top.put(lat, lon, obj);
    }

    @Override
    public T remove(double lat, double lon, T obj) {
        return this.top.remove(lat, lon, obj);
    }

    @Override
    public void clear() {
        this.top.clear();
    }

    @Override
    public T get(double lat, double lon) {
        return this.top.get(lat, lon);
    }

    @Override
    public T get(double lat, double lon, double withinDistance) {
        return this.top.get(lat, lon, withinDistance);
    }

    @Override
    public Collection get(double north, double west, double south, double east) {
        return this.get(north, west, south, east, null);
    }

    public Collection get(double north, double west, double south, double east, Collection collection) {
        if (collection == null) {
            collection = new ArrayList();
        }
        if (west > east || MoreMath.approximately_equal(west, east, 0.001)) {
            return this.top.get(north, west, south, 180.0, this.top.get(north, -180.0, south, east, collection));
        }
        return this.top.get(north, west, south, east, collection);
    }
}

