/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.proj;

import com.bbn.openmap.proj.coords.LatLonPoint;

public class RhumbCalculator {
    private RhumbCalculator() {
    }

    public static LatLonPoint calculatePointOnRhumbLine(LatLonPoint point, double azimuth, double dist) {
        double az = Math.PI * 2 - azimuth;
        double lat1 = point.getRadLat();
        double lon1 = point.getRadLon();
        double lat = lat1 + dist * Math.cos(az);
        double dphi = Math.log((1.0 + Math.sin(lat)) / Math.cos(lat)) - Math.log((1.0 + Math.sin(lat1)) / Math.cos(lat1));
        double dlon = 0.0;
        dlon = Math.abs(Math.cos(az)) > Math.sqrt(1.0E-14) ? dphi * Math.tan(az) : Math.sin(az) * dist / Math.cos(lat1);
        double lon = RhumbCalculator.mod(lon1 - dlon + Math.PI, Math.PI * 2) - Math.PI;
        return new LatLonPoint.Double(lat, lon, true);
    }

    private static double mod(double y, double x) {
        double ret = y >= 0.0 ? y - x * (double)((int)(y / x)) : y + x * (double)((int)(-y / x) + 1);
        return ret;
    }

    public static double getDistanceBetweenPoints(LatLonPoint p1, LatLonPoint p2) {
        double lat1 = p1.getRadLat();
        double lon1 = p1.getRadLon();
        double lat2 = p2.getRadLat();
        double lon2 = p2.getRadLon();
        double d = 0.0;
        double tc = 0.0;
        double dlon_W = RhumbCalculator.mod(lon2 - lon1, Math.PI * 2);
        double dlon_E = RhumbCalculator.mod(lon1 - lon2, Math.PI * 2);
        tc = RhumbCalculator.getAzimuthBetweenPoints(p1, p2);
        d = Math.abs(lat1 - lat2) < Math.sqrt(1.0E-14) ? Math.min(dlon_W, dlon_E) * Math.cos(lat1) : Math.abs((lat2 - lat1) / Math.cos(tc));
        return d;
    }

    public static double getAzimuthBetweenPoints(LatLonPoint p1, LatLonPoint p2) {
        double lat1 = p1.getRadLat();
        double lon1 = p1.getRadLon();
        double lat2 = p2.getRadLat();
        double lon2 = p2.getRadLon();
        double tc = 0.0;
        double dlon_W = RhumbCalculator.mod(lon2 - lon1, Math.PI * 2);
        double dlon_E = RhumbCalculator.mod(lon1 - lon2, Math.PI * 2);
        double dphi = Math.log((1.0 + Math.sin(lat2)) / Math.cos(lat2)) - Math.log((1.0 + Math.sin(lat1)) / Math.cos(lat1));
        tc = dlon_W < dlon_E ? RhumbCalculator.mod(Math.atan2(-dlon_W, dphi), Math.PI * 2) : RhumbCalculator.mod(Math.atan2(dlon_E, dphi), Math.PI * 2);
        return Math.PI * 2 - tc;
    }
}

