/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.plugin.wms;

import com.bbn.openmap.image.ImageServerConstants;
import com.bbn.openmap.plugin.WebImagePlugIn;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.awt.geom.Point2D;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;

public class WMSPlugIn
extends WebImagePlugIn
implements ImageServerConstants {
    protected String wmsServer = null;
    protected String imageFormat = "image/png";
    protected String imageQuality = "MEDIUM";
    protected String backgroundColor = "0x00FFFFFF";
    protected String transparent = "true";
    protected String wmsVersion = "1.1.1";
    protected String layers = null;
    protected String styles = null;
    protected String vendorSpecificNames = null;
    protected String vendorSpecificValues = null;
    protected String queryHeader = null;
    protected String mapRequestName = "GetMap";
    protected String errorHandling = "application/vnd.ogc.se_inimage";
    public static final String WMSNameProperty = "wmsname";
    public static final String WMSServerProperty = "wmsserver";
    public static final String ImageFormatProperty = "format";
    public static final String BackgroundColorProperty = "backgroundcolor";
    public static final String TransparentProperty = "transparent";
    public static final String WMSVersionProperty = "wmsversion";
    public static final String LayersProperty = "layers";
    public static final String StylesProperty = "styles";
    public static final String VendorSpecificNamesProperty = "vendorspecificnames";
    public static final String VendorSpecificValuesProperty = "vendorspecificvalues";
    public static final int LOSSY_IMAGE_QUALITY_HIGH = 2;
    public static final int LOSSY_IMAGE_QUALITY_MEDIUM = 1;
    public static final int LOSSY_IMAGE_QUALITY_LOW = 0;

    public void addLayers(String[] ls) {
        this.addLayers(ls, null);
    }

    public void addLayers(String[] ls, String[] st) {
        for (int j = 0; j < ls.length; ++j) {
            this.layers = this.layers + "," + ls[j];
            this.styles = st == null || j >= st.length || st[j] == null ? this.styles + "," : this.styles + "," + st[j];
        }
    }

    public String createQueryString(Projection p) {
        String cStyles;
        if (this.queryHeader == null) {
            return null;
        }
        String bbox = "undefined";
        String height = "undefined";
        String width = "undefined";
        String sCoordParamName = "SRS";
        if (p != null) {
            Object ul = p.getUpperLeft();
            Object lr = p.getLowerRight();
            if (this.wmsVersion.compareTo("1.3.0") == 0) {
                bbox = Double.toString(((Point2D)lr).getY()) + "," + Double.toString(((Point2D)ul).getX()) + "," + Double.toString(((Point2D)ul).getY()) + "," + Double.toString(((Point2D)lr).getX());
                sCoordParamName = "CRS";
                this.errorHandling = "INIMAGE";
            } else {
                bbox = Double.toString(((Point2D)ul).getX()) + "," + Double.toString(((Point2D)lr).getY()) + "," + Double.toString(((Point2D)lr).getX()) + "," + Double.toString(((Point2D)ul).getY());
            }
            height = Integer.toString(p.getHeight());
            width = Integer.toString(p.getWidth());
        }
        StringBuffer buf = new StringBuffer(this.queryHeader);
        buf.append("?").append("VERSION").append("=").append(this.wmsVersion).append("&").append("REQUEST").append("=").append(this.mapRequestName).append("&").append(sCoordParamName).append("=").append("EPSG:4326").append("&").append("BBOX").append("=").append(bbox).append("&").append("HEIGHT").append("=").append(height).append("&").append("WIDTH").append("=").append(width).append("&").append("EXCEPTIONS").append("=").append(this.errorHandling);
        if (this.imageFormat != null) {
            buf.append("&").append("FORMAT").append("=").append(this.imageFormat);
            String baseImageFormat = this.imageFormat;
            if (baseImageFormat.indexOf(47) > 0) {
                baseImageFormat = baseImageFormat.substring(baseImageFormat.indexOf(47));
            }
            if (baseImageFormat.equals("JPEG")) {
                buf.append("&quality=").append(this.imageQuality);
            }
        }
        if (this.transparent != null) {
            buf.append("&").append("TRANSPARENT").append("=").append(this.transparent);
        }
        if (this.backgroundColor != null) {
            buf.append("&").append("BGCOLOR").append("=").append(this.backgroundColor);
        }
        if (this.layers != null) {
            buf.append("&").append("LAYERS").append("=").append(this.layers);
        }
        if ((cStyles = this.styles) == null) {
            cStyles = "";
        }
        buf.append("&").append("STYLES").append("=").append(cStyles);
        if (Debug.debugging("wms")) {
            Debug.output("query string: " + buf);
        }
        if (this.vendorSpecificNames != null && this.vendorSpecificValues != null) {
            StringTokenizer nameTokenizer = new StringTokenizer(this.vendorSpecificNames, ",");
            StringTokenizer valueTokenizer = new StringTokenizer(this.vendorSpecificValues, ",");
            String paramName = null;
            String paramValue = null;
            while (nameTokenizer.hasMoreTokens()) {
                try {
                    paramName = nameTokenizer.nextToken();
                    paramValue = valueTokenizer.nextToken();
                    buf.append("&").append(paramName).append("=").append(paramValue);
                }
                catch (NoSuchElementException e) {
                    if (!Debug.debugging("wms")) continue;
                    Debug.output("WMSPlugIn.getRectangle(): parameter \"" + paramName + "\" has no value");
                }
            }
        }
        return buf.toString();
    }

    public void setProperties(String prefix, Properties setList) {
        super.setProperties(prefix, setList);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.wmsServer = setList.getProperty(prefix + WMSServerProperty);
        if (this.wmsServer == null) {
            Debug.error("WMSPlugIn needs a WMS server.");
        }
        this.queryHeader = this.wmsServer;
        this.setImageFormat(setList.getProperty(prefix + ImageFormatProperty, this.getImageFormat()));
        this.setTransparent(setList.getProperty(prefix + TransparentProperty, this.getTransparent()));
        this.setBackgroundColor(setList.getProperty(prefix + BackgroundColorProperty, this.getBackgroundColor()));
        this.setWmsVersion(setList.getProperty(prefix + WMSVersionProperty, this.getWmsVersion()));
        this.layers = setList.getProperty(prefix + LayersProperty);
        this.styles = setList.getProperty(prefix + StylesProperty);
        this.setVendorSpecificNames(setList.getProperty(prefix + VendorSpecificNamesProperty, this.getVendorSpecificNames()));
        this.setVendorSpecificValues(setList.getProperty(prefix + VendorSpecificValuesProperty, this.getVendorSpecificValues()));
    }

    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        props.put(prefix + WMSServerProperty, PropUtils.unnull(this.wmsServer));
        props.put(prefix + ImageFormatProperty, PropUtils.unnull(this.imageFormat));
        props.put(prefix + TransparentProperty, PropUtils.unnull(this.transparent));
        props.put(prefix + BackgroundColorProperty, PropUtils.unnull(this.backgroundColor));
        props.put(prefix + WMSVersionProperty, PropUtils.unnull(this.wmsVersion));
        props.put(prefix + LayersProperty, PropUtils.unnull(this.layers));
        props.put(prefix + StylesProperty, PropUtils.unnull(this.styles));
        props.put(prefix + VendorSpecificNamesProperty, PropUtils.unnull(this.vendorSpecificNames));
        props.put(prefix + VendorSpecificValuesProperty, PropUtils.unnull(this.vendorSpecificValues));
        return props;
    }

    public Properties getPropertyInfo(Properties props) {
        props = super.getPropertyInfo(props);
        props.put("initProperties", "wmsserver wmsversion layers styles vendorspecificnames vendorspecificvalues format transparent backgroundcolor");
        props.put(WMSServerProperty, "URL to the server script that responds to WMS map requests");
        props.put(ImageFormatProperty, "Image format (GIF, PNG, JPEG)");
        props.put(TransparentProperty, "Flag to indicate that background of image should be tranparent");
        props.put("transparent.editor", "com.bbn.openmap.util.propertyEditor.YesNoPropertyEditor");
        props.put(BackgroundColorProperty, "The Background color for the image");
        props.put("backgroundcolor.editor", "com.bbn.openmap.util.propertyEditor.ColorPropertyEditor");
        props.put(WMSVersionProperty, "The WMS specification version");
        props.put(LayersProperty, "A list of layers to use in the query");
        props.put(StylesProperty, "A list of layer styles to use in the query");
        props.put(VendorSpecificNamesProperty, "Vendor-specific capability names to use in the query");
        props.put(VendorSpecificValuesProperty, "Vendor-specific capability values for the names");
        return props;
    }

    public String getImageFormat() {
        return this.imageFormat;
    }

    public void setImageFormat(String newImageFormat) {
        this.imageFormat = newImageFormat.indexOf(47) > 0 ? newImageFormat : "image/" + newImageFormat.toLowerCase();
    }

    public void setImageQuality(int newImageQuality) {
        if (newImageQuality == 2) {
            this.imageQuality = "HIGH";
        } else if (newImageQuality == 1) {
            this.imageQuality = "MEDIUM";
        } else if (newImageQuality == 0) {
            this.imageQuality = "LOW";
        }
    }

    public String getImageQuality() {
        return this.imageQuality;
    }

    public void setImageQuality(String imageQuality) {
        this.imageQuality = imageQuality;
    }

    public String getTransparent() {
        return this.transparent;
    }

    public void setTransparent(String transparent) {
        if (transparent != null) {
            transparent = Boolean.valueOf(transparent).toString().toUpperCase();
        }
        this.transparent = transparent;
    }

    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(String backgroundColor) {
        if (backgroundColor != null) {
            if (backgroundColor.length() > 6) {
                backgroundColor = backgroundColor.substring(backgroundColor.length() - 6);
            }
            if (!backgroundColor.startsWith("0x")) {
                backgroundColor = "0x" + backgroundColor;
            }
        }
        this.backgroundColor = backgroundColor;
    }

    public String getErrorHandling() {
        return this.errorHandling;
    }

    public void setErrorHandling(String errorHandling) {
        this.errorHandling = errorHandling;
    }

    public String getLayers() {
        return this.layers;
    }

    public void setLayers(String layers) {
        this.layers = layers;
    }

    public String getMapRequestName() {
        return this.mapRequestName;
    }

    public void setMapRequestName(String mapRequestName) {
        this.mapRequestName = mapRequestName;
    }

    public String getQueryHeader() {
        return this.queryHeader;
    }

    public void setQueryHeader(String queryHeader) {
        this.queryHeader = queryHeader;
    }

    public String getStyles() {
        return this.styles;
    }

    public void setStyles(String styles) {
        this.styles = styles;
    }

    public String getVendorSpecificNames() {
        return this.vendorSpecificNames;
    }

    public void setVendorSpecificNames(String vendorSpecificNames) {
        this.vendorSpecificNames = vendorSpecificNames;
    }

    public String getVendorSpecificValues() {
        return this.vendorSpecificValues;
    }

    public void setVendorSpecificValues(String vendorSpecificValues) {
        this.vendorSpecificValues = vendorSpecificValues;
    }

    public String getWmsServer() {
        return this.wmsServer;
    }

    public void setWmsServer(String wmsServer) {
        this.wmsServer = wmsServer;
    }

    public String getServerName() {
        return this.wmsServer;
    }

    public String getWmsVersion() {
        return this.wmsVersion;
    }

    public void setWmsVersion(String wmsVer) {
        if (wmsVer == null || wmsVer.length() == 0) {
            wmsVer = "1.1.1";
            Debug.output("WMSPlugin: wmsVersion was null, now set to 1.1.1");
        }
        if (Debug.debugging("wms")) {
            Debug.output("WMSPlugIn: set up with header \"" + this.queryHeader + "\"");
        }
        StringTokenizer st = new StringTokenizer(wmsVer, ".");
        int majorVersion = Integer.parseInt(st.nextToken());
        int midVersion = Integer.parseInt(st.nextToken());
        int minorVersion = Integer.parseInt(st.nextToken());
        if (majorVersion == 1 && midVersion == 0 && minorVersion < 3) {
            this.mapRequestName = "map";
        }
        if (majorVersion == 1 && minorVersion > 7 && !this.imageFormat.startsWith("image/")) {
            this.imageFormat = "image/" + this.imageFormat;
        }
        if (majorVersion == 1 && midVersion == 0) {
            this.errorHandling = "INIMAGE";
        } else if (majorVersion == 1 && midVersion >= 1 && minorVersion > 1) {
            this.errorHandling = "application/vnd.ogc.se+inimage";
        } else if (majorVersion > 1) {
            this.errorHandling = "application/vnd.ogc.se+inimage";
        }
        this.wmsVersion = wmsVer;
    }
}

