/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.vpf;

import com.bbn.openmap.layer.vpf.VPFLayer;
import com.bbn.openmap.util.Debug;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VPFUtil {
    public static final String Edge = "Edge";
    public static final String Edges = "Edges";
    public static final String Text = "Text";
    public static final String Area = "Area";
    public static final String EPoint = "EPoint";
    public static final String CPoint = "CPoint";

    private VPFUtil() {
    }

    public static final String vectorToString(List<Object> l) {
        return VPFUtil.listToString(l);
    }

    public static final String listToString(List<Object> l) {
        StringBuffer row = new StringBuffer();
        for (Object obj : l) {
            row.append(obj.toString()).append(" ");
        }
        return row.toString();
    }

    public static final int objectToInt(Object val) {
        int v = Integer.MIN_VALUE;
        if (val instanceof Integer) {
            v = (Integer)val;
            if (v == -2147483647) {
                v = Integer.MIN_VALUE;
            }
        } else if (val instanceof Short && (v = (int)((Short)val).shortValue()) == -32767) {
            v = Integer.MIN_VALUE;
        }
        return v;
    }

    public static Hashtable<String, Boolean> parseDynamicArgs(String args) {
        Hashtable<String, Boolean> dynArgs = new Hashtable<String, Boolean>();
        if (args != null) {
            String lowerArgs = args.toLowerCase();
            dynArgs.put(Edges, new Boolean(lowerArgs.indexOf(Edges) != -1));
            dynArgs.put(Text, new Boolean(lowerArgs.indexOf(Text) != -1));
            dynArgs.put(Area, new Boolean(lowerArgs.indexOf(Area) != -1));
            dynArgs.put(EPoint, new Boolean(lowerArgs.indexOf(EPoint) != -1));
            dynArgs.put(CPoint, new Boolean(lowerArgs.indexOf(CPoint) != -1));
        }
        return dynArgs;
    }

    public static boolean getHashedValueAsBoolean(Hashtable<String, Boolean> dynArgs, String arg) {
        Boolean obj = dynArgs.get(arg);
        if (obj == null) {
            return false;
        }
        if (obj instanceof Boolean) {
            return obj;
        }
        return false;
    }

    public static String getTypeForFeatureCode(String featureCode) {
        int lastCharIndex = featureCode.length() - 1;
        if (lastCharIndex >= 0) {
            char lastLetter = featureCode.charAt(lastCharIndex);
            if (lastLetter == 'l') {
                return Edge;
            }
            if (lastLetter == 'a') {
                return Area;
            }
            if (lastLetter == 't') {
                return Text;
            }
        }
        return null;
    }

    public static Properties getDefaultProperties() {
        try {
            InputStream in = VPFLayer.class.getResourceAsStream("defaultVPFlayers.properties");
            Properties tmp = new Properties();
            if (in != null) {
                tmp.load(in);
                in.close();
            } else {
                Debug.error("VPFUtil.getDefaultProperties: can't load default properties file");
            }
            return tmp;
        }
        catch (IOException io) {
            Debug.error("VPFUtil.getDefaultProperties: can't load default properties: " + io);
            return new Properties();
        }
    }
}

