/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.vpf;

import com.bbn.openmap.io.BinaryFile;
import com.bbn.openmap.io.FormatException;
import com.bbn.openmap.io.InvalidCharException;
import com.bbn.openmap.layer.vpf.CoordDoubleString;
import com.bbn.openmap.layer.vpf.CoordFloatString;
import com.bbn.openmap.layer.vpf.DcwCrossTileID;
import java.io.EOFException;
import java.io.UnsupportedEncodingException;

public class DcwColumnInfo {
    private final String columnName;
    private final char fieldType;
    private final int numberOfElements;
    private final char keyType;
    private final String columnDescription;
    private String valueDescriptionTable = null;
    private String thematicIndexName = null;
    private String narrativeTable = null;
    public static final char VPF_COLUMN_TEXT = 'T';
    public static final char VPF_COLUMN_TEXTL1 = 'L';
    public static final char VPF_COLUMN_TEXTL2 = 'M';
    public static final char VPF_COLUMN_TEXTL3 = 'N';
    public static final char VPF_COLUMN_FLOAT = 'F';
    public static final char VPF_COLUMN_DOUBLE = 'R';
    public static final char VPF_COLUMN_SHORT = 'S';
    public static final char VPF_COLUMN_INT = 'I';
    public static final char VPF_COLUMN_FLOAT_2COORD = 'C';
    public static final char VPF_COLUMN_DOUBLE_2COORD = 'B';
    public static final char VPF_COLUMN_FLOAT_3COORD = 'Z';
    public static final char VPF_COLUMN_DOUBLE_3COORD = 'Y';
    public static final char VPF_COLUMN_DATE = 'D';
    public static final char VPF_COLUMN_NULL = 'X';
    public static final char VPF_COLUMN_TRIPLET = 'K';
    public static final char VPF_COLUMN_INT_OR_SHORT = 'i';
    public static final char VPF_COLUMN_PRIMARY_KEY = 'P';
    public static final char VPF_COLUMN_FOREIGN_KEY = 'F';
    public static final char VPF_COLUMN_NON_KEY = 'N';

    public DcwColumnInfo(BinaryFile inputFile) throws EOFException, FormatException {
        String tmpkeyType;
        char delim = inputFile.readChar();
        if (delim == ';') {
            throw new EOFException();
        }
        StringBuffer buildstring = new StringBuffer();
        do {
            buildstring.append(Character.toLowerCase(delim));
        } while ((delim = inputFile.readChar()) != '=');
        this.columnName = buildstring.toString().trim().intern();
        this.fieldType = inputFile.readChar();
        delim = inputFile.readChar();
        if (delim != ',' && delim != ' ') {
            throw new InvalidCharException("Illegal delimiter character", delim);
        }
        buildstring = new StringBuffer();
        while ((delim = inputFile.readChar()) != ',') {
            if (Character.isWhitespace(delim)) continue;
            buildstring.append(delim);
        }
        String nEls = buildstring.toString();
        int n = this.numberOfElements = nEls.equals("*") ? -1 : Integer.parseInt(nEls);
        if (this.numberOfElements != 1) {
            switch (this.fieldType) {
                case 'D': 
                case 'F': 
                case 'I': 
                case 'K': 
                case 'R': 
                case 'S': 
                case 'X': {
                    throw new FormatException("Illegal array type: " + this.fieldType + "for column " + this.columnName);
                }
            }
        }
        if ((tmpkeyType = this.readColumnText(inputFile)) == null) {
            throw new FormatException("keyType is required column info");
        }
        if ((tmpkeyType = tmpkeyType.trim()).length() != 1) {
            throw new FormatException("keyType is supposed to be 1 character");
        }
        this.keyType = tmpkeyType.charAt(0);
        this.columnDescription = this.readColumnText(inputFile);
        if (this.columnDescription == null) {
            return;
        }
        this.valueDescriptionTable = this.readColumnTextLowerCase(inputFile);
        if (this.valueDescriptionTable == null) {
            return;
        }
        this.valueDescriptionTable = this.valueDescriptionTable.equals("-") ? null : this.valueDescriptionTable.intern();
        this.thematicIndexName = this.readColumnTextLowerCase(inputFile);
        if (this.thematicIndexName == null) {
            return;
        }
        this.thematicIndexName = this.thematicIndexName.equals("-") ? null : this.thematicIndexName.intern();
        this.narrativeTable = this.readColumnTextLowerCase(inputFile);
        if (this.narrativeTable == null) {
            return;
        }
        this.narrativeTable = this.narrativeTable.equals("-") ? null : this.narrativeTable.intern();
        inputFile.assertChar(':');
    }

    private String readColumnText(BinaryFile inputFile) throws FormatException {
        StringBuffer buildretval = new StringBuffer();
        boolean skipnext = false;
        try {
            char tmp;
            while ((tmp = inputFile.readChar()) != ',') {
                if (tmp == ':' && !skipnext) {
                    return null;
                }
                if (tmp == '\\') {
                    skipnext = true;
                    continue;
                }
                skipnext = false;
                buildretval.append(tmp);
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return buildretval.toString();
    }

    private String readColumnTextLowerCase(BinaryFile inputFile) throws FormatException {
        StringBuffer buildretval = new StringBuffer();
        boolean skipnext = false;
        try {
            char tmp;
            while ((tmp = inputFile.readChar()) != ',') {
                if (tmp == ':' && !skipnext) {
                    return null;
                }
                if (tmp == '\\') {
                    skipnext = true;
                    continue;
                }
                skipnext = false;
                buildretval.append(Character.toLowerCase(tmp));
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return buildretval.toString();
    }

    public void assertSchema(char type, int length, boolean strictlength) throws FormatException {
        if (type != this.fieldType && (type != 'i' || this.fieldType != 'I' && this.fieldType != 'S')) {
            throw new FormatException("AssertSchema failed on fieldType!");
        }
        if (strictlength && length != this.numberOfElements || !strictlength && length != -1 && length != this.numberOfElements) {
            throw new FormatException("AssertSchema failed on length!");
        }
    }

    public int fieldLength() throws FormatException {
        if (this.numberOfElements == -1) {
            return -1;
        }
        switch (this.fieldType) {
            case 'L': 
            case 'M': 
            case 'N': 
            case 'T': {
                return this.numberOfElements;
            }
            case 'F': {
                return 4;
            }
            case 'R': {
                return 8;
            }
            case 'S': {
                return 2;
            }
            case 'I': {
                return 4;
            }
            case 'C': {
                return this.numberOfElements * 8;
            }
            case 'B': {
                return this.numberOfElements * 16;
            }
            case 'Z': {
                return this.numberOfElements * 12;
            }
            case 'Y': {
                return this.numberOfElements * 24;
            }
            case 'D': {
                return 20;
            }
            case 'X': {
                return 0;
            }
            case 'K': {
                return -1;
            }
        }
        throw new FormatException("Unknown field type: " + this.fieldType);
    }

    public String getColumnName() {
        return this.columnName;
    }

    public char getFieldType() {
        return this.fieldType;
    }

    public int getNumberOfElements() {
        return this.numberOfElements;
    }

    public char getKeyType() {
        return this.keyType;
    }

    public boolean isPrimaryKey() {
        return this.keyType == 'P';
    }

    public boolean isForeignKey() {
        return this.keyType == 'F';
    }

    public boolean isNonKey() {
        return this.keyType == 'N';
    }

    public String getColumnDescription() {
        return this.columnDescription;
    }

    public String getValueDescriptionTable() {
        return this.valueDescriptionTable;
    }

    public String getVDT() {
        return this.valueDescriptionTable;
    }

    public String getThematicIndexName() {
        return this.thematicIndexName;
    }

    public String getNarrativeTable() {
        return this.narrativeTable;
    }

    public Object parseField(BinaryFile inputFile) throws EOFException, FormatException {
        boolean haveElements = this.numberOfElements != -1;
        int numels = this.numberOfElements;
        switch (this.fieldType) {
            case 'T': {
                if (!haveElements) {
                    numels = inputFile.readInteger();
                }
                if (numels == 0) {
                    return "";
                }
                String s = inputFile.readFixedLengthString(numels);
                if (haveElements) {
                    s = s.trim();
                }
                return s;
            }
            case 'L': {
                if (!haveElements) {
                    numels = inputFile.readInteger();
                }
                if (numels == 0) {
                    return "";
                }
                byte[] str = inputFile.readBytes(numels, false);
                try {
                    String s = new String(str, "ISO8859_1");
                    if (haveElements) {
                        s = s.trim();
                    }
                    return s;
                }
                catch (UnsupportedEncodingException uee) {
                    return str;
                }
            }
            case 'M': 
            case 'N': {
                if (!haveElements) {
                    numels = inputFile.readInteger();
                }
                if (numels == 0) {
                    return new byte[0];
                }
                return inputFile.readBytes(numels, false);
            }
            case 'F': {
                return new Float(inputFile.readFloat());
            }
            case 'R': {
                return new Double(inputFile.readDouble());
            }
            case 'S': {
                return new Short(inputFile.readShort());
            }
            case 'I': {
                return new Integer(inputFile.readInteger());
            }
            case 'C': {
                if (!haveElements) {
                    numels = inputFile.readInteger();
                }
                return new CoordFloatString(numels, 2, inputFile);
            }
            case 'B': {
                if (!haveElements) {
                    numels = inputFile.readInteger();
                }
                return new CoordDoubleString(numels, 2, inputFile);
            }
            case 'Z': {
                if (!haveElements) {
                    numels = inputFile.readInteger();
                }
                return new CoordFloatString(numels, 3, inputFile);
            }
            case 'Y': {
                if (!haveElements) {
                    numels = inputFile.readInteger();
                }
                return new CoordDoubleString(numels, 3, inputFile);
            }
            case 'D': {
                inputFile.readBytes(20, false);
                return "[skipped date]";
            }
            case 'X': {
                return "[Null Field Type]";
            }
            case 'K': {
                return new DcwCrossTileID(inputFile);
            }
        }
        throw new FormatException("Unknown field type: " + this.fieldType);
    }

    public String toString() {
        StringBuffer output = new StringBuffer();
        output.append(this.columnName).append(" ").append(this.fieldType).append(" ");
        output.append(this.numberOfElements).append(" ");
        output.append(this.keyType).append(" ");
        output.append(this.columnDescription).append(" ").append(this.valueDescriptionTable).append(" ");
        output.append(this.thematicIndexName).append(" ").append(this.narrativeTable);
        return output.toString();
    }
}

