/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.shape;

import com.bbn.openmap.dataAccess.shape.DbfHandler;
import com.bbn.openmap.io.BinaryBufferedFile;
import com.bbn.openmap.io.BinaryFile;
import com.bbn.openmap.io.FormatException;
import com.bbn.openmap.layer.OMGraphicHandlerLayer;
import com.bbn.openmap.layer.policy.BufferedImageRenderPolicy;
import com.bbn.openmap.layer.policy.ListResetPCPolicy;
import com.bbn.openmap.layer.shape.ESRIBoundingBox;
import com.bbn.openmap.layer.shape.SpatialIndex;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.proj.ProjMath;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.DataBounds;
import com.bbn.openmap.util.DataBoundsProvider;
import com.bbn.openmap.util.PropUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ShapeLayer
extends OMGraphicHandlerLayer
implements ActionListener,
DataBoundsProvider {
    private static final long serialVersionUID = 1L;
    public static Logger logger = Logger.getLogger("com.bbn.openmap.layer.shape.ShapeLayer");
    public static final String shapeFileProperty = "shapeFile";
    public static final String pointImageURLProperty = "pointImageURL";
    public static final String shadowXProperty = "shadowX";
    public static final String shadowYProperty = "shadowY";
    protected int shadowX = 0;
    protected int shadowY = 0;
    protected SpatialIndex spatialIndex;
    protected DrawingAttributes drawingAttributes = DrawingAttributes.getDefaultClone();
    String shapeFileName = null;
    String imageURLString = null;
    protected transient JPanel box;

    public ShapeLayer() {
        this.setProjectionChangePolicy(new ListResetPCPolicy(this));
        this.setRenderPolicy(new BufferedImageRenderPolicy(this));
    }

    public ShapeLayer(String shapeFileName) {
        this();
        this.spatialIndex = SpatialIndex.locateAndSetShapeData(shapeFileName);
    }

    public void setSpatialIndex(SpatialIndex si) {
        this.spatialIndex = si;
    }

    public SpatialIndex getSpatialIndex() {
        return this.spatialIndex;
    }

    protected DbfHandler createDbfHandler(String dbfFileName) throws FormatException, IOException {
        BinaryBufferedFile bbf = new BinaryBufferedFile(dbfFileName);
        return new DbfHandler(bbf);
    }

    protected void setFileProperties(String realPrefix, Properties props) {
        this.shapeFileName = props.getProperty(realPrefix + shapeFileProperty);
        this.shapeFileName = this.prependDataPathPrefix(this.shapeFileName);
        if (this.shapeFileName != null && this.shapeFileName.length() > 0) {
            block11: {
                this.spatialIndex = SpatialIndex.locateAndSetShapeData(this.shapeFileName);
                String dbfFileName = SpatialIndex.dbf(this.shapeFileName);
                try {
                    if (BinaryFile.exists(dbfFileName)) {
                        DbfHandler dbfh = this.createDbfHandler(dbfFileName);
                        dbfh.setProperties(realPrefix, props);
                        this.spatialIndex.setDbf(dbfh);
                    }
                }
                catch (FormatException fe) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.warning(this.getName() + ": Couldn't create DBF handler for " + dbfFileName + ", FormatException: " + fe.getMessage());
                    }
                }
                catch (IOException ioe) {
                    if (!logger.isLoggable(Level.FINE)) break block11;
                    logger.warning(this.getName() + ": Couldn't create DBF handler for " + dbfFileName + ", IOException: " + ioe.getMessage());
                }
            }
            this.imageURLString = props.getProperty(realPrefix + pointImageURLProperty);
            try {
                if (this.imageURLString != null && this.imageURLString.length() > 0) {
                    URL imageURL = PropUtils.getResourceOrFileOrURL(this, this.imageURLString);
                    ImageIcon imageIcon = new ImageIcon(imageURL);
                    this.spatialIndex.setPointIcon(imageIcon);
                }
            }
            catch (MalformedURLException murle) {
                logger.warning(this.getName() + ": point image URL not so good: \n\t" + this.imageURLString);
            }
            catch (NullPointerException npe) {
                this.fireRequestMessage("Can't access icon image: \n    " + this.imageURLString);
            }
            this.setSpatialIndex(this.spatialIndex);
        } else {
            logger.warning(this.getName() + ": No Shape file was specified:\n\t" + realPrefix + shapeFileProperty);
        }
    }

    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
        this.drawingAttributes.setProperties(prefix, props);
        String realPrefix = PropUtils.getScopedPropertyPrefix(this);
        this.setFileProperties(realPrefix, props);
        this.shadowX = PropUtils.intFromProperties(props, realPrefix + shadowXProperty, 0);
        this.shadowY = PropUtils.intFromProperties(props, realPrefix + shadowYProperty, 0);
    }

    public Properties getProperties(Properties props) {
        DbfHandler dbfh;
        props = super.getProperties(props);
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        props.put(prefix + shapeFileProperty, this.shapeFileName == null ? "" : this.shapeFileName);
        props.put(prefix + pointImageURLProperty, this.imageURLString == null ? "" : this.imageURLString);
        props.put(prefix + shadowXProperty, Integer.toString(this.shadowX));
        props.put(prefix + shadowYProperty, Integer.toString(this.shadowY));
        if (this.drawingAttributes != null) {
            this.drawingAttributes.setPropertyPrefix(this.getPropertyPrefix());
            this.drawingAttributes.getProperties(props);
        } else {
            DrawingAttributes da = (DrawingAttributes)DrawingAttributes.DEFAULT.clone();
            da.setPropertyPrefix(this.getPropertyPrefix());
            da.getProperties(props);
        }
        if (this.spatialIndex != null && (dbfh = this.spatialIndex.getDbf()) != null) {
            dbfh.getProperties(props);
        }
        return props;
    }

    public Properties getPropertyInfo(Properties list) {
        list = super.getPropertyInfo(list);
        String dummyMarker = PropUtils.getDummyMarkerForPropertyInfo(this.getPropertyPrefix(), null);
        PropUtils.setI18NPropertyInfo(this.i18n, list, ShapeLayer.class, dummyMarker, "Rendering Attributes", "Attributes that determine how the shapes will be drawn.", "com.bbn.openmap.omGraphics.DrawingAttributesPropertyEditor");
        list.put("initProperties", "shapeFile  pointImageURL shadowX shadowY " + dummyMarker + " " + "addToBeanContext" + " " + "minScale" + " " + "maxScale");
        PropUtils.setI18NPropertyInfo(this.i18n, list, ShapeLayer.class, shapeFileProperty, shapeFileProperty, "Location of Shape file - .shp (File, CURL or relative file path).", "com.bbn.openmap.util.propertyEditor.FUPropertyEditor");
        PropUtils.setI18NPropertyInfo(this.i18n, list, ShapeLayer.class, pointImageURLProperty, pointImageURLProperty, "Image file to use for map location of point data (optional).", "com.bbn.openmap.util.propertyEditor.FUPropertyEditor");
        PropUtils.setI18NPropertyInfo(this.i18n, list, ShapeLayer.class, shadowXProperty, shadowXProperty, "Horizontal pixel offset for shadow image for shapes.", null);
        PropUtils.setI18NPropertyInfo(this.i18n, list, ShapeLayer.class, shadowYProperty, shadowYProperty, "Vertical pixel offset for shadow image for shapes.", null);
        return list;
    }

    public void setDrawingAttributes(DrawingAttributes da) {
        this.drawingAttributes = da;
    }

    public DrawingAttributes getDrawingAttributes() {
        return this.drawingAttributes;
    }

    public String getInfoText(OMGraphic omg) {
        return (String)omg.getAttribute("Information Line");
    }

    public String getToolTipTextFor(OMGraphic omg) {
        return (String)omg.getAttribute("Tooltip");
    }

    protected OMGraphicList computeGraphics() {
        return this.prepare();
    }

    public synchronized OMGraphicList prepare() {
        OMGraphicList list;
        block23: {
            list = this.getList();
            Projection projection = this.getProjection();
            boolean DEBUG_FINE = logger.isLoggable(Level.FINE);
            if (projection == null) {
                if (DEBUG_FINE) {
                    logger.fine(this.getName() + ": prepare called with null projection");
                }
                return new OMGraphicList();
            }
            if (this.spatialIndex == null) {
                if (DEBUG_FINE) {
                    logger.fine(this.getName() + ": spatialIndex is null!");
                }
                if (list != null) {
                    list.generate(projection, true);
                    return list;
                }
                return new OMGraphicList();
            }
            Object ul = projection.getUpperLeft();
            Object lr = projection.getLowerRight();
            double ulLat = ((Point2D)ul).getY();
            double ulLon = ((Point2D)ul).getX();
            double lrLat = ((Point2D)lr).getY();
            double lrLon = ((Point2D)lr).getX();
            if (list != null) {
                list.clear();
                list = new OMGraphicList();
            }
            if (ProjMath.isCrossingDateline(ulLon, lrLon, projection.getScale())) {
                if (DEBUG_FINE) {
                    logger.fine("ShapeLayer.computeGraphics(): Dateline is on screen");
                }
                double ymin = Math.min(ulLat, lrLat);
                double ymax = Math.max(ulLat, lrLat);
                try {
                    list = this.spatialIndex.getOMGraphics(ulLon, ymin, 180.0, ymax, list, this.drawingAttributes, projection, this.coordTransform);
                    list = this.spatialIndex.getOMGraphics(-180.0, ymin, lrLon, ymax, list, this.drawingAttributes, projection, this.coordTransform);
                }
                catch (InterruptedIOException iioe) {
                    list = null;
                }
                catch (IOException ex) {
                    if (DEBUG_FINE) {
                        ex.printStackTrace();
                    }
                    break block23;
                }
                catch (FormatException fe) {
                    if (DEBUG_FINE) {
                        fe.printStackTrace();
                    }
                    break block23;
                }
                catch (NullPointerException npe) {
                    if (DEBUG_FINE) {
                        npe.printStackTrace();
                    }
                    break block23;
                }
            }
            double xmin = Math.min(ulLon, lrLon);
            double xmax = Math.max(ulLon, lrLon);
            double ymin = Math.min(ulLat, lrLat);
            double ymax = Math.max(ulLat, lrLat);
            try {
                list = this.spatialIndex.getOMGraphics(xmin, ymin, xmax, ymax, list, this.drawingAttributes, projection, this.coordTransform);
            }
            catch (InterruptedIOException iioe) {
                list = null;
            }
            catch (IOException ex) {
                if (DEBUG_FINE) {
                    ex.printStackTrace();
                }
            }
            catch (FormatException fe) {
                if (DEBUG_FINE) {
                    fe.printStackTrace();
                }
            }
            catch (NullPointerException npe) {
                if (!DEBUG_FINE) break block23;
                npe.printStackTrace();
            }
        }
        return list;
    }

    public void paint(Graphics g) {
        if (this.shadowX == 0 && this.shadowY == 0) {
            super.paint(g);
        } else {
            OMGraphicList omg = this.getList();
            if (omg != null) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("ShapeLayer.paint(): " + omg.size() + " omg" + " shadow=" + this.shadowX + "," + this.shadowY);
                }
                if (this.shadowX != 0 || this.shadowY != 0) {
                    Graphics shadowG = g.create();
                    shadowG.translate(this.shadowX, this.shadowY);
                    omg.render(shadowG);
                } else {
                    omg.render(g);
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("ShapeLayer.paint(): done");
                }
            }
        }
    }

    public Component getGUI() {
        if (this.box == null) {
            this.box = new JPanel();
            this.box.setLayout(new BoxLayout(this.box, 1));
            this.box.setAlignmentX(0.0f);
            JPanel stuff = new JPanel();
            JLabel label = new JLabel(this.i18n.get(ShapeLayer.class, "rendering_attributes", "Rendering Attributes: "));
            stuff.add(label);
            DrawingAttributes da = this.getDrawingAttributes();
            if (da != null) {
                stuff.add(da.getGUI());
            }
            this.box.add(stuff);
            JPanel pal2 = new JPanel();
            JButton redraw = new JButton(this.i18n.get(ShapeLayer.class, "redrawLayerButton", "Redraw Layer"));
            redraw.setActionCommand("redrawCmd");
            redraw.addActionListener(this);
            pal2.add(redraw);
            this.box.add(pal2);
        }
        return this.box;
    }

    public DataBounds getDataBounds() {
        ESRIBoundingBox bounds;
        DataBounds box = null;
        if (this.spatialIndex != null && (bounds = this.spatialIndex.getBounds()) != null) {
            box = new DataBounds(bounds.min.x, bounds.min.y, bounds.max.x, bounds.max.y);
        }
        return box;
    }

    public void removed(Container cont) {
        OMGraphicList list = this.getList();
        if (list != null) {
            list.clear();
            list = null;
        }
        if (this.spatialIndex != null) {
            this.spatialIndex.close(true);
        }
    }
}

