/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.rpf;

import com.bbn.openmap.Environment;
import com.bbn.openmap.I18n;
import com.bbn.openmap.PropertyConsumer;
import com.bbn.openmap.layer.rpf.RpfConstants;
import com.bbn.openmap.layer.rpf.RpfLayer;
import com.bbn.openmap.util.PropUtils;
import java.io.Serializable;
import java.util.Properties;

public class RpfViewAttributes
implements RpfConstants,
PropertyConsumer,
Serializable {
    public static final String ANY = "ANY";
    public static final String ALL = "ALL";
    public static final String COLORMODEL_DIRECT_STRING = "direct";
    public static final String COLORMODEL_INDEXED_STRING = "indexed";
    protected String propertyPrefix = null;
    public int numberOfColors;
    public int opaqueness;
    public int colorModel;
    public boolean scaleImages;
    public float imageScaleFactor;
    public String chartSeries;
    public boolean requireProjection;
    public boolean showMaps;
    public boolean showInfo;
    protected boolean scaleMoreImportantThanCoverage = true;
    public boolean autofetchAttributes;
    protected transient I18n i18n = Environment.getI18n();

    public RpfViewAttributes() {
        this.setDefaults();
    }

    public void setDefaults() {
        this.numberOfColors = 216;
        this.opaqueness = 255;
        this.scaleImages = true;
        this.imageScaleFactor = 4.0f;
        this.colorModel = 0;
        this.chartSeries = ANY;
        this.requireProjection = true;
        this.showMaps = true;
        this.showInfo = false;
        this.autofetchAttributes = false;
        this.scaleMoreImportantThanCoverage = true;
    }

    public boolean isScaleMoreImportantThanCoverage() {
        return this.scaleMoreImportantThanCoverage;
    }

    public void setScaleMoreImportantThanCoverage(boolean scaleMoreImportantThanCoverage) {
        this.scaleMoreImportantThanCoverage = scaleMoreImportantThanCoverage;
    }

    public void setProperties(Properties props) {
        this.setProperties(null, props);
    }

    public void setProperties(String prefix, Properties props) {
        this.propertyPrefix = prefix;
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.opaqueness = PropUtils.intFromProperties(props, prefix + "opaque", this.opaqueness);
        this.numberOfColors = PropUtils.intFromProperties(props, prefix + "numberColors", this.numberOfColors);
        this.showMaps = PropUtils.booleanFromProperties(props, prefix + "showMaps", this.showMaps);
        this.showInfo = PropUtils.booleanFromProperties(props, prefix + "showInfo", this.showInfo);
        this.scaleImages = PropUtils.booleanFromProperties(props, prefix + "scaleImages", this.scaleImages);
        this.chartSeries = props.getProperty(prefix + "chartSeries");
        this.autofetchAttributes = PropUtils.booleanFromProperties(props, prefix + "autofetchAttributes", this.autofetchAttributes);
        this.imageScaleFactor = PropUtils.floatFromProperties(props, prefix + "imageScaleFactor", this.imageScaleFactor);
        this.scaleMoreImportantThanCoverage = PropUtils.booleanFromProperties(props, prefix + "scaleOverCoverage", this.scaleMoreImportantThanCoverage);
        String colormodel = props.getProperty(prefix + "colormodel");
        this.colorModel = colormodel != null && colormodel.equalsIgnoreCase(COLORMODEL_INDEXED_STRING) ? 1 : 0;
    }

    public Properties getProperties(Properties props) {
        if (props == null) {
            props = new Properties();
        }
        String prefix = PropUtils.getScopedPropertyPrefix(this.propertyPrefix);
        props.put(prefix + "opaque", Integer.toString(this.opaqueness));
        props.put(prefix + "numberColors", Integer.toString(this.numberOfColors));
        props.put(prefix + "showMaps", Boolean.toString(this.showMaps));
        props.put(prefix + "showInfo", Boolean.toString(this.showInfo));
        props.put(prefix + "scaleImages", Boolean.toString(this.scaleImages));
        props.put(prefix + "chartSeries", this.chartSeries);
        props.put(prefix + "autofetchAttributes", Boolean.toString(this.autofetchAttributes));
        props.put(prefix + "imageScaleFactor", Float.toString(this.imageScaleFactor));
        props.put(prefix + "scaleOverCoverage", Boolean.toString(this.scaleMoreImportantThanCoverage));
        if (this.colorModel == 1) {
            props.put(prefix + "colormodel", COLORMODEL_INDEXED_STRING);
        } else {
            props.put(prefix + "colormodel", COLORMODEL_DIRECT_STRING);
        }
        return props;
    }

    public Properties getPropertyInfo(Properties list) {
        if (list == null) {
            list = new Properties();
        }
        String interString = this.i18n.get(RpfLayer.class, "opaque", 3, "Integer representing opaqueness level (0-255, 0 is clear).");
        list.put("opaque", interString);
        interString = this.i18n.get(RpfLayer.class, "opaque", "Opaqueness");
        list.put("opaque.label", interString);
        interString = this.i18n.get(RpfLayer.class, "numberColors", 3, "Number of colors to use for the map images.");
        list.put("numberColors", interString);
        list.put("numberColors.editor", "com.bbn.openmap.util.propertyEditor.ComboBoxPropertyEditor");
        list.put("numberColors.options", "sixteen  thirtytwo twosixteen");
        list.put("numberColors.sixteen", "16");
        list.put("numberColors.thirtytwo", "32");
        list.put("numberColors.twosixteen", "216");
        interString = this.i18n.get(RpfLayer.class, "numberColors", "Number of Colors");
        list.put("numberColors.label", interString);
        interString = this.i18n.get(RpfLayer.class, "showMaps", 3, "Flag to display map images.");
        list.put("showMaps", interString);
        list.put("showMaps.editor", "com.bbn.openmap.util.propertyEditor.OnOffPropertyEditor");
        interString = this.i18n.get(RpfLayer.class, "showMaps", "Display Images");
        list.put("showMaps.label", interString);
        interString = this.i18n.get(RpfLayer.class, "showInfo", 3, "Flag to show data attributes.");
        list.put("showInfo", interString);
        list.put("showInfo.editor", "com.bbn.openmap.util.propertyEditor.OnOffPropertyEditor");
        interString = this.i18n.get(RpfLayer.class, "showInfo", "Display Attributes");
        list.put("showInfo.label", interString);
        interString = this.i18n.get(RpfLayer.class, "scaleImages", 3, "Flag to scale the images to fit the map scale.  If false, images appear when map scale fits the chart scale.");
        list.put("scaleImages", interString);
        list.put("scaleImages.editor", "com.bbn.openmap.util.propertyEditor.OnOffPropertyEditor");
        interString = this.i18n.get(RpfLayer.class, "scaleImages", "Scale Images");
        list.put("scaleImages.label", interString);
        interString = this.i18n.get(RpfLayer.class, "scaleOverCoverage", 3, "Flag to consider matching map scale over percent coverage, when choosing which maps to display.");
        list.put("scaleOverCoverage", interString);
        list.put("scaleOverCoverage.editor", "com.bbn.openmap.util.propertyEditor.OnOffPropertyEditor");
        interString = this.i18n.get(RpfLayer.class, "scaleOverCoverage", "Scale Images");
        list.put("scaleOverCoverage.label", interString);
        interString = this.i18n.get(RpfLayer.class, "chartSeries", 3, "The two-letter chart code to display.  ANY is default.");
        list.put("chartSeries", interString);
        interString = this.i18n.get(RpfLayer.class, "chartSeries", "Chart Series Code");
        list.put("chartSeries.label", interString);
        interString = this.i18n.get(RpfLayer.class, "autofetchAttributes", 3, "Flag to tell the layer to automatically fetch the attribute data for the images.");
        list.put("autofetchAttributes", interString);
        list.put("autofetchAttributes.editor", "com.bbn.openmap.util.propertyEditor.OnOffPropertyEditor");
        interString = this.i18n.get(RpfLayer.class, "autofetchAttributes", "Auto-fetch Attributes");
        list.put("autofetchAttributes.label", interString);
        interString = this.i18n.get(RpfLayer.class, "imageScaleFactor", 3, "Multiplier to limit the scale differential that a given chart will be displayed for a map (4.0 is the default).");
        list.put("imageScaleFactor", interString);
        interString = this.i18n.get(RpfLayer.class, "imageScaleFactor", "Image Scaling Factor");
        list.put("imageScaleFactor.label", interString);
        interString = this.i18n.get(RpfLayer.class, "colormodel", 3, "If 'indexed', the images will be built using a colortable.  This is not the default.");
        list.put("colormodel", interString);
        list.put("colormodel.editor", "com.bbn.openmap.util.propertyEditor.ComboBoxPropertyEditor");
        list.put("colormodel.options", "dir ind");
        list.put("colormodel.dir", COLORMODEL_DIRECT_STRING);
        list.put("colormodel.ind", COLORMODEL_INDEXED_STRING);
        interString = this.i18n.get(RpfLayer.class, "colormodel", "Image Colormodel Type");
        list.put("colormodel.label", interString);
        return list;
    }

    public String getInitPropertiesOrder() {
        return " showMaps showInfo scaleImages imageScaleFactor opaque numberColors chartSeries autofetchAttributes colormodel";
    }

    public void setPropertyPrefix(String prefix) {
        this.propertyPrefix = prefix;
    }

    public String getPropertyPrefix() {
        return this.propertyPrefix;
    }
}

