/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.policy;

import com.bbn.openmap.layer.OMGraphicHandlerLayer;
import com.bbn.openmap.layer.policy.RenderingHintsRenderPolicy;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMScalingRaster;
import com.bbn.openmap.proj.Cylindrical;
import com.bbn.openmap.proj.Projection;
import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.logging.Level;

public class BufferedImageRenderPolicy
extends RenderingHintsRenderPolicy {
    protected final ImageBuffer imageBuffer = new ImageBuffer();

    public BufferedImageRenderPolicy() {
    }

    public BufferedImageRenderPolicy(OMGraphicHandlerLayer layer) {
        super(layer);
    }

    protected ImageBuffer getImageBuffer() {
        return this.imageBuffer;
    }

    public void prePrepare(Projection newProj) {
        this.getImageBuffer().generate(newProj);
    }

    public OMGraphicList prepare() {
        if (this.layer != null) {
            Projection proj = this.layer.getProjection();
            OMGraphicList list = this.layer.prepare();
            try {
                this.getImageBuffer().update(list, proj);
            }
            catch (NullPointerException npe) {
                logger.fine("Caught NPE creating the image buffer for layer: " + this.layer.getName());
                if (logger.isLoggable(Level.FINE)) {
                    npe.printStackTrace();
                }
                this.getImageBuffer().clear();
            }
            return list;
        }
        logger.warning("NULL layer, can't do anything.");
        return null;
    }

    public void paint(Graphics g) {
        if (this.layer == null) {
            logger.warning("NULL layer, skipping...");
            return;
        }
        Projection proj = this.layer.getProjection();
        if (this.layer.isProjectionOK(proj)) {
            OMGraphicList list;
            Graphics2D g2 = (Graphics2D)g.create();
            ImageBuffer imageBuffer = this.getImageBuffer();
            this.setCompositeOnGraphics(g2);
            if (!imageBuffer.paint(g2, proj) && (list = this.layer.getList()) != null) {
                this.layer.getList().render(g2);
            }
            g2.dispose();
        } else if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.layer.getName() + ".paint(): skipping due to projection.");
        }
    }

    protected class ImageBuffer {
        BufferedImage imageBuffer;
        OMScalingRaster imageRaster;
        Projection currentProjection;

        protected ImageBuffer() {
        }

        protected void generate(Projection proj) {
            OMScalingRaster lImageRaster = this.getImageRaster();
            if (lImageRaster != null) {
                if (proj instanceof Cylindrical) {
                    lImageRaster.setNeedToReposition(true);
                    lImageRaster.setNeedToRegenerate(true);
                    lImageRaster.generate(proj);
                } else {
                    this.setImageRaster(null);
                }
            }
        }

        public boolean paint(Graphics2D g, Projection proj) {
            Projection currentProj = this.currentProjection;
            OMScalingRaster omr = this.getImageRaster();
            if (!proj.equals(currentProj)) {
                this.currentProjection = proj;
                if (omr != null) {
                    omr.generate(proj);
                    omr.render(g);
                    return true;
                }
            }
            return false;
        }

        protected void update(OMGraphicList list, Projection proj) {
            BufferedImage currentImageBuffer = null;
            if (proj != null && BufferedImageRenderPolicy.this.layer != null) {
                int w = proj.getWidth();
                int h = proj.getHeight();
                currentImageBuffer = this.getImageBuffer();
                BufferedImage bufferedImage = this.scrubOrGetNewBufferedImage(currentImageBuffer, w, h);
                if (bufferedImage != null) {
                    if (currentImageBuffer != null) {
                        currentImageBuffer.flush();
                    }
                    currentImageBuffer = bufferedImage;
                }
                Graphics2D g2d = (Graphics2D)currentImageBuffer.getGraphics();
                BufferedImageRenderPolicy.this.setRenderingHints(g2d);
                if (list != null) {
                    list.render(g2d);
                }
                g2d.dispose();
                this.setImageRaster(this.updateRaster(currentImageBuffer, proj));
            }
            this.setImageBuffer(currentImageBuffer);
            this.currentProjection = proj;
        }

        protected OMScalingRaster updateRaster(BufferedImage imageBuffer, Projection proj) {
            if (proj instanceof Cylindrical) {
                int w = proj.getWidth();
                int h = proj.getHeight();
                if (imageBuffer == null) {
                    return null;
                }
                Object llp1 = proj.getUpperLeft();
                Object llp2 = proj.inverse(w, h);
                Point2D pnt1 = proj.forward((Point2D)llp1);
                Point2D pnt2 = proj.forward((Point2D)llp2);
                if (pnt1.getX() < pnt2.getX() && h > 0 && w > 0) {
                    OMScalingRaster raster = this.getImageRaster();
                    if (raster == null) {
                        raster = new OMScalingRaster(((Point2D)llp1).getY(), ((Point2D)llp1).getX(), ((Point2D)llp2).getY(), ((Point2D)llp2).getX(), (Image)imageBuffer);
                    } else {
                        raster.setImage(imageBuffer);
                        raster.setLat(((Point2D)llp1).getY());
                        raster.setLon(((Point2D)llp1).getX());
                        raster.setLRLat(((Point2D)llp2).getY());
                        raster.setLRLon(((Point2D)llp2).getX());
                    }
                    raster.generate(proj);
                    return raster;
                }
            }
            return null;
        }

        protected BufferedImage scrubOrGetNewBufferedImage(BufferedImage currentImage, int width, int height) {
            int cWidth = -1;
            int cHeight = -1;
            if (currentImage != null) {
                cWidth = currentImage.getWidth();
                cHeight = currentImage.getHeight();
            }
            if (currentImage != null && cWidth == width && cHeight == height) {
                Graphics2D graphics = (Graphics2D)currentImage.getGraphics();
                graphics.setComposite(AlphaComposite.Clear);
                graphics.fillRect(0, 0, width, height);
                graphics.setComposite(AlphaComposite.SrcOver);
                return null;
            }
            return new BufferedImage(width, height, 2);
        }

        protected void clear() {
            BufferedImage bImage = this.getImageBuffer();
            if (bImage != null) {
                Graphics2D graphics = (Graphics2D)bImage.getGraphics();
                graphics.setComposite(AlphaComposite.Clear);
                graphics.fillRect(0, 0, bImage.getWidth(), bImage.getHeight());
                graphics.setComposite(AlphaComposite.SrcOver);
            }
            this.setImageRaster(null);
        }

        protected BufferedImage getImageBuffer() {
            return this.imageBuffer;
        }

        protected void setImageBuffer(BufferedImage bImage) {
            if (this.imageBuffer != null && this.imageBuffer != bImage) {
                this.imageBuffer.flush();
            }
            this.imageBuffer = bImage;
        }

        protected OMScalingRaster getImageRaster() {
            return this.imageRaster;
        }

        protected void setImageRaster(OMScalingRaster imageRaster) {
            this.imageRaster = imageRaster;
        }
    }
}

