/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.gui.dock;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalButtonUI;

public class TransparentButtonUI
extends MetalButtonUI {
    private static final TransparentButtonUI transButtonUI = new TransparentButtonUI();
    private static final int VshadowSize = 4;
    private static final int HshadowSize = 2;
    private static final int VpressOffset = 3;
    private static final int HpressOffset = 1;
    Color darkShadow = new Color(0, 0, 0, 200);
    Color mediumShadow = new Color(0, 0, 0, 125);
    Color lightShadow = new Color(0, 0, 0, 50);

    public static ComponentUI createUI(JComponent c) {
        return transButtonUI;
    }

    public void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        b.setBorder(BorderFactory.createEmptyBorder(0, 0, 4, 2));
        b.setFocusPainted(false);
    }

    public Color getBGColor(AbstractButton c) {
        Color bg = c.getBackground();
        return new Color(bg.getRed(), bg.getGreen(), bg.getBlue(), 200);
    }

    public Color getSelectedBGColor(AbstractButton c) {
        return new Color(225, 225, 125, 200);
    }

    public Color getDarkShadow() {
        return this.darkShadow;
    }

    public Color getMediumShadow() {
        return this.mediumShadow;
    }

    public Color getLightShadow() {
        return this.lightShadow;
    }

    public void paint(Graphics g, JComponent c) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        Dimension size = b.getSize();
        if (model.isArmed() && model.isPressed() || model.isSelected()) {
            g = g.create(1, 3, size.width, size.height);
            Dimension sSize = new Dimension(size.width - 1, size.height - 3);
            this.drawShadow(g, sSize, 1, 1);
        } else {
            this.drawShadow(g, size, 4, 2);
        }
        if (model.isArmed() && model.isPressed() || model.isSelected()) {
            g.setColor(this.getSelectedBGColor(b));
        } else {
            g.setColor(this.getBGColor(b));
        }
        g.fillRect(0, 0, size.width - 2, size.height - 4);
        super.paint(g, c);
    }

    private void drawShadow(Graphics g, Dimension size, int vShadowSize, int hShadowSize) {
        this.drawHArea(g, size, this.getDarkShadow(), vShadowSize, hShadowSize, 0, vShadowSize / 3);
        this.drawHArea(g, size, this.getMediumShadow(), vShadowSize, hShadowSize, vShadowSize / 3, vShadowSize * 2 / 3);
        this.drawHArea(g, size, this.getLightShadow(), vShadowSize, hShadowSize, vShadowSize * 2 / 3, vShadowSize);
        int last = 0;
        int next = hShadowSize / 3;
        if (hShadowSize % 3 == 2) {
            ++next;
        }
        this.drawVArea(g, size, this.getDarkShadow(), vShadowSize, hShadowSize, last, next);
        last = next;
        if (hShadowSize * 2 / 3 > last) {
            next = hShadowSize * 2 / 3;
            this.drawVArea(g, size, this.getMediumShadow(), vShadowSize, hShadowSize, last, next);
        }
        if (hShadowSize > (last = next)) {
            next = hShadowSize;
            this.drawVArea(g, size, this.getLightShadow(), vShadowSize, hShadowSize, last, next);
        }
    }

    private void drawHArea(Graphics g, Dimension size, Color c, int vShadowSize, int hShadowSize, int low, int high) {
        g.setColor(c);
        for (int i = low; i < high; ++i) {
            this.drawHLine(g, size, vShadowSize, hShadowSize, i);
        }
    }

    private void drawHLine(Graphics g, Dimension size, int vShadowSize, int hShadowSize, int i) {
        g.drawLine(i * hShadowSize / vShadowSize, size.height - vShadowSize + i, size.width - hShadowSize + i * hShadowSize / vShadowSize, size.height - vShadowSize + i);
    }

    private void drawVArea(Graphics g, Dimension size, Color c, int vShadowSize, int hShadowSize, int low, int high) {
        g.setColor(c);
        for (int i = low; i < high; ++i) {
            this.drawVLine(g, size, vShadowSize, hShadowSize, i);
        }
    }

    private void drawVLine(Graphics g, Dimension size, int vShadowSize, int hShadowSize, int i) {
        g.drawLine(size.width - hShadowSize + i, i * vShadowSize / hShadowSize, size.width - hShadowSize + i, size.height - vShadowSize + i * vShadowSize / hShadowSize - 1);
    }

    protected void paintButtonPressed(Graphics g, AbstractButton b) {
    }
}

