/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap;

import com.bbn.openmap.Layer;
import com.bbn.openmap.OMComponent;
import com.bbn.openmap.PropertyHandler;
import com.bbn.openmap.SoloMapComponent;
import com.bbn.openmap.event.LayerConfigurationListener;
import com.bbn.openmap.event.LayerConfigurationListenerSupport;
import com.bbn.openmap.event.LayerEvent;
import com.bbn.openmap.event.LayerListener;
import com.bbn.openmap.event.LayerSupport;
import com.bbn.openmap.plugin.PlugIn;
import com.bbn.openmap.plugin.PlugInLayer;
import com.bbn.openmap.util.ComponentFactory;
import com.bbn.openmap.util.HandleError;
import com.bbn.openmap.util.PropUtils;
import java.awt.Component;
import java.beans.PropertyVetoException;
import java.beans.beancontext.BeanContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayerHandler
extends OMComponent
implements SoloMapComponent,
Serializable {
    public static Logger logger = Logger.getLogger("com.bbn.openmap.LayerHandler");
    public static final String layersProperty = "layers";
    public static final String startUpLayersProperty = "startUpLayers";
    public static final String SynchronousThreadingProperty = "synchronousThreading";
    protected transient LayerSupport listeners = new LayerSupport(this);
    protected transient LayerConfigurationListenerSupport layerConfigListeners = new LayerConfigurationListenerSupport(this);
    protected List<Layer> allLayers = new ArrayList<Layer>();
    protected PropertyHandler propertyHandler;

    public LayerHandler() {
    }

    public LayerHandler(Properties props) {
        this.init(null, props);
    }

    public LayerHandler(String prefix, Properties props) {
        this.init(prefix, props);
    }

    public LayerHandler(Layer[] layers) {
        this.init(layers);
    }

    @Override
    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
        this.init(prefix, props);
    }

    public void init(String prefix, Properties props) {
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.init(this.getLayers(prefix, props));
        this.getListeners().setSynchronous(PropUtils.booleanFromProperties(props, prefix + SynchronousThreadingProperty, this.getListeners().isSynchronous()));
    }

    public void init(URL url) {
        this.init(null, url);
    }

    public void init(String prefix, URL url) {
        try {
            InputStream in = url.openStream();
            Properties props = new Properties();
            props.load(in);
            this.init(this.getLayers(prefix, props));
        }
        catch (MalformedURLException murle) {
            logger.warning("LayerHandler.init(URL): " + url + " is not a valid URL");
        }
        catch (IOException e) {
            logger.warning("LayerHandler.init(URL): Caught an IOException");
        }
    }

    public void init(Layer[] layers) {
        this.init(Arrays.asList(layers));
    }

    public void init(List<Layer> layers) {
        this.removeAll();
        List<Layer> currentLayers = this.getLayerList();
        if (layers == null) {
            layers = new ArrayList<Layer>();
        }
        for (Layer layer : currentLayers) {
            if (layers.contains(layer)) continue;
            layers.add(layer);
        }
        this.setLayerList(layers);
        this.addLayersToBeanContext(layers);
    }

    public void setPropertyHandler(PropertyHandler ph) {
        this.propertyHandler = ph;
    }

    public PropertyHandler getPropertyHandler() {
        return this.propertyHandler;
    }

    protected Layer[] getLayers(Properties p) {
        return this.getLayers(null, p);
    }

    protected Layer[] getLayers(String prefix, Properties p) {
        logger.fine("Getting new layers from properties...");
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        String layersValueString = p.getProperty(prefix + layersProperty);
        String startupLayersValueString = p.getProperty(prefix + startUpLayersProperty);
        if (layersValueString == null) {
            layersValueString = p.getProperty(PropUtils.getScopedPropertyPrefix("openmap") + layersProperty);
        }
        if (startupLayersValueString == null) {
            startupLayersValueString = p.getProperty(PropUtils.getScopedPropertyPrefix("openmap") + startUpLayersProperty);
        }
        Vector<String> startuplayers = PropUtils.parseSpacedMarkers(startupLayersValueString);
        Vector<String> layersValue = PropUtils.parseSpacedMarkers(layersValueString);
        if (startuplayers.isEmpty()) {
            logger.info("No layers on startup list");
        }
        if (layersValue.isEmpty()) {
            logger.info("No property \"layers\" found in properties.");
            return new Layer[0];
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Layer markers found = " + layersValue);
        }
        Layer[] layers = LayerHandler.getLayers(layersValue, startuplayers, p);
        return layers;
    }

    public static Layer[] getLayers(Vector<String> layerList, Vector<String> visibleLayerList, Properties p) {
        int nLayerNames = layerList.size();
        Vector<Layer> layers = new Vector<Layer>(nLayerNames);
        for (String layerName : layerList) {
            Layer l;
            String classProperty = layerName + ".class";
            String className = p.getProperty(classProperty);
            if (className == null) {
                logger.info("Failed to locate property \"" + classProperty + "\"\n  Skipping layer \"" + layerName + "\"");
                continue;
            }
            Object obj = ComponentFactory.create(className, layerName, p);
            if (obj instanceof Layer) {
                l = (Layer)obj;
            } else if (obj instanceof PlugIn) {
                PlugInLayer pl = new PlugInLayer();
                pl.setProperties(layerName, p);
                pl.setPlugIn((PlugIn)obj);
                l = pl;
            } else {
                logger.info("Skipped \"" + layerName + "\" " + (obj == null ? " - unable to create " : ", type " + obj.getClass().getName() + " is not a layer or plugin"));
                continue;
            }
            l.setVisible(visibleLayerList.contains(layerName));
            layers.addElement(l);
            if (!logger.isLoggable(Level.FINE)) continue;
            logger.fine("layer " + l.getName() + (l.isVisible() ? " is visible" : " is not visible"));
        }
        int nLayers = layers.size();
        if (nLayers == 0) {
            return new Layer[0];
        }
        Object[] value = new Layer[nLayers];
        layers.copyInto(value);
        return value;
    }

    public void addLayerListener(LayerListener ll) {
        logger.fine("adding layer listener");
        this.listeners.add(ll);
        ll.setLayers(new LayerEvent(this, 403, this.getLayers()));
        ll.setLayers(new LayerEvent(this, 400, this.getMapLayers()));
    }

    public void addLayerConfigurationListener(LayerConfigurationListener lcl) {
        this.layerConfigListeners.add(lcl);
    }

    public void removeLayerListener(LayerListener ll) {
        if (this.listeners != null) {
            this.listeners.remove(ll);
        }
    }

    public void removeLayerConfigurationListener(LayerConfigurationListener lcl) {
        this.layerConfigListeners.remove(lcl);
    }

    public synchronized void setLayers(Layer[] layers) {
        this.setLayerList(Arrays.asList(layers));
    }

    public synchronized void setLayerList(List<Layer> layers) {
        List<Layer> checkedList;
        this.allLayers = this.organizeBackgroundLayers(layers);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("setting layers: " + this.getLayerNamesFromArray(layers));
        }
        if ((checkedList = this.layerConfigListeners.checkLayerConfiguration(this.getLayerList())) != null) {
            this.allLayers = this.organizeBackgroundLayers(checkedList);
        }
        this.getListeners().pushLayerEvent(403, this.getLayers());
        this.getListeners().pushLayerEvent(402, this.getMapLayers());
    }

    protected String getLayerNamesFromArray(List<Layer> lArray) {
        StringBuilder buf = new StringBuilder();
        if (lArray != null) {
            for (Layer l : lArray) {
                if (buf.length() > 0) {
                    buf.append(" ");
                }
                buf.append(l.getName());
            }
        }
        return buf.toString();
    }

    protected boolean isForegroundUnderBackgroundLayer(List<Layer> layers) {
        boolean foundBackgroundLayer = false;
        for (Layer layer : layers) {
            if (layer == null) continue;
            if (layer.getAddAsBackground()) {
                foundBackgroundLayer = true;
                continue;
            }
            if (!foundBackgroundLayer) continue;
            return true;
        }
        return false;
    }

    protected List<Layer> organizeBackgroundLayers(List<Layer> layers) {
        if (this.isForegroundUnderBackgroundLayer(layers)) {
            ArrayList<Layer> fLayers = new ArrayList<Layer>(layers.size());
            ArrayList<Layer> bLayers = new ArrayList<Layer>(layers.size());
            for (Layer layer : layers) {
                if (layer == null) continue;
                if (layer.getAddAsBackground()) {
                    bLayers.add(layer);
                    continue;
                }
                fLayers.add(layer);
            }
            fLayers.addAll(bLayers);
            return fLayers;
        }
        return layers;
    }

    protected LayerSupport getListeners() {
        return this.listeners;
    }

    public void setLayers() {
        this.setLayerList(this.getLayerList());
    }

    public synchronized Layer[] getLayers() {
        List<Layer> layers = this.getLayerList();
        return layers.toArray(new Layer[layers.size()]);
    }

    public synchronized List<Layer> getLayerList() {
        if (this.allLayers == null) {
            return new ArrayList<Layer>();
        }
        return new ArrayList<Layer>(this.allLayers);
    }

    public Layer[] getMapLayers() {
        ArrayList<Layer> activeLayers = new ArrayList<Layer>();
        for (Layer layer : this.getLayers()) {
            if (layer == null || !layer.isVisible()) continue;
            activeLayers.add(layer);
        }
        Layer[] cake = activeLayers.toArray(new Layer[activeLayers.size()]);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("providing map layers: " + this.getLayerNamesFromArray(activeLayers));
        }
        return cake;
    }

    public boolean moveLayer(Layer layer, int toPosition) {
        boolean found = this.getLayerList().contains(layer);
        this.addLayer(layer, toPosition);
        return found;
    }

    public void addLayer(Layer layer) {
        if (this.allLayers == null) {
            this.addLayer(layer, 0);
            return;
        }
        if (!this.allLayers.contains(layer)) {
            this.allLayers.add(layer);
        }
    }

    public void addLayer(Layer layer, int position) {
        String pre;
        List<Layer> currentLayers = this.getLayerList();
        currentLayers.remove(layer);
        if (position > this.allLayers.size()) {
            currentLayers.add(layer);
        } else {
            if (position < 0) {
                position = 0;
            }
            currentLayers.add(position, layer);
        }
        if (this.propertyHandler != null && (pre = layer.getPropertyPrefix()) != null && pre.length() > 0) {
            this.propertyHandler.addUsedPrefix(pre);
        }
        this.setLayerList(currentLayers);
        BeanContext bc = this.getBeanContext();
        if (bc != null && layer.getAddToBeanContext() && layer.getBeanContext() == null) {
            bc.add(layer);
        }
    }

    public void removeLayer(Layer layer) {
        if (layer != null && layer.isRemovable()) {
            List<Layer> currentLayers = this.getLayerList();
            currentLayers.remove(layer);
            this.setLayerList(currentLayers);
        } else if (layer != null) {
            logger.warning("received command to remove " + layer.getName() + ", which has been designated as *NOT* removeable");
            throw new HandleError("LayerHandler commanded to delete a layer (" + layer.getName() + ") that is not removeable");
        }
    }

    public void removeLayer(int index) {
        List<Layer> currentLayers = this.getLayerList();
        try {
            currentLayers.remove(index);
            this.setLayerList(currentLayers);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public boolean hasLayer(Layer l) {
        return this.getLayerList().contains(l);
    }

    public void removeAll() {
        List<Layer> oldLayers = this.getLayerList();
        if (this.allLayers == null || this.allLayers.isEmpty()) {
            return;
        }
        BeanContext bc = this.getBeanContext();
        ArrayList<Layer> nonRemoveableLayers = new ArrayList<Layer>();
        for (Layer layer : oldLayers) {
            if (layer == null) continue;
            if (layer.isRemovable()) {
                this.turnLayerOn(false, layer);
                layer.clearListeners();
                if (bc == null) continue;
                bc.remove(layer);
                continue;
            }
            nonRemoveableLayers.add(layer);
        }
        this.setLayerList(nonRemoveableLayers);
        System.gc();
    }

    protected void removeLayer(Layer[] currentLayers, int index) {
        Layer rLayer = currentLayers[index];
        if (!rLayer.isRemovable()) {
            logger.warning("received command to remove " + rLayer.getName() + ", which has been designated as *NOT* removeable");
            return;
        }
        rLayer.setVisible(false);
        Layer[] newLayers = new Layer[currentLayers.length - 1];
        System.arraycopy(currentLayers, 0, newLayers, 0, index);
        System.arraycopy(currentLayers, index + 1, newLayers, index, currentLayers.length - index - 1);
        BeanContext bc = this.getBeanContext();
        if (bc != null) {
            bc.remove(rLayer);
        }
        this.turnLayerOn(false, rLayer);
        rLayer.clearListeners();
        rLayer = null;
        this.setLayers(newLayers);
    }

    public boolean turnLayerOn(boolean setting, int index) {
        try {
            return this.turnLayerOn(setting, this.getLayerList().get(index));
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return false;
    }

    public boolean turnLayerOn(boolean setting, Layer layer) {
        if (setting && !layer.isVisible() || !setting && layer.isVisible()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("turning " + layer.getName() + (setting ? " on" : " off"));
            }
            layer.setVisible(setting);
            List<Layer> newList = this.layerConfigListeners.checkLayerConfiguration(this.getLayerList());
            if (newList != null) {
                this.allLayers = this.organizeBackgroundLayers(newList);
            }
            this.getListeners().pushLayerEvent(402, this.getMapLayers());
            return true;
        }
        return false;
    }

    @Override
    public void findAndInit(Object someObj) {
        PlugIn pi;
        if (someObj instanceof LayerListener) {
            logger.fine("LayerHandler found a LayerListener.");
            this.addLayerListener((LayerListener)someObj);
        }
        if (someObj instanceof LayerConfigurationListener) {
            logger.fine("LayerHandler found a LayerConfigurationListener.");
            this.addLayerConfigurationListener((LayerConfigurationListener)someObj);
        }
        if (someObj instanceof Layer) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("LayerHandler found a Layer |" + ((Layer)someObj).getName() + "|" + someObj.getClass().getName());
            }
            if (!this.hasLayer((Layer)someObj)) {
                this.addLayer((Layer)someObj, 0);
            }
        }
        if (someObj instanceof PlugIn && (pi = (PlugIn)someObj).getComponent() == null) {
            PlugInLayer pil = new PlugInLayer();
            pil.setPlugIn(pi);
            this.addLayer(pil, 0);
        }
        if (someObj instanceof PropertyHandler) {
            this.setPropertyHandler((PropertyHandler)someObj);
        }
    }

    @Override
    public void findAndUndo(Object someObj) {
        PlugIn pi;
        Component comp;
        if (someObj instanceof LayerListener) {
            logger.fine("LayerListener object is being removed");
            this.removeLayerListener((LayerListener)someObj);
        }
        if (someObj instanceof LayerConfigurationListener) {
            logger.fine("LayerConfigurationListener is being removed.");
            this.removeLayerConfigurationListener((LayerConfigurationListener)someObj);
        }
        if (someObj instanceof Layer) {
            this.removeLayer((Layer)someObj);
        }
        if (someObj instanceof PlugIn && (comp = (pi = (PlugIn)someObj).getComponent()) instanceof Layer && this.hasLayer((Layer)comp)) {
            this.removeLayer((Layer)comp);
        }
        if (someObj instanceof PropertyHandler && someObj == this.getPropertyHandler()) {
            this.setPropertyHandler(null);
        }
    }

    public void addLayersToBeanContext(List<Layer> layers) {
        BeanContext bc = this.getBeanContext();
        if (bc == null || layers == null) {
            return;
        }
        for (Layer layer : layers) {
            if (!layer.getAddToBeanContext() || layer.getBeanContext() != null) continue;
            bc.add(layer);
        }
    }

    public void removeLayersFromBeanContext(List<Layer> layers) {
        BeanContext bc = this.getBeanContext();
        if (bc == null || layers == null) {
            return;
        }
        for (Layer layer : layers) {
            bc.remove(layer);
        }
    }

    @Override
    public void setBeanContext(BeanContext in_bc) throws PropertyVetoException {
        if (in_bc != null) {
            logger.fine("setting bean context");
            in_bc.addBeanContextMembershipListener(this);
            this.beanContextChildSupport.setBeanContext(in_bc);
            this.addLayersToBeanContext(this.getLayerList());
            this.findAndInit(in_bc.iterator());
        }
    }

    public void setSynchronousThreading(boolean s) {
        this.getListeners().setSynchronous(s);
    }

    public boolean isSynchronousThreading() {
        return this.getListeners().isSynchronous();
    }

    @Override
    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        props.put(PropUtils.getScopedPropertyPrefix(this) + SynchronousThreadingProperty, Boolean.toString(this.getListeners().isSynchronous()));
        return props;
    }

    @Override
    public Properties getPropertyInfo(Properties props) {
        props = super.getPropertyInfo(props);
        String internString = this.i18n.get(LayerHandler.class, SynchronousThreadingProperty, 3, "Launch new threads to do work.");
        props.put(SynchronousThreadingProperty, internString);
        internString = this.i18n.get(LayerHandler.class, SynchronousThreadingProperty, "Synchronous Threading");
        props.put("synchronousThreading.label", internString);
        props.put("synchronousThreadingeditor", "com.bbn.openmap.util.propertyEditor.YesNoPropertyEditor");
        return props;
    }
}

