/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.proj;

import com.bbn.openmap.proj.Ellipsoid;
import com.bbn.openmap.proj.GeoProj;
import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.proj.coords.UTMGCT;
import com.bbn.openmap.proj.coords.UTMPoint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UTMProjection
extends GeoProj {
    protected Point2D.Double xycenter = new Point2D.Double();
    protected double hy;
    protected double wx;
    protected double ppu;
    protected Point world;
    protected int half_world;
    protected int zoneNumber;
    protected boolean northern;
    protected Ellipsoid ellps;
    protected static double epsilon = 0.01f;

    public UTMProjection(LatLonPoint center, float s, int w, int h, int zone_number, boolean isnorthern, Ellipsoid ellps) {
        super(center, s, w, h);
        this.zoneNumber = zone_number;
        this.northern = isnorthern;
        this.ellps = ellps;
    }

    @Override
    protected void computeParameters() {
        this.hy = this.height / 2;
        this.wx = this.width / 2;
        if (this.xycenter != null) {
            UTMPoint c = UTMPoint.LLtoUTM(this.getCenter(), this.ellps, new UTMPoint(), this.zoneNumber, this.northern);
            this.xycenter.setLocation(c.easting, c.northing);
        }
        if (this.world == null) {
            this.world = new Point();
        }
        this.world.x = (int)(this.planetPixelCircumference / this.scale);
        this.half_world = this.world.x / 2;
        this.ppu = (float)this.pixelsPerMeter / this.getScale();
    }

    public Point2D forward(LatLonPoint llp, Point2D pt) {
        return this.forward(llp, pt, new UTMPoint());
    }

    @Override
    public Point2D forward(double lat, double lon, Point2D pt, boolean isRadian) {
        LatLonPoint.Double llp = new LatLonPoint.Double(lat, lon, isRadian);
        return this.forward(llp, pt, new UTMPoint());
    }

    public Point2D forward(double lat, double lon, Point2D pt, boolean isRadian, UTMPoint utmPoint) {
        LatLonPoint.Double llp = new LatLonPoint.Double(lat, lon, isRadian);
        return this.forward(llp, pt, utmPoint);
    }

    private Point2D forward(LatLonPoint llp, Point2D pt, UTMPoint utmPoint) {
        utmPoint = UTMPoint.LLtoUTM(llp, this.ellps, utmPoint, this.zoneNumber, this.northern);
        pt.setLocation(this.wx + this.ppu * (utmPoint.easting - this.xycenter.getX()), this.hy - this.ppu * (utmPoint.northing - this.xycenter.getY()));
        return pt;
    }

    @Override
    public <T extends Point2D> T inverse(double x, double y, T llpt) {
        double northing = this.xycenter.getY() + (this.hy - y) / this.ppu;
        double easting = this.xycenter.getX() + (x - this.wx) / this.ppu;
        if (!(llpt instanceof LatLonPoint)) {
            llpt = new LatLonPoint.Double();
        }
        llpt = UTMPoint.UTMtoLL(this.ellps, northing, easting, this.zoneNumber, this.northern, (LatLonPoint)llpt);
        return llpt;
    }

    @Override
    public float getScale(Point2D ll1, Point2D ll2, Point2D point1, Point2D point2) {
        double widthPX = point2.getX() - point1.getX();
        UTMPoint xx1 = UTMPoint.LLtoUTM((LatLonPoint)ll1, this.ellps, new UTMPoint(), this.zoneNumber, this.northern);
        UTMPoint xx2 = UTMPoint.LLtoUTM((LatLonPoint)ll2, this.ellps, new UTMPoint(), this.zoneNumber, this.northern);
        double widthMap = xx2.easting - xx1.easting;
        float widthScale = (float)(this.getPPM() * (widthMap / widthPX));
        return widthScale;
    }

    @Override
    protected ArrayList<float[]> _forwardPoly(float[] rawllpts, int ltype, int nsegs, boolean isFilled) {
        int j;
        int i;
        int flag = 0;
        int min = 0;
        int max = 0;
        int xadj = 0;
        int len = rawllpts.length >> 1;
        if (len < 2) {
            return new ArrayList<float[]>(0);
        }
        if (this.isComplicatedLineType(ltype)) {
            return this.doPolyDispatch(rawllpts, ltype, nsegs, isFilled);
        }
        Point temp = new Point(0, 0);
        float[] xs = new float[len];
        float[] ys = new float[len];
        UTMPoint tempUtm = new UTMPoint();
        LatLonPoint.Double tempLL = new LatLonPoint.Double();
        ((LatLonPoint)tempLL).setLatLon(rawllpts[0], rawllpts[1], true);
        this.forward(tempLL, temp, tempUtm);
        int xp = temp.x;
        xs[0] = temp.x;
        ys[0] = temp.y;
        int n = 1;
        int k = 2;
        while (n < len) {
            ((LatLonPoint)tempLL).setLatLon(rawllpts[k], rawllpts[k + 1], true);
            this.forward(tempLL, temp, tempUtm);
            xs[n] = temp.x;
            ys[n] = temp.y;
            if (Math.abs((float)xp - xs[n]) >= (float)this.half_world) {
                min = (flag += (float)xp < xs[n] ? -1 : 1) < min ? flag : min;
                max = flag > max ? flag : max;
                xadj = flag * this.world.x;
            }
            xp = temp.x;
            if (flag != 0) {
                int n2 = n;
                xs[n2] = xs[n2] + (float)xadj;
            }
            ++n;
            k += 2;
        }
        ArrayList<float[]> ret_val = null;
        ret_val = new ArrayList<float[]>(2 + 2 * (max + (min *= -1)));
        ret_val.add(xs);
        ret_val.add(ys);
        float[] altx = null;
        for (i = 1; i <= min; ++i) {
            altx = new float[xs.length];
            xadj = i * this.world.x;
            for (j = 0; j < altx.length; ++j) {
                altx[j] = xs[j] + (float)xadj;
            }
            ret_val.add(altx);
            ret_val.add(ys);
        }
        for (i = 1; i <= max; ++i) {
            altx = new float[xs.length];
            xadj = -i * this.world.x;
            for (j = 0; j < altx.length; ++j) {
                altx[j] = xs[j] + (float)xadj;
            }
            ret_val.add(altx);
            ret_val.add(ys);
        }
        return ret_val;
    }

    @Override
    protected ArrayList<float[]> _forwardPoly(double[] rawllpts, int ltype, int nsegs, boolean isFilled) {
        int j;
        int i;
        int flag = 0;
        int min = 0;
        int max = 0;
        int xadj = 0;
        int len = rawllpts.length >> 1;
        if (len < 2) {
            return new ArrayList<float[]>(0);
        }
        if (this.isComplicatedLineType(ltype)) {
            return this.doPolyDispatch(rawllpts, ltype, nsegs, isFilled);
        }
        Point temp = new Point(0, 0);
        float[] xs = new float[len];
        float[] ys = new float[len];
        UTMPoint tempUtm = new UTMPoint();
        LatLonPoint.Double tempLL = new LatLonPoint.Double();
        ((LatLonPoint)tempLL).setLatLon(rawllpts[0], rawllpts[1], true);
        this.forward(tempLL, temp, tempUtm);
        int xp = temp.x;
        xs[0] = temp.x;
        ys[0] = temp.y;
        int n = 1;
        int k = 2;
        while (n < len) {
            ((LatLonPoint)tempLL).setLatLon(rawllpts[k], rawllpts[k + 1], true);
            this.forward(tempLL, temp, tempUtm);
            xs[n] = temp.x;
            ys[n] = temp.y;
            if (Math.abs((float)xp - xs[n]) >= (float)this.half_world) {
                min = (flag += (float)xp < xs[n] ? -1 : 1) < min ? flag : min;
                max = flag > max ? flag : max;
                xadj = flag * this.world.x;
            }
            xp = temp.x;
            if (flag != 0) {
                int n2 = n;
                xs[n2] = xs[n2] + (float)xadj;
            }
            ++n;
            k += 2;
        }
        ArrayList<float[]> ret_val = null;
        ret_val = new ArrayList<float[]>(2 + 2 * (max + (min *= -1)));
        ret_val.add(xs);
        ret_val.add(ys);
        float[] altx = null;
        for (i = 1; i <= min; ++i) {
            altx = new float[xs.length];
            xadj = i * this.world.x;
            for (j = 0; j < altx.length; ++j) {
                altx[j] = xs[j] + (float)xadj;
            }
            ret_val.add(altx);
            ret_val.add(ys);
        }
        for (i = 1; i <= max; ++i) {
            altx = new float[xs.length];
            xadj = -i * this.world.x;
            for (j = 0; j < altx.length; ++j) {
                altx[j] = xs[j] + (float)xadj;
            }
            ret_val.add(altx);
            ret_val.add(ys);
        }
        return ret_val;
    }

    @Override
    public void drawBackground(Graphics2D g, Paint paint) {
        g.setPaint(paint);
        this.drawBackground(g);
    }

    @Override
    public void drawBackground(Graphics g) {
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    public boolean forwardRaw(float[] rawllpts, int rawoff, int[] xcoords, int[] ycoords, boolean[] visible, int copyoff, int copylen) {
        Point temp = new Point();
        UTMPoint tempUtm = new UTMPoint();
        LatLonPoint.Double tempLL = new LatLonPoint.Double();
        int end = copylen + copyoff;
        int i = copyoff;
        int j = rawoff;
        while (i < end) {
            ((LatLonPoint)tempLL).setLatLon(rawllpts[j], rawllpts[j + 1], true);
            this.forward(tempLL, temp, tempUtm);
            xcoords[i] = temp.x;
            ycoords[i] = temp.y;
            visible[i] = true;
            ++i;
            j += 2;
        }
        return true;
    }

    @Override
    public LatLonPoint getLowerRight() {
        return this.inverse(this.width - 1, this.height - 1, new LatLonPoint.Double());
    }

    @Override
    public LatLonPoint getUpperLeft() {
        return this.inverse(0.0, 0.0, new LatLonPoint.Double());
    }

    public int getZoneNumber() {
        return this.zoneNumber;
    }

    public void setZoneNumber(int zoneNumber) {
        this.zoneNumber = zoneNumber;
        this.computeParameters();
    }

    public boolean isNorthern() {
        return this.northern;
    }

    public void setNorthern(boolean northern) {
        this.northern = northern;
        this.computeParameters();
    }

    public Ellipsoid getEllps() {
        return this.ellps;
    }

    public void setEllps(Ellipsoid ellps) {
        this.ellps = ellps;
        this.computeParameters();
    }

    @Override
    public double normalizeLatitude(double lat) {
        if (lat > 1.5707963705062866 - epsilon) {
            return 1.5707963705062866 - epsilon;
        }
        if (lat < -1.5707963705062866 + epsilon) {
            return -1.5707963705062866 + epsilon;
        }
        return lat;
    }

    @Override
    public boolean isPlotable(double lat, double lon) {
        return true;
    }

    public UTMGCT getGCTForProjection() {
        return new UTMGCT(this.getZoneNumber(), this.isNorthern() ? (char)'N' : 'S');
    }
}

