/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.io;

import com.bbn.openmap.io.StreamInputReader;
import com.bbn.openmap.util.Debug;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class JarInputReader
extends StreamInputReader {
    protected URL inputURL = null;
    protected JarFile jarFile = null;
    protected String jarFileName = null;
    protected String jarEntryName = null;

    public JarInputReader(String jarFilePath, String jarEntryName) throws IOException {
        if (Debug.debugging("binaryfile")) {
            Debug.output("JarInputReader created for " + jarEntryName + " in " + jarFilePath);
        }
        this.jarFileName = jarFilePath;
        this.jarEntryName = jarEntryName;
        this.reopen();
        this.name = jarFilePath + "!" + jarEntryName;
    }

    public void reopen() throws IOException {
        super.reopen();
        Debug.message("binaryfile", "JarInputReader: reopening jarFile " + this.jarFileName);
        if (this.jarFile != null) {
            this.jarFile.close();
        }
        this.jarFile = null;
        this.jarFile = new JarFile(URLDecoder.decode(this.jarFileName, "UTF-8"));
        JarEntry entry = this.jarFile.getJarEntry(this.jarEntryName);
        this.inputStream = this.jarFile.getInputStream(entry);
        if (this.inputStream == null) {
            Debug.error("JarInputReader: Problem getting input stream for " + this.jarEntryName + " in " + this.jarFileName);
        }
    }

    public void close() throws IOException {
        this.jarFile.close();
        super.close();
    }
}

