/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.image.wms;

import com.bbn.openmap.Layer;
import com.bbn.openmap.image.wms.DefaultLayerAdapter;
import com.bbn.openmap.image.wms.IWmsLayer;
import com.bbn.openmap.image.wms.WMSException;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class WmsLayerFactory {
    private final Map wmsLayersMap = new HashMap();

    public WmsLayerFactory(Properties props) throws WMSException {
        String wmsLayers = props.getProperty("wms.layers");
        try {
            for (String key : PropUtils.parseSpacedMarkers(wmsLayers)) {
                Class<?> layerClass = Class.forName(props.getProperty(key + ".layerClass"));
                Class<?> clazz = Class.forName(props.getProperty(key + ".class"));
                this.wmsLayersMap.put(layerClass, clazz);
            }
        }
        catch (ClassNotFoundException ex) {
            throw new WMSException("Problem with wmsLayers configuration");
        }
    }

    IWmsLayer createWmsLayer(Layer layer) {
        if (layer instanceof IWmsLayer) {
            return (IWmsLayer)((Object)layer);
        }
        Class<?> layerClass = layer.getClass();
        Class wmsLayerClass = (Class)this.wmsLayersMap.get(layerClass);
        if (wmsLayerClass == null) {
            return new DefaultLayerAdapter(layer);
        }
        IWmsLayer wmsLayer = null;
        try {
            Constructor constructor = wmsLayerClass.getConstructor(Layer.class);
            wmsLayer = (IWmsLayer)constructor.newInstance(layer);
        }
        catch (Exception ex) {
            Debug.message("ms", "Problem calling constructor for class " + wmsLayerClass.getName() + ":" + ex.getMessage());
        }
        if (wmsLayer == null) {
            wmsLayer = new DefaultLayerAdapter(layer);
        }
        return wmsLayer;
    }
}

