/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.image;

import com.bbn.openmap.image.BufferedImageHelper;
import com.bbn.openmap.util.Debug;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileImageOutputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;

public class JPEGHelper {
    private JPEGHelper() {
    }

    public static byte[] encodeJPEG(BufferedImage image, float quality) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        MemoryCacheImageOutputStream iosout = new MemoryCacheImageOutputStream(out);
        if (Debug.debugging("jpeghelper")) {
            Debug.output("Got output stream..." + out);
        }
        Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName("jpeg");
        ImageWriter writer = iter.next();
        ImageWriteParam iwp = writer.getDefaultWriteParam();
        iwp.setCompressionMode(2);
        iwp.setCompressionQuality(quality);
        if (Debug.debugging("jpeghelper")) {
            Debug.output("Got encode params...");
        }
        writer.setOutput(iosout);
        if (Debug.debugging("jpeghelper")) {
            Debug.output("Got jpeg encoder...");
        }
        IIOImage iioi = new IIOImage(image, null, null);
        writer.write(null, iioi, iwp);
        writer.dispose();
        if (Debug.debugging("jpeghelper")) {
            Debug.output("encoded?");
        }
        return out.toByteArray();
    }

    public static byte[] encodeJPEG(int w, int h, int[] pixels, float quality) throws IOException {
        BufferedImage bi = new BufferedImage(w, h, 1);
        bi.setRGB(0, 0, w, h, pixels, 0, w);
        pixels = null;
        return JPEGHelper.encodeJPEG(bi, quality);
    }

    private static void encodeAndWriteJPEGFile(File file, BufferedImage image, float quality) throws IOException {
        Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName("jpeg");
        ImageWriter writer = iter.next();
        ImageWriteParam iwp = writer.getDefaultWriteParam();
        iwp.setCompressionMode(2);
        iwp.setCompressionQuality(quality);
        FileImageOutputStream output = new FileImageOutputStream(file);
        writer.setOutput(output);
        IIOImage iioi = new IIOImage(image, null, null);
        writer.write(null, iioi, iwp);
        writer.dispose();
    }

    public static void main(String[] args) throws Exception {
        String urlsource;
        int lastslash;
        if (args.length == 0) {
            System.out.println("java jpeg url [width height]");
            System.exit(-1);
        }
        Debug.init();
        int uw = -1;
        int uh = -1;
        if (args.length > 1) {
            uw = Integer.parseInt(args[1]);
            uh = Integer.parseInt(args[2]);
        }
        lastslash = (lastslash = (urlsource = args[0]).lastIndexOf(47)) == -1 ? 0 : ++lastslash;
        int lastdot = urlsource.lastIndexOf(46);
        if (lastdot == -1) {
            lastdot = 0;
        }
        String filebase = urlsource.substring(lastslash, lastdot);
        Debug.output("url=" + urlsource + " filebase=" + filebase);
        BufferedImage bi = BufferedImageHelper.getBufferedImage(new URL(urlsource), 0, 0, uw, uh);
        if (bi == null) {
            Debug.error("JPEGHelper: Image load failed");
        } else {
            PrintStream html = new PrintStream(new FileOutputStream(new File(filebase + ".html")));
            html.println("Source url = " + urlsource + " <br>");
            html.println(" width = " + uw + " height=" + uh + " pixels=" + uw * uh + " <hr>");
            for (int i = 0; i < 20; ++i) {
                File f = new File(filebase + (i < 10 ? "0" : "") + i + ".jpg");
                float quality = 0.0499f * (float)i;
                JPEGHelper.encodeAndWriteJPEGFile(f, bi, quality);
                html.println("Image Quality Factor: " + quality + " <br>");
                html.println("Image Size (bytes) : " + f.length() + " <br>");
                html.println("<img src=\"" + f.getName() + "\"> <hr>");
            }
            html.close();
        }
        System.exit(-1);
    }
}

