/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.gui.time;

import com.bbn.openmap.gui.OMComponentPanel;
import com.bbn.openmap.time.RealTimeHandler;
import com.bbn.openmap.time.TimeEvent;
import com.bbn.openmap.time.TimeEventListener;
import com.bbn.openmap.time.TimerStatus;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToolBar;

public class TimerControlButtonPanel
extends OMComponentPanel
implements TimeEventListener,
ActionListener {
    protected ImageIcon backwardStepIcon;
    protected ImageIcon backwardIcon;
    protected ImageIcon forwardIcon;
    protected ImageIcon forwardStepIcon;
    protected ImageIcon pauseIcon;
    protected String DefaultBackwardStepIconURL = "stepbackward.png";
    protected String DefaultBackwardIconURL = "playbackward.png";
    protected String DefaultForwardIconURL = "playforward.png";
    protected String DefaultForwardStepIconURL = "stepforward.png";
    protected String DefaultPauseIconURL = "pause.png";
    protected String backwardStepIconURL = this.DefaultBackwardStepIconURL;
    protected String backwardIconURL = this.DefaultBackwardIconURL;
    protected String forwardIconURL = this.DefaultForwardIconURL;
    protected String forwardStepIconURL = this.DefaultForwardStepIconURL;
    protected String pauseIconURL = this.DefaultPauseIconURL;
    protected RealTimeHandler timeHandler;
    protected JButton forwardButton;
    protected JButton backwardButton;
    protected boolean clockEnabled = false;
    public static final String BackwardStepIconProperty = "backwardStepIcon";
    public static final String BackwardIconProperty = "backwardIcon";
    public static final String ForwardStepIconProperty = "forwardStepIcon";
    public static final String ForwardIconProperty = "forwardIcon";
    public static final String PauseIconProperty = "pauseIcon";

    public TimerControlButtonPanel() {
    }

    public TimerControlButtonPanel(RealTimeHandler rth) {
        this.setTimeHandler(rth);
    }

    public void setTimeHandler(RealTimeHandler rth) {
        if (this.timeHandler != null) {
            this.timeHandler.removeTimeEventListener(this);
        }
        this.timeHandler = rth;
        this.initGUI();
        if (this.timeHandler != null) {
            this.timeHandler.addTimeEventListener(this);
        }
    }

    public RealTimeHandler getTimeHandler() {
        return this.timeHandler;
    }

    public void initGUI() {
        this.removeAll();
        try {
            URL url = PropUtils.getResourceOrFileOrURL(this, this.forwardIconURL);
            this.forwardIcon = new ImageIcon(url);
            url = PropUtils.getResourceOrFileOrURL(this, this.forwardStepIconURL);
            this.forwardStepIcon = new ImageIcon(url);
            url = PropUtils.getResourceOrFileOrURL(this, this.backwardIconURL);
            this.backwardIcon = new ImageIcon(url);
            url = PropUtils.getResourceOrFileOrURL(this, this.backwardStepIconURL);
            this.backwardStepIcon = new ImageIcon(url);
            url = PropUtils.getResourceOrFileOrURL(this, this.pauseIconURL);
            this.pauseIcon = new ImageIcon(url);
        }
        catch (MalformedURLException murle) {
            Debug.error("TimerToggleButton: initGUI() bad icon.");
        }
        catch (NullPointerException npe) {
            Debug.error("TimerToggleButton: initGUI() bad icon.");
            npe.printStackTrace();
        }
        JToolBar jtb = new JToolBar();
        jtb.setFloatable(false);
        this.backwardButton = new JButton(this.backwardIcon);
        this.backwardButton.setToolTipText("Run Timer Backwards");
        this.backwardButton.setActionCommand("Timer run backward");
        this.backwardButton.addActionListener(this);
        jtb.add(this.backwardButton);
        JButton button = new JButton(this.backwardStepIcon);
        button.setToolTipText("Step Timer Backward");
        button.setActionCommand("Timer step backward");
        button.addActionListener(this);
        jtb.add(button);
        button = new JButton(this.forwardStepIcon);
        button.setToolTipText("Step Timer Forward");
        button.setActionCommand("Timer step forward");
        button.addActionListener(this);
        jtb.add(button);
        this.forwardButton = new JButton(this.forwardIcon);
        this.forwardButton.setToolTipText("Run Timer Forward");
        this.forwardButton.setActionCommand("Timer run forward");
        this.forwardButton.addActionListener(this);
        jtb.add(this.forwardButton);
        this.add(jtb);
    }

    protected void update(TimerStatus newStatus) {
        if (newStatus == TimerStatus.FORWARD) {
            if (Debug.debugging("timedetail")) {
                Debug.output("TimerControlButtonPanel: TIMER_FORWARD");
            }
            this.backwardButton.setIcon(this.backwardIcon);
            this.backwardButton.setActionCommand("Timer run backward");
            this.forwardButton.setIcon(this.pauseIcon);
            this.forwardButton.setActionCommand("Timer stopped");
        } else if (newStatus == TimerStatus.BACKWARD) {
            if (Debug.debugging("timedetail")) {
                Debug.output("TimerControlButtonPanel: TIMER_BACKWARD");
            }
            this.forwardButton.setIcon(this.forwardIcon);
            this.forwardButton.setActionCommand("Timer run forward");
            this.backwardButton.setIcon(this.pauseIcon);
            this.backwardButton.setActionCommand("Timer stopped");
        } else if (newStatus == TimerStatus.STOPPED) {
            if (Debug.debugging("timedetail")) {
                Debug.output("TimerControlButtonPanel: TIMER_STOPPED");
            }
            this.forwardButton.setIcon(this.forwardIcon);
            this.forwardButton.setActionCommand("Timer run forward");
            this.backwardButton.setIcon(this.backwardIcon);
            this.backwardButton.setActionCommand("Timer run backward");
        }
        this.checkClock(newStatus);
    }

    protected void checkClock(TimerStatus newStatus) {
        boolean clockState;
        boolean bl = clockState = newStatus != TimerStatus.INACTIVE;
        if (clockState != this.clockEnabled) {
            this.clockEnabled = clockState;
            this.setEnableState(this.clockEnabled);
        }
    }

    public void actionPerformed(ActionEvent ae) {
        String cmd = ae.getActionCommand();
        if (cmd == "Timer run forward") {
            this.timeHandler.setClockDirection(1);
            this.timeHandler.startClock();
        } else if (cmd == "Timer run backward") {
            this.timeHandler.setClockDirection(-1);
            this.timeHandler.startClock();
        } else if (cmd == "Timer step backward") {
            this.timeHandler.stepBackward();
        } else if (cmd == "Timer step forward") {
            this.timeHandler.stepForward();
        } else if (cmd == "Timer stopped") {
            this.timeHandler.stopClock();
        }
    }

    public void updateTime(TimeEvent te) {
        this.update(te.getTimerStatus());
    }

    public void setEnableState(boolean set) {
        this.forwardButton.setEnabled(set);
        this.backwardButton.setEnabled(set);
    }
}

