/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.event;

import com.bbn.openmap.MapBean;
import com.bbn.openmap.event.NavMouseMode;
import com.bbn.openmap.proj.Proj;
import com.bbn.openmap.proj.ProjMath;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;

public class NavMouseMode2
extends NavMouseMode {
    public NavMouseMode2() {
        this(true);
    }

    public NavMouseMode2(boolean shouldConsumeEvents) {
        super(shouldConsumeEvents);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseReleased(MouseEvent e) {
        if (Debug.debugging("mousemode")) {
            Debug.output(this.getID() + "|NavMouseMode2.mouseReleased()");
        }
        Object obj = e.getSource();
        if (!this.mouseSupport.fireMapMouseReleased(e)) {
            if (!(obj instanceof MapBean) || !this.autoZoom || this.point1 == null || this.point2 == null) {
                return;
            }
            MapBean map = (MapBean)obj;
            Projection projection = map.getProjection();
            Proj p = (Proj)projection;
            NavMouseMode2 navMouseMode2 = this;
            synchronized (navMouseMode2) {
                this.point2 = this.getRatioPoint((MapBean)e.getSource(), this.point1, e.getPoint());
                int dx = Math.abs(this.point2.x - this.point1.x);
                int dy = Math.abs(this.point2.y - this.point1.y);
                if (dx < 5 || dy < 5) {
                    this.paintRectangle(map, this.point1, this.point2);
                    if (dx < 5 && dy < 5) {
                        Point2D llp = map.getCoordinates(e);
                        boolean shift = e.isShiftDown();
                        boolean control = e.isControlDown();
                        if (control) {
                            if (shift) {
                                p.setScale(p.getScale() * 2.0f);
                            } else {
                                p.setScale(p.getScale() / 2.0f);
                            }
                        }
                        this.point1 = null;
                        this.point2 = null;
                        p.setCenter(llp);
                        map.setProjection(p);
                    }
                    return;
                }
                dx = Math.abs(this.point2.x - this.point1.x);
                dy = Math.abs(this.point2.y - this.point1.y);
                Point cornerPoint1 = new Point(this.point2.x < this.point1.x ? this.point2.x : this.point1.x, this.point2.y < this.point1.y ? this.point2.y : this.point1.y);
                Point cornerPoint2 = new Point(cornerPoint1.x + 2 * dx, cornerPoint1.y + 2 * dy);
                float newScale = ProjMath.getScale(cornerPoint1, cornerPoint2, projection);
                Point2D center = map.inverse(this.point1.x, this.point1.y, null);
                p.setScale(newScale);
                p.setCenter(center);
                this.point1 = null;
                this.point2 = null;
                map.setProjection(p);
            }
        }
    }

    protected void paintRectangle(Graphics g, Point pt1, Point pt2) {
        g.setXORMode(Color.lightGray);
        g.setColor(Color.darkGray);
        if (pt1 != null && pt2 != null) {
            int width = Math.abs(pt2.x - pt1.x);
            int height = Math.abs(pt2.y - pt1.y);
            if (width == 0) {
                ++width;
            }
            if (height == 0) {
                ++height;
            }
            g.drawRect(pt1.x - width, pt1.y - height, width * 2, height * 2);
            g.drawRect(pt1.x - 1, pt1.y - 1, 3, 3);
        }
    }
}

