/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.cgm;

import com.bbn.openmap.dataAccess.cgm.CGMDisplay;
import com.bbn.openmap.dataAccess.cgm.ColorCommand;
import com.bbn.openmap.dataAccess.cgm.ColorModel;
import com.bbn.openmap.dataAccess.cgm.ColorSelectionMode;
import com.bbn.openmap.dataAccess.cgm.ColorTable;
import com.bbn.openmap.dataAccess.cgm.Command;
import com.bbn.openmap.dataAccess.cgm.VDCExtent;
import java.awt.Color;
import java.awt.Graphics;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Vector;
import java.util.logging.Logger;

public class CGM
implements Cloneable {
    protected Vector<Command> commandList;
    protected static Logger logger = Logger.getLogger("com.bbn.openmap.dataAccess.cgm.CGM");

    public CGM() {
    }

    public CGM(String path) throws IOException {
        DataInputStream in = new DataInputStream(new FileInputStream(path));
        this.read(in);
        in.close();
    }

    public void read(DataInputStream in) throws IOException {
        Command c;
        this.commandList = new Vector();
        while ((c = Command.read(in)) != null) {
            this.commandList.addElement(c);
        }
        this.sortColors();
    }

    protected void paint(CGMDisplay d) {
        for (Command c : this.commandList) {
            c.paint(d);
        }
    }

    public void paint(Graphics g, int width, int height) {
        CGMDisplay cgmDisplay = new CGMDisplay(this);
        cgmDisplay.scale(width, height);
        cgmDisplay.paint(g);
    }

    protected void sortColors() {
        ColorTable ct = null;
        boolean indexed = false;
        for (Command c : this.commandList) {
            if (c instanceof ColorSelectionMode) {
                if (((ColorSelectionMode)c).selectionMode != 0) continue;
                indexed = true;
                continue;
            }
            if (c instanceof ColorTable) {
                ct = (ColorTable)c;
                continue;
            }
            if (!(c instanceof ColorModel)) continue;
            logger.fine("Not handling other colormodels than rgb (indexed and direct)");
        }
        if (indexed && ct != null) {
            for (Command c : this.commandList) {
                if (!(c instanceof ColorCommand)) continue;
                ((ColorCommand)c).setColorFromColorTable(ct);
            }
        }
    }

    public void scale(CGMDisplay d) {
        for (Command c : this.commandList) {
            c.scale(d);
        }
    }

    public int[] extent() {
        for (Command c : this.commandList) {
            if (!(c instanceof VDCExtent)) continue;
            return ((VDCExtent)c).extent();
        }
        return null;
    }

    public ColorTable getColorTable() {
        for (Command c : this.commandList) {
            if (!(c instanceof ColorTable)) continue;
            return (ColorTable)c;
        }
        return null;
    }

    public static void main(String[] args) throws IOException {
        DataInputStream in = new DataInputStream(new FileInputStream(args[0]));
        CGM cgm = new CGM();
        cgm.read(in);
        in.close();
    }

    public Object clone() {
        CGM newOne = new CGM();
        newOne.commandList = new Vector();
        for (int i = 0; i < this.commandList.size(); ++i) {
            newOne.commandList.addElement((Command)this.commandList.elementAt(i).clone());
        }
        return newOne;
    }

    public void showCGMCommands() {
        for (Command c : this.commandList) {
            System.out.println("Command: " + c);
        }
    }

    public void changeColor(Color oldc, Color newc) {
        for (int i = 0; i < this.commandList.size(); ++i) {
            Color currcolor;
            Command temp = this.commandList.elementAt(i);
            if (!(temp instanceof ColorCommand) || !(currcolor = ((ColorCommand)temp).C).equals(oldc)) continue;
            ((ColorCommand)temp).C = new Color(newc.getRed(), newc.getGreen(), newc.getBlue());
        }
    }

    public String toString() {
        if (this.commandList != null) {
            StringBuffer buf = new StringBuffer();
            int count = 0;
            for (Command c : this.commandList) {
                buf.append("Command ").append(count++).append(": ").append(c.toString()).append("\n");
            }
            return buf.toString();
        }
        return "CGM: not read yet?";
    }
}

