/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.proj;

import com.bbn.openmap.MoreMath;
import com.bbn.openmap.proj.Ellipsoid;
import com.bbn.openmap.proj.GeoProj;
import com.bbn.openmap.proj.ProjMath;
import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.util.Debug;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LambertConformal
extends GeoProj {
    public static final transient String LambertConformalName = "Lambert Conformal";
    private static final int MODE_2SP = 1;
    private static final int MODE_BELGIUM = 2;
    private int mode = 1;
    private double lambert_sp_one;
    private double lambert_sp_two;
    private double centralMeridian;
    double locationCenterXPixel = 0.0;
    double locationCenterYPixel = 0.0;
    double locationCenterXLambert = 0.0;
    double locationCenterYLambert = 0.0;
    double locationPixelsPerLambert = 0.0;
    double locationOriginX = 0.0;
    double locationOriginY = 0.0;
    double locationOriginXfPixel = 0.0;
    double locationOriginYfPixel = 0.0;
    double referenceLatitude = 0.0;
    double falseEasting = 0.0;
    double falseNorthing = 0.0;
    double n = 0.0;
    double F = 0.0;
    double rf = 0.0;
    double lamdaf = 0.0;
    double alpha = 0.0;
    private transient Ellipsoid ellps = Ellipsoid.WGS_84;
    public static final double EPS10 = 1.0E-10;
    protected Point2D plotablePoint = new Point2D.Double();

    protected LambertConformal(LatLonPoint center, float scale, int width, int height) {
        super(center, scale, width, height);
    }

    protected LambertConformal(LatLonPoint center, float scale, int width, int height, float centralMeridian, float sp_one, float sp_two, Ellipsoid ellps) {
        this(center, scale, width, height, centralMeridian, sp_one, sp_two, 0.0, 0.0, 0.0, ellps);
    }

    public LambertConformal(LatLonPoint center, float scale, int width, int height, double centralMeridian, double sp_one, double sp_two, double reference_latitude, double falseEasting, double falseNorthing, Ellipsoid ellps) {
        super(center, scale, width, height);
        if (Math.abs(sp_one + sp_two) < 1.0E-10) {
            throw new RuntimeException("Unable to create Lambert Cornic");
        }
        this.centralMeridian = centralMeridian;
        this.lambert_sp_one = sp_one;
        this.lambert_sp_two = sp_two;
        this.referenceLatitude = reference_latitude;
        this.falseEasting = falseEasting;
        this.falseNorthing = falseNorthing;
        this.ellps = ellps;
        this.computeParameters();
    }

    @Override
    public void computeParameters() {
        if (this.ellps == null) {
            this.ellps = Ellipsoid.WGS_84;
        }
        this.alpha = this.mode == 2 ? 1.4204E-4 : 0.0;
        double phi1 = ProjMath.degToRad(this.lambert_sp_one);
        double phi2 = ProjMath.degToRad(this.lambert_sp_two);
        double phif = ProjMath.degToRad(this.referenceLatitude);
        double e = this.ellps.ecc;
        double sinphi = Math.sin(phi1);
        double m1 = LambertConformal.lambMsfn(sinphi, Math.cos(phi1), e);
        double t1 = LambertConformal.lambTsfn(phi1, sinphi, e);
        if (MoreMath.approximately_equal(phi1, phi2, 1.0E-10)) {
            this.n = sinphi;
        } else {
            sinphi = Math.sin(phi2);
            double m2 = LambertConformal.lambMsfn(sinphi, Math.cos(phi2), e);
            double t2 = LambertConformal.lambTsfn(phi2, sinphi, e);
            this.n = Math.log(m1 / m2) / Math.log(t1 / t2);
        }
        this.F = m1 / (this.n * Math.pow(t1, this.n));
        this.rf = MoreMath.approximately_equal(phi1, phi2, 1.0E-10) ? 0.0 : this.ellps.radius * this.F * Math.pow(LambertConformal.lambTsfn(phif, Math.sin(phif), e), this.n);
        this.lamdaf = ProjMath.degToRad(this.centralMeridian);
        this.locationCenterXPixel = (double)this.getWidth() / 2.0;
        this.locationCenterYPixel = (double)this.getHeight() / 2.0;
        this.locationPixelsPerLambert = this.getPPM() / (double)this.getScale();
        LatLonPoint.Double origin = new LatLonPoint.Double(this.referenceLatitude, this.centralMeridian);
        Point2D lp = this.LLToWorld(((Point2D)origin).getY(), ((Point2D)origin).getX(), new Point2D.Double());
        this.locationOriginX = lp.getX();
        this.locationOriginY = lp.getY();
        LatLonPoint center = this.getCenter();
        lp = this.LLToWorld(center.getY(), center.getX(), lp);
        this.locationCenterXLambert = lp.getX();
        this.locationCenterYLambert = lp.getY();
        this.locationOriginXfPixel = this.locationCenterXPixel + (this.locationOriginX - this.locationCenterXLambert) * this.locationPixelsPerLambert;
        this.locationOriginYfPixel = this.locationCenterYPixel - (this.locationOriginY - this.locationCenterYLambert) * this.locationPixelsPerLambert;
        if (Debug.debugging("Lambert")) {
            Debug.output("Creating LambertConformal: center x = " + this.locationCenterXLambert + ", center y = " + this.locationCenterYLambert);
            Debug.output("Creating LambertConformal: origin x = " + this.locationOriginX + ", origin y = " + this.locationOriginY);
        }
    }

    @Override
    public double normalizeLatitude(double lat) {
        if (lat > 1.5707963705062866) {
            return 1.5707963705062866;
        }
        if (lat < -1.5707963705062866) {
            return -1.5707963705062866;
        }
        return lat;
    }

    @Override
    public void pan(float Az) {
        if (MoreMath.approximately_equal(Math.abs(Az), 180.0f, 0.01f)) {
            this.setCenter(this.inverse(this.width / 2, this.height));
        } else if (MoreMath.approximately_equal(Az, -135.0f, 0.01f)) {
            this.setCenter(this.inverse(0.0, this.height));
        } else if (MoreMath.approximately_equal(Az, -90.0f, 0.01f)) {
            this.setCenter(this.inverse(0.0, this.height / 2));
        } else if (MoreMath.approximately_equal(Az, -45.0f, 0.01f)) {
            this.setCenter(this.inverse(0.0, 0.0));
        } else if (MoreMath.approximately_equal(Az, 0.0f, 0.01f)) {
            this.setCenter(this.inverse(this.width / 2, 0.0));
        } else if (MoreMath.approximately_equal(Az, 45.0f, 0.01f)) {
            this.setCenter(this.inverse(this.width, 0.0));
        } else if (MoreMath.approximately_equal(Az, 90.0f, 0.01f)) {
            this.setCenter(this.inverse(this.width, this.height / 2));
        } else if (MoreMath.approximately_equal(Az, 135.0f, 0.01f)) {
            this.setCenter(this.inverse(this.width, this.height));
        } else {
            super.pan(Az);
        }
    }

    public Point2D LLToWorld(double lat, double lon, Point2D lp) {
        if (lp == null) {
            lp = new Point2D.Double();
        }
        this.LLToWorldReturningLon(lat, lon, lp);
        return lp;
    }

    protected double LLToWorldReturningLon(double lat, double lon, Point2D lp) {
        double phi_deg = lat;
        double phi = ProjMath.degToRad(phi_deg);
        double lamba_deg = lon;
        double lamba = ProjMath.degToRad(lamba_deg);
        double dlamda = lamba - this.lamdaf;
        if (dlamda > Math.PI) {
            dlamda -= Math.PI * 2;
        } else if (dlamda < -Math.PI) {
            dlamda += Math.PI * 2;
        }
        double e = this.ellps.ecc;
        double r = 0.0;
        if (!MoreMath.approximately_equal(Math.abs(phi), 1.5707963705062866, 1.0E-10)) {
            double t = LambertConformal.lambTsfn(phi, Math.sin(phi), e);
            r = this.ellps.radius * this.F * Math.pow(t, this.n);
        }
        double theta = this.n * dlamda;
        double easting = this.falseEasting + r * Math.sin(theta - this.alpha);
        double northing = this.falseNorthing + this.rf - r * Math.cos(theta - this.alpha);
        lp.setLocation(easting, northing);
        return dlamda;
    }

    public double LLToPixel(double lat, double lon, Point2D p) {
        Point2D.Double lp = new Point2D.Double();
        double dlamda = this.LLToWorldReturningLon(lat, lon, lp);
        double xrel = ((Point2D)lp).getX() - this.locationCenterXLambert;
        double yrel = ((Point2D)lp).getY() - this.locationCenterYLambert;
        xrel *= this.locationPixelsPerLambert;
        yrel *= this.locationPixelsPerLambert;
        xrel = this.locationCenterXPixel + xrel;
        yrel = this.locationCenterYPixel - yrel;
        if (p == null) {
            p = new Point2D.Double();
        }
        p.setLocation(xrel, yrel);
        if (dlamda > 3.1415 && p.getX() < this.locationOriginXfPixel || -dlamda > 3.1415 && p.getX() > this.locationOriginXfPixel) {
            dlamda = -dlamda;
        }
        return dlamda;
    }

    public Point worldToPixel(Point2D lp, Point p) {
        double x = this.locationCenterXPixel + (lp.getX() - this.locationCenterXLambert) * this.locationPixelsPerLambert;
        double y = this.locationCenterYPixel - (lp.getY() - this.locationCenterYLambert) * this.locationPixelsPerLambert;
        if (p == null) {
            p = new Point();
        }
        p.setLocation((int)x, (int)y);
        return p;
    }

    public Point2D pixelToWorld(Point p, Point2D lp) {
        double x = this.locationCenterXLambert + (p.getX() - this.locationCenterXPixel) / this.locationPixelsPerLambert;
        double y = this.locationCenterYLambert - (p.getY() - this.locationCenterYPixel) / this.locationPixelsPerLambert;
        if (lp == null) {
            lp = new Point2D.Double();
        }
        lp.setLocation(x, y);
        return lp;
    }

    public Point2D worldToLL(double x, double y, Point2D llp) {
        double halfesinphi;
        double rR;
        if ((rR = Math.sqrt((x -= this.falseEasting) * x + (y = this.rf - (y - this.falseNorthing)) * y)) < 1.0E-10) {
            llp.setLocation(0.0, this.n > 0.0 ? 90.0 : -90.0);
            return llp;
        }
        if (this.n < 0.0) {
            rR = -rR;
            x = -x;
            y = -y;
        }
        double tR = Math.pow(rR / (this.ellps.radius * this.F), 1.0 / this.n);
        double halfe = 0.5 * this.ellps.ecc;
        double phiT1 = 0.0;
        double phiT2 = 1.5707963705062866 - 2.0 * Math.atan(tR);
        int iIter = 0;
        int nIter = 10;
        while (Math.abs((phiT2 = 1.5707963705062866 - 2.0 * Math.atan(tR * Math.pow((0.5 - (halfesinphi = halfe * Math.sin(phiT1 = phiT2))) / (0.5 + halfesinphi), halfe))) - phiT1) > 1.0E-10 && iIter++ < nIter) {
        }
        double lamda = (Math.atan2(x, y) + this.alpha) / this.n + this.lamdaf;
        double lamda_deg = ProjMath.radToDeg(lamda);
        double phi_deg = ProjMath.radToDeg(phiT2);
        if (llp == null) {
            llp = new LatLonPoint.Double();
        }
        llp.setLocation(lamda_deg, phi_deg);
        return llp;
    }

    public Point2D pixelToLL(double xabs, double yabs, Point2D llp) {
        double x = this.locationCenterXLambert + (xabs - this.locationCenterXPixel) / this.locationPixelsPerLambert;
        double y = this.locationCenterYLambert + (this.locationCenterYPixel - yabs) / this.locationPixelsPerLambert;
        this.worldToLL(x, y, llp);
        return llp;
    }

    @Override
    public boolean isPlotable(double lat, double lon) {
        if (lat < -70.0) {
            return false;
        }
        this.forward(lat, lon, this.plotablePoint);
        double x = this.plotablePoint.getX();
        double y = this.plotablePoint.getY();
        return x >= 0.0 && x < (double)this.width && y >= 0.0 && y < (double)this.height;
    }

    public boolean isPlotable(LatLonPoint llpoint) {
        return this.isPlotable(llpoint.getY(), llpoint.getX());
    }

    @Override
    public Point2D forward(double lat, double lon, Point2D p, boolean isRadian) {
        if (p == null) {
            p = new Point2D.Double();
        }
        this._forward(lat, lon, p, isRadian);
        return p;
    }

    protected double _forward(double lat, double lon, Point2D p, boolean isRadian) {
        if (isRadian) {
            return this.LLToPixel(ProjMath.radToDeg(lat), ProjMath.radToDeg(lon), p);
        }
        return this.LLToPixel(lat, lon, p);
    }

    @Override
    public <T extends Point2D> T inverse(double x, double y, T llp) {
        if (llp == null) {
            llp = new LatLonPoint.Double();
        }
        this.pixelToLL(x, y, (Point2D)llp);
        return llp;
    }

    @Override
    public LatLonPoint getUpperLeft() {
        return new LatLonPoint.Double(90.0, -180.0);
    }

    @Override
    public LatLonPoint getLowerRight() {
        return new LatLonPoint.Double(-90.0, 180.0);
    }

    @Override
    public double getReferenceLon() {
        return this.centralMeridian;
    }

    @Override
    public String getName() {
        return LambertConformalName;
    }

    @Override
    public boolean forwardRaw(float[] rawllpts, int rawoff, float[] xcoords, float[] ycoords, boolean[] visible, int copyoff, int copylen) {
        double[] drawllpts = new double[rawllpts.length];
        System.arraycopy(drawllpts, 0, rawllpts, 0, rawllpts.length);
        return this.forwardRaw(drawllpts, rawoff, xcoords, ycoords, visible, copyoff, copylen);
    }

    @Override
    public boolean forwardRaw(double[] rawllpts, int rawoff, float[] xcoords, float[] ycoords, boolean[] visible, int copyoff, int copylen) {
        boolean visibleTotal = false;
        Point temp = new Point();
        int end = copylen + copyoff;
        int i = copyoff;
        int j = rawoff;
        while (i < end) {
            this.forward(rawllpts[j], rawllpts[j + 1], (Point2D)temp, true);
            xcoords[i] = temp.x;
            ycoords[i] = temp.y;
            boolean bl = visible[i] = 0 <= temp.x && temp.x <= this.width && 0 <= temp.y && temp.y <= this.height;
            if (visible[i] && !visibleTotal) {
                visibleTotal = true;
            }
            ++i;
            j += 2;
        }
        return visibleTotal;
    }

    @Override
    protected ArrayList<float[]> _forwardPoly(float[] rawllpts, int ltype, int nsegs, boolean isFilled) {
        double[] drawllpts = new double[rawllpts.length];
        System.arraycopy(drawllpts, 0, rawllpts, 0, rawllpts.length);
        return this._forwardPoly(drawllpts, ltype, nsegs, isFilled);
    }

    @Override
    public ArrayList<float[]> _forwardPoly(double[] rawllpts, int ltype, int nsegs, boolean isFilled) {
        int len = rawllpts.length >> 1;
        if (len < 2) {
            return new ArrayList<float[]>(0);
        }
        double minlat = ProjMath.degToRad(-60.0f);
        boolean allBelowMinLat = true;
        int i = 0;
        int j = 0;
        while (i < len) {
            for (double l = rawllpts[j + 1]; l < 0.0; l += Math.PI * 2) {
            }
            if (rawllpts[j] > minlat) {
                allBelowMinLat = false;
            }
            ++i;
            j += 2;
        }
        if (allBelowMinLat) {
            return new ArrayList<float[]>(0);
        }
        if (this.isComplicatedLineType(ltype)) {
            return this.doPolyDispatch(rawllpts, ltype, nsegs, isFilled);
        }
        Point temp = new Point();
        int[] xa = new int[len];
        float[] xs = new float[len];
        float[] ys = new float[len];
        int k = 0;
        xa[k] = 0;
        i = 0;
        double dlamda1 = this._forward(rawllpts[i], rawllpts[i + 1], temp, true);
        xs[i] = temp.x;
        ys[i] = temp.y;
        i = 1;
        j = 2;
        while (i < len) {
            double dlamda2 = this._forward(rawllpts[j], rawllpts[j + 1], temp, true);
            if (Math.abs(dlamda2 - dlamda1) >= Math.PI) {
                xa[++k] = i;
            }
            xs[i] = temp.x;
            ys[i] = temp.y;
            dlamda1 = dlamda2;
            ++i;
            j += 2;
        }
        if (xa[k] < len) {
            xa[++k] = len;
        }
        ArrayList<float[]> ret_val = new ArrayList<float[]>(2);
        for (i = 0; i < k; ++i) {
            len = xa[i + 1] - xa[i];
            if (len <= 0) continue;
            float[] xf = new float[len];
            float[] yf = new float[len];
            for (j = 0; j < len; ++j) {
                xf[j] = xs[j + xa[i]];
                yf[j] = ys[j + xa[i]];
            }
            if (i > 0 && i == k - 1 && xs[0] == xs[xs.length - 1] && ys[0] == ys[ys.length - 1]) {
                int len0 = ret_val.get(0).length;
                float[] x0 = new float[len0 + len];
                float[] y0 = new float[len0 + len];
                System.arraycopy(xf, 0, x0, 0, len);
                System.arraycopy(yf, 0, y0, 0, len);
                System.arraycopy(ret_val.get(0), 0, x0, len, len0);
                System.arraycopy(ret_val.get(1), 0, y0, len, len0);
                ret_val.set(0, x0);
                ret_val.set(1, y0);
                continue;
            }
            ret_val.add(xf);
            ret_val.add(yf);
        }
        return ret_val;
    }

    @Override
    public float getScale(Point2D ll1, Point2D ll2, Point2D point1, Point2D point2) {
        double widthPX = point2.getX() - point1.getX();
        Point2D xx1 = this.LLToWorld(ll1.getY(), ll1.getX(), new Point2D.Double());
        Point2D xx2 = this.LLToWorld(ll2.getY(), ll2.getX(), new Point2D.Double());
        double widthMap = xx2.getX() - xx1.getX();
        double widthScale = this.getPPM() * (widthMap / widthPX);
        return (float)widthScale;
    }

    @Override
    public void drawBackground(Graphics2D g, Paint paint) {
        g.setPaint(paint);
        this.drawBackground(g);
    }

    @Override
    public void drawBackground(Graphics g) {
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    public static double lambMsfn(double sinphi, double cosphi, double e) {
        return cosphi / Math.sqrt(1.0 - (sinphi *= e) * sinphi);
    }

    public static double lambTsfn(double phi, double sinphi, double e) {
        return Math.tan((1.5707963705062866 - phi) * 0.5) * Math.pow((1.0 + (sinphi *= e)) / (1.0 - sinphi), 0.5 * e);
    }

    public static void main(String[] argv) {
        Debug.init();
        Debug.put("Lambert");
        LambertConformal proj = null;
        proj = new LambertConformal(new LatLonPoint.Double(50.67957305908203, 5.80737f), 100000.0f, 620, 480, 4.356939315795898, -49.83333206176758, -51.16666793823242, 90.0, 150000.015625, 5400088.5, Ellipsoid.WGS_84);
        Debug.message("Lambert", "(1)" + proj.inverse(310.0, 240.0));
        LatLonPoint.Double llp = new LatLonPoint.Double(0.0, 0.0);
        Debug.message("Lambert", "(2)" + proj.worldToLL(251763.203125, 153034.125, llp));
        LatLonPoint.Double pt = new LatLonPoint.Double(50.67957305908203, 5.80737f);
        Point2D lp = proj.LLToWorld(((Point2D)pt).getY(), ((Point2D)pt).getX(), new Point2D.Double());
        Debug.message("Lambert", "(3)" + lp);
    }
}

