/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.vpf;

import com.bbn.openmap.io.BinaryFile;
import com.bbn.openmap.io.FormatException;
import com.bbn.openmap.layer.vpf.CoverageAttributeTable;
import com.bbn.openmap.layer.vpf.CoverageTable;
import com.bbn.openmap.layer.vpf.DcwRecordFile;
import com.bbn.openmap.layer.vpf.TileDirectory;
import com.bbn.openmap.layer.vpf.VPFFeatureWarehouse;
import com.bbn.openmap.layer.vpf.VPFGraphicWarehouse;
import com.bbn.openmap.layer.vpf.VPFLayer;
import com.bbn.openmap.proj.coords.LatLonPoint;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LibrarySelectionTable {
    public static final int DEFAULT_BROWSE_CUTOFF = 31000000;
    protected int BROWSE_CUTOFF = 31000000;
    private Map<String, float[]> boundrec = new HashMap<String, float[]>();
    private Map<String, CoverageAttributeTable> CATs = new HashMap<String, CoverageAttributeTable>();
    private List<String> orderedLibraryNameList = new ArrayList<String>();
    private static final String[] LATColumns = new String[]{"library_name", "xmin", "ymin", "xmax", "ymax"};
    private static final char[] LATschematype = new char[]{'T', 'F', 'F', 'F', 'F'};
    private static final int[] LATschemalength = new int[]{-1, 1, 1, 1, 1};
    private String databaseName;
    private String databaseDesc;

    public LibrarySelectionTable() {
    }

    public LibrarySelectionTable(String vpfpath) throws FormatException {
        this.addDataPath(vpfpath);
    }

    public LibrarySelectionTable(String[] vpfpaths) throws FormatException {
        for (int i = 0; i < vpfpaths.length; ++i) {
            this.addDataPath(vpfpaths[i]);
        }
    }

    public void setCutoffScale(int scale) {
        this.BROWSE_CUTOFF = scale;
    }

    public int getCutoffScale() {
        return this.BROWSE_CUTOFF;
    }

    public void addDataPath(String vpfpath) throws FormatException {
        VPFLayer.logger.fine("LST.addDataPath(" + vpfpath + ")");
        boolean addSlash = true;
        if (vpfpath.endsWith("/") || vpfpath.endsWith(File.separator)) {
            addSlash = false;
        }
        String latf = vpfpath + (addSlash ? "/" : "") + "lat";
        String dhtf = vpfpath + (addSlash ? "/" : "") + "dht";
        if (!BinaryFile.exists(latf)) {
            latf = latf + ".";
            dhtf = dhtf + ".";
        }
        DcwRecordFile latrf = new DcwRecordFile(latf);
        DcwRecordFile dhtrf = new DcwRecordFile(dhtf);
        List<Object> databaseVec = dhtrf.parseRow();
        int dcol = dhtrf.whatColumn("database_name");
        if (dcol != -1) {
            this.databaseName = (String)databaseVec.get(dcol);
        }
        if ((dcol = dhtrf.whatColumn("database_desc")) != -1) {
            this.databaseDesc = (String)databaseVec.get(dcol);
        }
        dhtrf.close();
        dhtrf = null;
        int[] latcols = latrf.lookupSchema(LATColumns, true, LATschematype, LATschemalength, false);
        VPFLayer.logger.fine("lst.adp: looked up schema");
        ArrayList<Object> l = new ArrayList<Object>(latrf.getColumnCount());
        while (latrf.parseRow(l)) {
            String lname = ((String)l.get(latcols[0])).toLowerCase();
            float[] br = new float[]{((Float)l.get(latcols[1])).floatValue(), ((Float)l.get(latcols[2])).floatValue(), ((Float)l.get(latcols[3])).floatValue(), ((Float)l.get(latcols[4])).floatValue()};
            try {
                CoverageAttributeTable table = new CoverageAttributeTable(vpfpath, lname);
                this.CATs.put(lname, table);
                this.boundrec.put(lname, br);
                this.orderedLibraryNameList.add(lname);
                if (!VPFLayer.logger.isLoggable(Level.FINE)) continue;
                VPFLayer.logger.fine(lname + " " + br[0] + " " + br[1] + " " + br[2] + " " + br[3]);
            }
            catch (FormatException fe) {
                if (VPFLayer.logger.isLoggable(Level.FINER)) {
                    VPFLayer.logger.finer("*****\nVPFLayer.LST: Couldn't create CoverageAttributeTable for " + vpfpath + " " + lname + " " + fe.getMessage() + "\n--- Not a problem if you have multiple paths, and " + lname + " is included in another path ---\n*****");
                    fe.printStackTrace();
                    continue;
                }
                VPFLayer.logger.fine("VPFLayer.LST: CAT discrepancy (run with finer logging level for more details)");
            }
        }
        latrf.close();
        latrf = null;
    }

    public List<String> getLibraryNames() {
        return new ArrayList<String>(this.orderedLibraryNameList);
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getDatabaseDescription() {
        return this.databaseDesc;
    }

    public CoverageAttributeTable getCAT(String library) throws FormatException {
        return this.CATs.get(library);
    }

    public void drawTile(int scale, int screenwidth, int screenheight, String covname, VPFGraphicWarehouse warehouse, LatLonPoint ll1, LatLonPoint ll2) {
        if (VPFLayer.logger.isLoggable(Level.FINE)) {
            VPFLayer.logger.fine("Library selection table coverage: " + covname);
            VPFLayer.logger.fine("Library selection table - edges: " + warehouse.drawEdgeFeatures());
            VPFLayer.logger.fine("Library selection table - text: " + warehouse.drawTextFeatures());
            VPFLayer.logger.fine("Library selection table - areas: " + warehouse.drawAreaFeatures());
            VPFLayer.logger.fine("Warehouse: " + warehouse);
            VPFLayer.logger.fine("Warehouse: cutoff scale " + this.BROWSE_CUTOFF);
        }
        if (scale < this.BROWSE_CUTOFF && ll1.getLongitude() > ll2.getLongitude()) {
            this.drawTile(scale, screenwidth, screenheight, covname, warehouse, ll1, new LatLonPoint.Float(ll2.getLatitude(), 179.99998f));
            this.drawTile(scale, screenwidth, screenheight, covname, warehouse, new LatLonPoint.Float(ll1.getLatitude(), -180.0f), ll2);
            return;
        }
        if (VPFLayer.logger.isLoggable(Level.FINE)) {
            VPFLayer.logger.fine("LST.drawTile() with scale of " + scale);
        }
        float dpplat = Math.abs((ll1.getLatitude() - ll2.getLatitude()) / (float)screenheight);
        float dpplon = Math.abs((ll1.getLongitude() - ll2.getLongitude()) / (float)screenwidth);
        int inArea = 0;
        CoverageTable redrawUntiled = null;
        for (CoverageAttributeTable cat : this.CATs.values()) {
            if (VPFLayer.logger.isLoggable(Level.FINE)) {
                VPFLayer.logger.fine("LST: checking library: " + cat.getLibraryName());
            }
            if (!warehouse.checkLibraryForUsage(cat.getLibraryName())) continue;
            warehouse.resetForCAT();
            List<TileDirectory> tiles = cat.tilesInRegion(ll1.getLatitude(), ll2.getLatitude(), ll2.getLongitude(), ll1.getLongitude());
            if (tiles == null) {
                redrawUntiled = cat.getCoverageTable(covname);
                continue;
            }
            if (!cat.isTiledData() || scale >= this.BROWSE_CUTOFF || tiles.isEmpty()) continue;
            CoverageTable c = cat.getCoverageTable(covname);
            if (c == null) {
                if (!VPFLayer.logger.isLoggable(Level.FINE)) continue;
                VPFLayer.logger.fine("|LST.drawTile(): Couldn't get coverage table for " + covname + " " + cat.getLibraryName());
                continue;
            }
            if (VPFLayer.logger.isLoggable(Level.FINE)) {
                VPFLayer.logger.fine("Using coverage table for " + covname + " " + cat.getLibraryName());
            }
            ++inArea;
            for (TileDirectory tileDirectory : tiles) {
                c.drawTile(tileDirectory, warehouse, ll1, ll2, dpplat, dpplon);
            }
        }
        if (redrawUntiled != null && inArea == 0) {
            if (VPFLayer.logger.isLoggable(Level.FINE)) {
                VPFLayer.logger.fine("LST drawing untiled browse data");
            }
            redrawUntiled.drawTile(new TileDirectory(), warehouse, ll1, ll2, dpplat, dpplon);
        }
    }

    public void drawFeatures(int scale, int screenwidth, int screenheight, String covname, VPFFeatureWarehouse warehouse, LatLonPoint ll1, LatLonPoint ll2) {
        if (VPFLayer.logger.isLoggable(Level.FINE)) {
            VPFLayer.logger.fine("LST.drawFeatures(): Coverage name: " + covname);
            VPFLayer.logger.fine("Library selection table - edges: " + warehouse.drawEdgeFeatures());
            VPFLayer.logger.fine("Library selection table - text: " + warehouse.drawTextFeatures());
            VPFLayer.logger.fine("Library selection table - areas: " + warehouse.drawAreaFeatures());
            VPFLayer.logger.fine("Warehouse: " + warehouse);
        }
        if (scale < this.BROWSE_CUTOFF && ll1.getLongitude() > ll2.getLongitude()) {
            this.drawFeatures(scale, screenwidth, screenheight, covname, warehouse, ll1, new LatLonPoint.Float(ll2.getLatitude(), 179.99998f));
            this.drawFeatures(scale, screenwidth, screenheight, covname, warehouse, new LatLonPoint.Float(ll1.getLatitude(), -180.0f), ll2);
            return;
        }
        if (VPFLayer.logger.isLoggable(Level.FINE)) {
            VPFLayer.logger.fine("LST.drawFeatures() with scale of " + scale);
        }
        float dpplat = Math.abs((ll1.getLatitude() - ll2.getLatitude()) / (float)screenheight);
        float dpplon = Math.abs((ll1.getLongitude() - ll2.getLongitude()) / (float)screenwidth);
        int inArea = 0;
        CoverageTable redrawUntiled = null;
        for (CoverageAttributeTable cat : this.CATs.values()) {
            if (!warehouse.checkLibraryForUsage(cat.getLibraryName())) continue;
            if (cat.isTiledCoverage() && scale < this.BROWSE_CUTOFF) {
                CoverageTable c = cat.getCoverageTable(covname);
                if (c == null) {
                    if (!VPFLayer.logger.isLoggable(Level.FINE)) continue;
                    VPFLayer.logger.fine("LST.getFeatures(): Couldn't get coverage table for " + covname + " " + cat.getLibraryName());
                    continue;
                }
                if (VPFLayer.logger.isLoggable(Level.FINE)) {
                    VPFLayer.logger.fine("Using coverage table for " + covname + " " + cat.getLibraryName());
                }
                c.drawFeatures(warehouse, ll1, ll2, dpplat, dpplon);
                ++inArea;
                continue;
            }
            if (VPFLayer.logger.isLoggable(Level.FINE)) {
                VPFLayer.logger.fine("LST.drawTile(): Scale too small (probably) or no tiles in region.");
            }
            if ((redrawUntiled = cat.getCoverageTable(covname)) == null) continue;
            redrawUntiled.drawFeatures(warehouse, ll1, ll2, dpplat, dpplon);
        }
    }

    public String getDescription(String coverageOrFeatureType) throws FormatException {
        boolean DEBUG = VPFLayer.logger.isLoggable(Level.FINE);
        if (DEBUG) {
            VPFLayer.logger.fine("LST.getDescription: " + coverageOrFeatureType);
        }
        for (String libraryName : this.getLibraryNames()) {
            CoverageAttributeTable cat = this.getCAT(libraryName);
            if (cat == null) continue;
            String[] coverages = cat.getCoverageNames();
            for (int j = 0; j < coverages.length; ++j) {
                String covname = coverages[j];
                if (coverageOrFeatureType.equalsIgnoreCase(covname)) {
                    if (DEBUG) {
                        VPFLayer.logger.fine("** Matches coverage " + covname);
                    }
                    return cat.getCoverageDescription(covname);
                }
                if (DEBUG) {
                    VPFLayer.logger.fine("   Checking in coverage table " + covname);
                }
                CoverageTable ct = cat.getCoverageTable(covname);
                Hashtable<String, CoverageTable.FeatureClassRec> info = ct.getFeatureTypeInfo();
                for (CoverageTable.FeatureClassRec fcr : info.values()) {
                    String name = fcr.feature_class;
                    if (coverageOrFeatureType.equalsIgnoreCase(name)) {
                        if (DEBUG) {
                            VPFLayer.logger.fine("** Found feature " + name);
                        }
                        return fcr.description;
                    }
                    if (!DEBUG) continue;
                    VPFLayer.logger.fine("   checked " + name);
                }
            }
        }
        if (DEBUG) {
            VPFLayer.logger.fine("-- No matches found.");
        }
        return null;
    }

    public static void main(String[] args) {
        String dcwbase = null;
        if (args.length > 0) {
            dcwbase = args[0];
            try {
                LibrarySelectionTable lst = new LibrarySelectionTable(dcwbase);
                System.out.println("Database Name " + lst.getDatabaseName());
                for (String libraryName : lst.getLibraryNames()) {
                    System.out.println("Library " + libraryName);
                    lst.getCAT(libraryName);
                }
            }
            catch (FormatException f) {
                System.err.println("*****************************************");
                System.err.println("*---------------------------------------*");
                System.err.println("Format error in dealing with LST");
                System.err.println(f.getMessage());
                System.err.println("*---------------------------------------*");
                System.err.println("*****************************************");
            }
        } else {
            System.out.println("Need a path to the VPF lat. file");
        }
    }
}

