/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.rpf;

import com.bbn.openmap.layer.rpf.RpfCoverageBox;
import com.bbn.openmap.layer.rpf.RpfFrameProvider;
import com.bbn.openmap.layer.rpf.RpfProductInfo;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMRect;
import com.bbn.openmap.proj.CADRG;
import com.bbn.openmap.proj.ProjMath;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.util.Debug;
import java.awt.Color;
import java.util.Vector;

public class RpfCoverageManager {
    protected int currentLineType;
    protected RpfFrameProvider frameProvider;

    public RpfCoverageManager(RpfFrameProvider rfp) {
        this.frameProvider = rfp;
    }

    protected OMGraphicList getCatalogCoverage(float ullat, float ullon, float lrlat, float lrlon, Projection proj, String chartSeries, Color[] colors, boolean fillRects) {
        OMGraphicList omGraphics = new OMGraphicList();
        Debug.message("rpfcov", "RpfCoverageManager: Getting catalog coverage from RpfFrameProvider");
        if (proj == null || this.frameProvider == null) {
            return omGraphics;
        }
        CADRG cadrg = proj instanceof CADRG ? (CADRG)proj : new CADRG(proj.getCenter(new LatLonPoint.Float()), proj.getScale(), proj.getWidth(), proj.getHeight());
        Vector<RpfCoverageBox> hemisphereData = new Vector<RpfCoverageBox>();
        if (ProjMath.isCrossingDateline(ullon, lrlon, proj.getScale())) {
            hemisphereData.addAll(this.frameProvider.getCatalogCoverage(ullat, ullon, lrlat, 180.0f, cadrg, chartSeries));
            hemisphereData.addAll(this.frameProvider.getCatalogCoverage(ullat, -180.0f, lrlat, lrlon, cadrg, chartSeries));
        } else {
            hemisphereData.addAll(this.frameProvider.getCatalogCoverage(ullat, ullon, lrlat, lrlon, cadrg, chartSeries));
        }
        this.currentLineType = 2;
        OMGraphicList cgs = new OMGraphicList();
        OMGraphicList tlms = new OMGraphicList();
        OMGraphicList jogs = new OMGraphicList();
        OMGraphicList tpcs = new OMGraphicList();
        OMGraphicList oncs = new OMGraphicList();
        OMGraphicList jncs = new OMGraphicList();
        OMGraphicList gncs = new OMGraphicList();
        OMGraphicList cib10s = new OMGraphicList();
        OMGraphicList cib5s = new OMGraphicList();
        OMGraphicList miscs = new OMGraphicList();
        omGraphics.add(cgs);
        omGraphics.add(cib5s);
        omGraphics.add(tlms);
        omGraphics.add(cib10s);
        omGraphics.add(jogs);
        omGraphics.add(miscs);
        omGraphics.add(tpcs);
        omGraphics.add(oncs);
        omGraphics.add(jncs);
        omGraphics.add(gncs);
        for (RpfCoverageBox box : hemisphereData) {
            OMRect rect = new OMRect(box.nw_lat, box.nw_lon, box.se_lat, box.se_lon, this.currentLineType);
            float scale = RpfProductInfo.get((String)box.chartCode).scale;
            if (scale < 15000.0f) {
                if (colors != null && colors.length >= 1) {
                    rect.setLinePaint(colors[0]);
                    if (fillRects) {
                        rect.setFillPaint(colors[0]);
                    }
                }
                cgs.add(rect);
            } else if (scale == 50000.0f) {
                if (colors != null && colors.length >= 2) {
                    rect.setLinePaint(colors[1]);
                    if (fillRects) {
                        rect.setFillPaint(colors[1]);
                    }
                }
                tlms.add(rect);
            } else if (scale == 250000.0f) {
                if (colors != null && colors.length >= 3) {
                    rect.setLinePaint(colors[2]);
                    if (fillRects) {
                        rect.setFillPaint(colors[2]);
                    }
                }
                jogs.add(rect);
            } else if (scale == 500000.0f) {
                if (colors != null && colors.length >= 4) {
                    rect.setLinePaint(colors[3]);
                    if (fillRects) {
                        rect.setFillPaint(colors[3]);
                    }
                }
                tpcs.add(rect);
            } else if (scale == 1000000.0f) {
                if (colors != null && colors.length >= 5) {
                    rect.setLinePaint(colors[4]);
                    if (fillRects) {
                        rect.setFillPaint(colors[4]);
                    }
                }
                oncs.add(rect);
            } else if (scale == 2000000.0f) {
                if (colors != null && colors.length >= 6) {
                    rect.setLinePaint(colors[5]);
                    if (fillRects) {
                        rect.setFillPaint(colors[5]);
                    }
                }
                jncs.add(rect);
            } else if (scale == 5000000.0f) {
                if (colors != null && colors.length >= 7) {
                    rect.setLinePaint(colors[6]);
                    if (fillRects) {
                        rect.setFillPaint(colors[6]);
                    }
                }
                gncs.add(rect);
            } else if (scale == 66666.0f) {
                if (colors != null && colors.length >= 8) {
                    rect.setLinePaint(colors[7]);
                    if (fillRects) {
                        rect.setFillPaint(colors[7]);
                    }
                }
                cib10s.add(rect);
            } else if (scale == 33333.0f) {
                if (colors != null && colors.length >= 9) {
                    rect.setLinePaint(colors[8]);
                    if (fillRects) {
                        rect.setFillPaint(colors[8]);
                    }
                }
                cib5s.add(rect);
            } else {
                if (scale == -1.0f) continue;
                if (colors != null && colors.length >= 10) {
                    rect.setLinePaint(colors[9]);
                    if (fillRects) {
                        rect.setFillPaint(colors[9]);
                    }
                }
                miscs.add(rect);
            }
            rect.generate(proj);
        }
        return omGraphics;
    }
}

