/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.dted;

import com.bbn.openmap.dataAccess.dted.DTEDFrame;
import com.bbn.openmap.layer.dted.DTEDFrameColorTable;
import com.bbn.openmap.layer.dted.DTEDFrameSubframe;
import com.bbn.openmap.layer.dted.DTEDFrameSubframeInfo;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMRaster;
import com.bbn.openmap.proj.CADRG;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.util.Debug;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class DTEDSubframedFrame
extends DTEDFrame {
    public DTEDFrameColorTable colorTable;
    public DTEDFrameSubframeInfo subframeInfo;
    public int number_horiz_subframes;
    public int number_vert_subframes;
    public DTEDFrameSubframe[][] subframes;

    public DTEDSubframedFrame(String filePath) {
        this(filePath, null, null, false);
    }

    public DTEDSubframedFrame(String filePath, DTEDFrameColorTable cTable, DTEDFrameSubframeInfo info) {
        this(filePath, cTable, info, false);
    }

    public DTEDSubframedFrame(String filePath, boolean readWholeFile) {
        this(filePath, null, null, readWholeFile);
    }

    public DTEDSubframedFrame(String filePath, DTEDFrameColorTable cTable, DTEDFrameSubframeInfo info, boolean readWholeFile) {
        super(filePath, readWholeFile);
        this.colorTable = cTable;
        this.subframeInfo = info;
    }

    public void setColorTable(DTEDFrameColorTable c_Table) {
        this.colorTable = c_Table;
    }

    public DTEDFrameColorTable getColorTable() {
        return this.colorTable;
    }

    public void initSubframes(int numHorizSubframes, int numVertSubframes) {
        this.number_horiz_subframes = numHorizSubframes;
        this.number_vert_subframes = numVertSubframes;
        this.subframes = new DTEDFrameSubframe[numHorizSubframes][numVertSubframes];
        if (Debug.debugging("dted")) {
            Debug.output("///////// DTEDFrame: subframe array initialized, " + numHorizSubframes + "x" + numVertSubframes);
        }
    }

    public OMGraphic getImage(Projection proj) {
        return this.getImage(null, null, proj);
    }

    public OMGraphic getImage(DTEDFrameSubframeInfo dfsi, DTEDFrameColorTable colortable, Projection proj) {
        if (proj == null) {
            Debug.error("DTEDFrame.getOMRaster: need projection to create image.");
            return null;
        }
        if (colortable == null) {
            colortable = new DTEDFrameColorTable();
        }
        if (dfsi == null) {
            dfsi = new DTEDFrameSubframeInfo(5, 25, 1, 3);
        }
        CADRG cadrg = CADRG.convertProjection(proj);
        dfsi.xPixInterval = 360.0 / cadrg.getXPixConstant();
        dfsi.yPixInterval = 90.0 / cadrg.getYPixConstant();
        dfsi.height = (int)(1.0 / dfsi.yPixInterval);
        dfsi.width = (int)(1.0 / dfsi.xPixInterval);
        this.subframes = null;
        return this.getSubframeImage(dfsi, colortable, proj);
    }

    public OMGraphic getSubframeImage(DTEDFrameSubframeInfo dfsi, DTEDFrameColorTable colortable, Projection proj) {
        if (!this.frame_is_valid) {
            return null;
        }
        OMGraphic raster = null;
        if (dfsi.viewType == 0) {
            return null;
        }
        if (dfsi.viewType == 5) {
            colortable.setGreyScale(false);
        } else {
            colortable.setGreyScale(true);
        }
        float lat_origin = dfsi.lat;
        float lon_origin = dfsi.lon;
        if (this.subframes == null) {
            this.initSubframes(1, 1);
            lat_origin = this.dsi.lat_origin + 1.0f;
            lon_origin = this.dsi.lon_origin;
        }
        DTEDFrameSubframe subframe = this.subframes[dfsi.subx][dfsi.suby];
        if (Debug.debugging("dteddetail")) {
            Debug.output("Subframe lat/lon => lat= " + lat_origin + " vs. " + dfsi.lat + " lon= " + lon_origin + " vs. " + dfsi.lon + " subx = " + dfsi.subx + " suby = " + dfsi.suby);
            Debug.output("Height/width of subframe => height= " + dfsi.height + " width= " + dfsi.width);
        }
        if (subframe != null) {
            raster = subframe.getImageIfCurrent(proj, dfsi);
            if (raster != null) {
                if (Debug.debugging("dted")) {
                    Debug.output("######## DTEDFrame: returning cached subframe");
                }
                return raster;
            }
            if (Debug.debugging("dted")) {
                Debug.output("   *** DTEDFrame: changing image of cached subframe");
            }
            subframe.dfsi = dfsi.makeClone();
        } else {
            if (Debug.debugging("dted")) {
                Debug.output("   +++ DTEDFrame: creating subframe");
            }
            this.subframes[dfsi.subx][dfsi.suby] = subframe = new DTEDFrameSubframe(dfsi);
        }
        double start_lat_index = ((double)lat_origin - (double)this.dsi.sw_lat) * 36000.0 / (double)this.uhl.lat_post_interval;
        double start_lon_index = ((double)lon_origin - (double)this.dsi.sw_lon) * 36000.0 / (double)this.uhl.lon_post_interval;
        double end_lat_index = ((double)lat_origin - (double)dfsi.height * dfsi.yPixInterval - (double)this.dsi.sw_lat) * 36000.0 / (double)this.uhl.lat_post_interval;
        double end_lon_index = ((double)lon_origin + (double)dfsi.width * dfsi.xPixInterval - (double)this.dsi.sw_lon) * 36000.0 / (double)this.uhl.lon_post_interval;
        double lat_interval = (start_lat_index - end_lat_index) / (double)dfsi.height;
        double lon_interval = (end_lon_index - start_lon_index) / (double)dfsi.width;
        if (Debug.debugging("dteddetail")) {
            Debug.output("  start_lat_index => " + start_lat_index + "\n" + "  end_lat_index => " + end_lat_index + "\n" + "  start_lon_index => " + start_lon_index + "\n" + "  end_lon_index => " + end_lon_index + "\n" + "  lat_interval => " + lat_interval + "\n" + "  lon_interval => " + lon_interval);
        }
        short xc = 0;
        short yc = 0;
        short xnw = 0;
        short ynw = 0;
        short xse = 0;
        short yse = 0;
        double distance = 1.0;
        float value = 0.0f;
        int assignment = 0;
        double modifier = 0.0;
        double xw_offset = 0.0;
        double xe_offset = 0.0;
        double yn_offset = 0.0;
        double ys_offset = 0.0;
        int elevation = 0;
        if (dfsi.viewType == 1 || dfsi.viewType == 5 && colortable.colors.length > 16) {
            xw_offset = start_lon_index - Math.ceil(lon_interval);
            xe_offset = start_lon_index + Math.ceil(lon_interval);
            yn_offset = start_lat_index + Math.ceil(lat_interval);
            ys_offset = start_lat_index - Math.ceil(lat_interval);
            switch (dfsi.dtedLevel) {
                case 0: {
                    modifier = 4.0;
                    break;
                }
                case 1: {
                    modifier = 0.02;
                    break;
                }
                case 2: {
                    modifier = 1.0E-4;
                    break;
                }
                case 3: {
                    modifier = 1.0E-6;
                    break;
                }
                default: {
                    modifier = 1.0;
                }
            }
            if (colortable.colors.length > 215) {
                modifier /= 10.0;
            }
            for (int h = dfsi.slopeAdjust; h < 5; ++h) {
                modifier *= 10.0;
            }
            distance = Math.sqrt(modifier * lon_interval * lon_interval + modifier * lat_interval * lat_interval);
        }
        ImageData imageData = ImageData.getImageData(dfsi.colorModel, dfsi.width, dfsi.height, colortable.colors);
        for (short x = 0; x < dfsi.width; x = (short)((short)(x + 1))) {
            xc = (short)(start_lon_index + (double)x * lon_interval);
            if (xc < 0) {
                xc = 0;
            }
            if (xc > this.dsi.num_lon_points - 1) {
                xc = (short)(this.dsi.num_lon_points - 1);
            }
            if (this.elevations[xc] == null && !this.readDataRecord(xc)) {
                Debug.error("DTEDFrame: Problem reading lat point line in data record");
                return null;
            }
            if (dfsi.viewType == 1 || dfsi.viewType == 5 && colortable.colors.length > 16) {
                xnw = (short)(xw_offset + Math.floor((double)x * lon_interval));
                xse = (short)(xe_offset + Math.floor((double)x * lon_interval));
                if (xc == 0 || xnw < 0) {
                    xnw = xc;
                    xse = (short)((double)xnw + 2.0 * Math.ceil(lon_interval));
                }
                if (xc == this.dsi.num_lon_points - 1 || xse > this.dsi.num_lon_points - 1) {
                    xse = (short)(this.dsi.num_lon_points - 1);
                    xnw = (short)((double)xse - 2.0 * Math.ceil(lon_interval));
                }
                if (this.elevations[xnw] == null && !this.readDataRecord(xnw) || this.elevations[xse] == null && !this.readDataRecord(xse)) {
                    Debug.error("DTEDFrame: Problem reading lat point line in data record");
                    return null;
                }
            }
            for (short y = 0; y < dfsi.height; y = (short)(y + 1)) {
                yc = (short)(start_lat_index - (double)y * lat_interval);
                if (yc < 0) {
                    yc = 0;
                }
                elevation = this.elevations[xc][yc];
                if (dfsi.viewType == 2 || dfsi.viewType == 3) {
                    if (elevation == 0) {
                        assignment = 0;
                    } else {
                        if (elevation < 0) {
                            elevation *= -1;
                        }
                        if (dfsi.viewType == 3) {
                            elevation = (int)((double)elevation * 3.2);
                        }
                        if (colortable.colors.length < 216) {
                            try {
                                assignment = elevation / dfsi.bandHeight % (colortable.colors.length - 6) + 6;
                            }
                            catch (ArithmeticException ae) {
                                assignment = 1;
                            }
                        } else {
                            try {
                                assignment = elevation / dfsi.bandHeight % (10 - 2 * (3 - dfsi.slopeAdjust)) * (colortable.colors.length / (10 - 2 * (3 - dfsi.slopeAdjust))) + 6;
                            }
                            catch (ArithmeticException ae) {
                                assignment = 1;
                            }
                        }
                    }
                    imageData.set(x, y, assignment);
                    continue;
                }
                if (dfsi.viewType == 1 || dfsi.viewType == 5 && colortable.colors.length > 16) {
                    ynw = (short)(yn_offset - Math.floor((double)y * lat_interval));
                    yse = (short)(ys_offset - Math.floor((double)y * lat_interval));
                    if (yse < 0) {
                        yse = 0;
                    }
                    if (yc == this.dsi.num_lat_lines - 1 || ynw > this.dsi.num_lat_lines - 1) {
                        ynw = (short)(this.dsi.num_lat_lines - 1);
                    }
                    short e2 = this.elevations[xse][yse];
                    short e1 = this.elevations[xnw][ynw];
                    double slope = (double)(e2 - e1) / distance;
                    if (dfsi.viewType == 5) {
                        assignment = 1;
                        elevation = (int)((double)elevation * 3.2);
                        for (int l = 1; l < 16; ++l) {
                            if (elevation > colortable.elevation_color_cutoff[l]) continue;
                            if (slope < 0.0) {
                                assignment = l + 16;
                                break;
                            }
                            if (slope > 0.0) {
                                assignment = l + 32;
                                break;
                            }
                            assignment = l;
                            break;
                        }
                        if (elevation == 0) {
                            assignment = 0;
                        }
                        imageData.set(x, y, assignment);
                        continue;
                    }
                    value = (float)((double)((colortable.colors.length - 1) / 2) + slope);
                    if (slope != 0.0 && value < 1.0f) {
                        value = 1.0f;
                    }
                    if (elevation == 0) {
                        value = 0.0f;
                    }
                    if (value > (float)(colortable.colors.length - 1)) {
                        value = colortable.colors.length - 1;
                    }
                    assignment = (int)value;
                    imageData.set(x, y, assignment);
                    continue;
                }
                if (dfsi.viewType == 4) {
                    int c = x < 1 ? 1 : (x > dfsi.width - 2 ? 12 : (y < 1 ? 1 : (y > dfsi.height - 2 ? 12 : 7)));
                    imageData.set(x, y, c);
                    continue;
                }
                if (dfsi.viewType != 5) continue;
                assignment = 1;
                elevation = (int)((double)elevation * 3.2);
                for (int l = 1; l < 16; ++l) {
                    if (elevation > colortable.elevation_color_cutoff[l]) continue;
                    assignment = l;
                    break;
                }
                if (elevation == 0) {
                    assignment = 0;
                }
                if (elevation < 0) {
                    assignment = 1;
                }
                if (elevation > 33000) {
                    assignment = 1;
                }
                imageData.set(x, y, assignment);
            }
        }
        imageData.updateData(subframe);
        if (Debug.debugging("dteddetail")) {
            Debug.output("DTEDFrame: leaving raster");
        }
        return subframe.getImage(proj);
    }

    public static void main(String[] args) {
        float lon;
        float lat;
        CADRG crg;
        OMGraphic ras;
        Debug.init();
        if (args.length < 1) {
            System.out.println("DTEDFrame:  Need a path/filename");
            System.exit(0);
        }
        System.out.println("DTEDFrame: " + args[0]);
        DTEDSubframedFrame df = new DTEDSubframedFrame(args[0]);
        if (df.frame_is_valid) {
            System.out.println(df.uhl);
            System.out.println(df.dsi);
            System.out.println(df.acc);
        }
        if ((ras = df.getImage(crg = new CADRG(new LatLonPoint.Double(lat = df.dsi.lat_origin + 0.5f, lon = df.dsi.lon_origin + 0.5f), 1500000.0f, 600, 600))) instanceof OMRaster) {
            crg.setHeight(((OMRaster)ras).getHeight());
            crg.setWidth(((OMRaster)ras).getWidth());
        }
        ras.generate(crg);
        Frame window = new Frame(args[0]){

            public void paint(Graphics g) {
                if (ras != null) {
                    ras.render(g);
                }
            }
        };
        window.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        window.setSize(crg.getWidth(), crg.getHeight());
        window.setVisible(true);
        window.repaint();
    }

    protected static abstract class ImageData {
        int width = 0;
        int height = 0;
        Color[] colors;

        protected abstract void set(short var1, short var2, int var3);

        protected abstract void updateData(DTEDFrameSubframe var1);

        protected ImageData(int w, int h, Color[] colors) {
            this.width = w;
            this.height = h;
            this.colors = colors;
        }

        protected static ImageData getImageData(int colorModel, int width, int height, Color[] colors) {
            if (colorModel == 0) {
                return new Pixel(width, height, colors);
            }
            return new Byte(width, height, colors);
        }

        protected static class Byte
        extends ImageData {
            byte[] bytes;

            protected Byte(int w, int h, Color[] colors) {
                super(w, h, colors);
                this.bytes = new byte[w * h];
            }

            protected void set(short x, short y, int value) {
                this.bytes[y * this.width + x] = (byte)value;
            }

            protected void updateData(DTEDFrameSubframe dfs) {
                dfs.setBitsAndColors(this.bytes, this.colors);
            }
        }

        protected static class Pixel
        extends ImageData {
            int[] pixels;
            int ranColor;

            protected Pixel(int w, int h, Color[] colors) {
                super(w, h, colors);
                this.pixels = new int[w * h];
                int red = (int)(Math.random() * 255.0);
                int green = (int)(Math.random() * 255.0);
                int blue = (int)(Math.random() * 255.0);
                Color color = new Color(red, green, blue);
                this.ranColor = color.getRGB();
            }

            protected void set(short x, short y, int value) {
                this.pixels[y * this.width + x] = this.colors[value].getRGB();
            }

            protected void updateData(DTEDFrameSubframe dfs) {
                dfs.setPixels(this.pixels);
            }
        }
    }
}

