/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.dted;

import com.bbn.openmap.layer.OMGraphicHandlerLayer;
import com.bbn.openmap.layer.dted.DTEDCoverageManager;
import com.bbn.openmap.layer.policy.ListResetPCPolicy;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JPanel;

public class DTEDCoverageLayer
extends OMGraphicHandlerLayer {
    protected String[] paths;
    protected DTEDCoverageManager coverageManager = null;

    public DTEDCoverageLayer() {
        this.setProjectionChangePolicy(new ListResetPCPolicy(this));
    }

    protected void setDefaultValues() {
        this.paths = null;
    }

    public void setProperties(String prefix, Properties properties) {
        super.setProperties(prefix, properties);
        this.setDefaultValues();
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.paths = PropUtils.initPathsFromProperties(properties, prefix + "paths");
    }

    public synchronized OMGraphicList prepare() {
        if (this.isCancelled()) {
            Debug.message("dtedcov", this.getName() + "|DTEDCoverageLayer.prepare(): aborted.");
            return null;
        }
        Debug.message("basic", this.getName() + "|DTEDCoverageLayer.prepare(): doing it");
        Projection projection = this.getProjection();
        if (Debug.debugging("dtedcov")) {
            Debug.output(this.getName() + "|DTEDCoverageLayer.prepare(): " + "calling prepare with projection: " + projection + " ul = " + projection.getUpperLeft() + " lr = " + projection.getLowerRight());
        }
        if (this.coverageManager == null) {
            this.coverageManager = new DTEDCoverageManager(this.paths);
            if (Debug.debugging("dtedcov")) {
                Debug.output(this.getName() + "|DTEDCoverageLayer.prepare(): created DTEDCoverageManager");
            }
        }
        return this.coverageManager.getCoverageRects(projection);
    }

    public Component getGUI() {
        JPanel panel = null;
        if (this.coverageManager != null) {
            panel = new JPanel();
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            panel.setLayout(gridbag);
            Component gui = this.coverageManager.getGUI();
            c.gridx = 0;
            c.fill = 1;
            c.weightx = 1.0;
            c.weighty = 1.0;
            gridbag.setConstraints(gui, c);
            panel.add(gui);
            c.fill = 2;
            c.weighty = 0.0;
            String interString = this.i18n.get(DTEDCoverageManager.class, "reset", "Reset");
            JButton reset = new JButton(interString);
            reset.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    DTEDCoverageLayer.this.coverageManager.clear();
                    DTEDCoverageLayer.this.doPrepare();
                }
            });
            gridbag.setConstraints(reset, c);
            panel.add(reset);
        }
        return panel;
    }

    public String[] getPaths() {
        return this.paths;
    }

    public void setPaths(String[] paths) {
        this.paths = paths;
    }

    public DTEDCoverageManager getCoverageManager() {
        return this.coverageManager;
    }

    public void setCoverageManager(DTEDCoverageManager coverageManager) {
        this.coverageManager = coverageManager;
    }
}

