/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.graphicLoader;

import com.bbn.openmap.graphicLoader.GLPoint;
import com.bbn.openmap.omGraphics.OMPoly;
import com.bbn.openmap.proj.GreatCircle;
import com.bbn.openmap.proj.Length;
import com.bbn.openmap.proj.ProjMath;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.util.Debug;
import java.awt.Graphics;

public class PathGLPoint
extends GLPoint {
    double[] pathPoints = null;
    OMPoly poly = null;
    int pathIndex = 0;
    double currentSegDist = 0.0;
    double nextSegOffset = 0.0;
    double rate = Length.METER.toRadians(10000.0f);

    public PathGLPoint(OMPoly path, int radius, boolean isOval) {
        super(0.0, 0.0, radius, isOval);
        this.setPoly(path);
    }

    public void move(float factor) {
        if (!this.stationary) {
            this.moveAlong();
        }
    }

    public double[] getSegmentCoordinates(int currentPathIndex) {
        double[] latlons = new double[4];
        if (this.pathIndex > this.pathPoints.length - 2 || this.pathIndex < 0) {
            this.pathIndex = 0;
        }
        if (this.pathPoints.length >= 4) {
            int la1 = this.pathIndex;
            int lo1 = this.pathIndex + 1;
            int la2 = this.pathIndex + 2;
            int lo2 = this.pathIndex + 3;
            if (lo2 >= this.pathPoints.length) {
                if (this.poly.isPolygon()) {
                    Debug.message("graphicloader", "PathGLPoint.moveAlong(): index to big, wrapping... ");
                    la2 = 0;
                    lo2 = 1;
                } else {
                    this.pathIndex = 0;
                    Debug.message("graphicloader", "PathGLPoint.moveAlong(): index to big, no wrapping, starting over... ");
                    return this.getSegmentCoordinates(this.pathIndex);
                }
            }
            latlons[0] = this.pathPoints[la1];
            latlons[1] = this.pathPoints[lo1];
            latlons[2] = this.pathPoints[la2];
            latlons[3] = this.pathPoints[lo2];
        }
        return latlons;
    }

    public void moveAlong() {
        if (Debug.debugging("graphicloader")) {
            Debug.output("PathGLPoint.moveAlong(): segment " + this.pathIndex / 2 + " of " + this.pathPoints.length / 2);
        }
        double[] latlons = this.getSegmentCoordinates(this.pathIndex);
        double segLength = GreatCircle.sphericalDistance(latlons[0], latlons[1], latlons[2], latlons[3]);
        if (Debug.debugging("graphicloader")) {
            Debug.output("PathGLPoint.moveAlong(): segment Length " + segLength + ", and already have " + this.currentSegDist + " of it.");
        }
        double needToTravel = this.rate;
        int originalPathIndex = this.pathIndex;
        int loopingTimes = 0;
        while (needToTravel >= segLength - this.currentSegDist) {
            needToTravel -= segLength - this.currentSegDist;
            this.currentSegDist = 0.0;
            this.pathIndex += 2;
            if (Debug.debugging("graphicloader")) {
                Debug.output("PathGLPoint to next segment(" + this.pathIndex / 2 + "), need to travel " + needToTravel);
            }
            latlons = this.getSegmentCoordinates(this.pathIndex);
            if (this.pathIndex == originalPathIndex && ++loopingTimes > 1) {
                Debug.output("PathGLPoint looping on itself, setting to stationary");
                this.setStationary(true);
                return;
            }
            segLength = GreatCircle.sphericalDistance(latlons[0], latlons[1], latlons[2], latlons[3]);
        }
        if (Debug.debugging("graphicloader")) {
            Debug.output("Moving PathGLPoint within current(" + this.pathIndex / 2 + ") segment, segLength: " + segLength + ", ntt: " + needToTravel);
        }
        double azimuth = GreatCircle.sphericalAzimuth(latlons[0], latlons[1], latlons[2], latlons[3]);
        LatLonPoint newPoint = GreatCircle.sphericalBetween(latlons[0], latlons[1], this.currentSegDist + needToTravel, azimuth);
        this.setLat(newPoint.getY());
        this.setLon(newPoint.getX());
        this.currentSegDist = GreatCircle.sphericalDistance(latlons[0], latlons[1], (double)((float)newPoint.getRadLat()), (double)((float)newPoint.getRadLon()));
    }

    public boolean generate(Projection p) {
        boolean ret = super.generate(p);
        if (this.poly != null) {
            this.poly.generate(p);
        }
        return ret;
    }

    public void render(Graphics g) {
        if (this.poly != null) {
            this.poly.render(g);
        }
        super.render(g);
    }

    public void setPoly(OMPoly p) {
        this.poly = p;
        if (this.poly.getRenderType() == 1) {
            this.pathPoints = this.poly.getLatLonArray();
            this.setLat(ProjMath.radToDeg(this.pathPoints[0]));
            this.setLon(ProjMath.radToDeg(this.pathPoints[1]));
            this.setStationary(false);
        } else {
            this.setStationary(true);
        }
    }

    public OMPoly getPoly() {
        return this.poly;
    }
}

