/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.geo;

import com.bbn.openmap.geo.Geo;
import com.bbn.openmap.geo.Intersection;

public interface GeoArray {
    public Geo get(int var1);

    public Geo get(int var1, Geo var2);

    public int getSize();

    public Geo[] toPointArray();

    public double[] toLLDegrees();

    public double[] toLLRadians();

    public boolean equals(int var1, Geo var2);

    public double distance(Geo var1, Geo var2);

    public double area();

    public void closeArray();

    public void removeDups();

    public static class Double
    extends Adapter
    implements Mutable {
        private double[] coords;

        public Double(Geo[] geos) {
            this.coords = new double[geos.length * 3];
            for (int i = 0; i < geos.length; ++i) {
                int loc = i * 3;
                Geo geo = geos[i];
                this.coords[loc] = geo.x();
                this.coords[loc + 1] = geo.y();
                this.coords[loc + 2] = geo.z();
            }
        }

        public Double(GeoArray ga) {
            int size = ga.getSize();
            this.coords = new double[size * 3];
            Geo geo = new Geo();
            for (int i = 0; i < size; ++i) {
                int loc = i * 3;
                ga.get(i, geo);
                this.coords[loc] = geo.x();
                this.coords[loc + 1] = geo.y();
                this.coords[loc + 2] = geo.z();
            }
        }

        protected Double(double[] coords) {
            this.coords = coords;
        }

        public static Double createFromLatLonDegrees(double[] latlondeg) {
            int numCoordSets = latlondeg.length / 2;
            double[] coords = new double[numCoordSets * 3];
            Geo geo = new Geo();
            for (int i = 0; i < numCoordSets; ++i) {
                geo.initialize(latlondeg[i * 2], latlondeg[i * 2 + 1]);
                int loc = i * 3;
                coords[loc] = geo.x();
                coords[loc + 1] = geo.y();
                coords[loc + 2] = geo.z();
            }
            return new Double(coords);
        }

        public static Double createFromLatLonRadians(double[] latlonrad) {
            int numCoordSets = latlonrad.length / 2;
            double[] coords = new double[numCoordSets * 3];
            Geo geo = new Geo();
            for (int i = 0; i < numCoordSets; ++i) {
                geo.initializeRadians(latlonrad[i * 2], latlonrad[i * 2 + 1]);
                int loc = i * 3;
                coords[loc] = geo.x();
                coords[loc + 1] = geo.y();
                coords[loc + 2] = geo.z();
            }
            return new Double(coords);
        }

        public static Double createFromGeoCoords(double[] xyz) {
            return new Double(xyz);
        }

        public int getSize() {
            if (this.coords != null) {
                return this.coords.length / 3;
            }
            return 0;
        }

        public void set(int i, double x, double y, double z) {
            int loc = i * 3;
            this.coords[loc] = x;
            this.coords[loc + 1] = y;
            this.coords[loc + 2] = z;
        }

        public void set(int i, Geo g) {
            this.set(i, g.x(), g.y(), g.z());
        }

        public void set(int i, double lat, double lon, boolean isDegrees) {
            this.set(i, new Geo(lat, lon, isDegrees));
        }

        public Geo get(int i) {
            return this.get(i, new Geo());
        }

        public Geo get(int i, Geo ret) {
            if (ret == null) {
                ret = new Geo();
            }
            int loc = i * 3;
            double x = this.coords[loc];
            double y = this.coords[loc + 1];
            double z = this.coords[loc + 2];
            ret.initialize(x, y, z);
            return ret;
        }

        public boolean equals(int index, Geo comp) {
            int loc = index * 3;
            double x = this.coords[loc];
            double y = this.coords[loc + 1];
            double z = this.coords[loc + 2];
            return x == comp.x() && y == comp.y() && z == comp.z();
        }

        public void closeArray() {
            int l = this.coords.length;
            int i = l - 3;
            if (this.coords[0] != this.coords[i] || this.coords[1] != this.coords[i + 1] || this.coords[2] != this.coords[i + 2]) {
                double[] newCoords = new double[l + 3];
                System.arraycopy(this.coords, 0, newCoords, 0, l);
                newCoords[l] = this.coords[0];
                newCoords[l + 1] = this.coords[1];
                newCoords[l + 2] = this.coords[2];
                this.coords = newCoords;
            }
        }

        public void removeDups() {
            int i;
            Geo[] ga = this.toPointArray();
            Geo[] r = new Geo[ga.length];
            int p = 0;
            for (i = 0; i < ga.length; ++i) {
                if (p != 0 && r[p - 1].equals(ga[i])) continue;
                r[p] = ga[i];
                ++p;
            }
            if (p != ga.length) {
                this.coords = new double[p * 3];
                for (i = 0; i < p; ++i) {
                    int loc = i * 3;
                    Geo geo = r[i];
                    this.coords[loc] = geo.x();
                    this.coords[loc + 1] = geo.y();
                    this.coords[loc + 2] = geo.z();
                }
            }
        }
    }

    public static class Float
    extends Adapter
    implements Mutable {
        private float[] coords;

        public Float(Geo[] geos) {
            this.coords = new float[geos.length * 3];
            for (int i = 0; i < geos.length; ++i) {
                int loc = i * 3;
                Geo geo = geos[i];
                this.coords[loc] = (float)geo.x();
                this.coords[loc + 1] = (float)geo.y();
                this.coords[loc + 2] = (float)geo.z();
            }
        }

        public Float(GeoArray ga) {
            int size = ga.getSize();
            this.coords = new float[size * 3];
            Geo geo = new Geo();
            for (int i = 0; i < size; ++i) {
                int loc = i * 3;
                ga.get(i, geo);
                this.coords[loc] = (float)geo.x();
                this.coords[loc + 1] = (float)geo.y();
                this.coords[loc + 2] = (float)geo.z();
            }
        }

        protected Float(float[] coords) {
            this.coords = coords;
        }

        public static Float createFromLatLonDegrees(float[] latlondeg) {
            int numCoordSets = latlondeg.length / 2;
            float[] coords = new float[numCoordSets * 3];
            Geo geo = new Geo();
            for (int i = 0; i < numCoordSets; ++i) {
                geo.initialize(latlondeg[i * 2], latlondeg[i * 2 + 1]);
                int loc = i * 3;
                coords[loc] = (float)geo.x();
                coords[loc + 1] = (float)geo.y();
                coords[loc + 2] = (float)geo.z();
            }
            return new Float(coords);
        }

        public static Float createFromLatLonDegrees(double[] latlondeg) {
            int numCoordSets = latlondeg.length / 2;
            float[] coords = new float[numCoordSets * 3];
            Geo geo = new Geo();
            for (int i = 0; i < numCoordSets; ++i) {
                geo.initialize(latlondeg[i * 2], latlondeg[i * 2 + 1]);
                int loc = i * 3;
                coords[loc] = (float)geo.x();
                coords[loc + 1] = (float)geo.y();
                coords[loc + 2] = (float)geo.z();
            }
            return new Float(coords);
        }

        public static Float createFromLatLonRadians(float[] latlonrad) {
            int numCoordSets = latlonrad.length / 2;
            float[] coords = new float[numCoordSets * 3];
            Geo geo = new Geo();
            for (int i = 0; i < numCoordSets; ++i) {
                geo.initializeRadians(latlonrad[i * 2], latlonrad[i * 2 + 1]);
                int loc = i * 3;
                coords[loc] = (float)geo.x();
                coords[loc + 1] = (float)geo.y();
                coords[loc + 2] = (float)geo.z();
            }
            return new Float(coords);
        }

        public static Float createFromLatLonRadians(double[] latlonrad) {
            int numCoordSets = latlonrad.length / 2;
            float[] coords = new float[numCoordSets * 3];
            Geo geo = new Geo();
            for (int i = 0; i < numCoordSets; ++i) {
                geo.initializeRadians(latlonrad[i * 2], latlonrad[i * 2 + 1]);
                int loc = i * 3;
                coords[loc] = (float)geo.x();
                coords[loc + 1] = (float)geo.y();
                coords[loc + 2] = (float)geo.z();
            }
            return new Float(coords);
        }

        public static Float createFromGeoCoords(float[] xyz) {
            return new Float(xyz);
        }

        public int getSize() {
            if (this.coords != null) {
                return this.coords.length / 3;
            }
            return 0;
        }

        public void set(int i, double x, double y, double z) {
            int loc = i * 3;
            this.coords[loc] = (float)x;
            this.coords[loc + 1] = (float)y;
            this.coords[loc + 2] = (float)z;
        }

        public void set(int i, Geo g) {
            this.set(i, g.x(), g.y(), g.z());
        }

        public void set(int i, double lat, double lon, boolean isDegrees) {
            this.set(i, new Geo(lat, lon, isDegrees));
        }

        public Geo get(int i) {
            return this.get(i, new Geo());
        }

        public Geo get(int i, Geo ret) {
            int loc = i * 3;
            double x = this.coords[loc];
            double y = this.coords[loc + 1];
            double z = this.coords[loc + 2];
            ret.initialize(x, y, z);
            return ret;
        }

        public boolean equals(int index, Geo comp) {
            int loc = index * 3;
            double x = this.coords[loc];
            double y = this.coords[loc + 1];
            double z = this.coords[loc + 2];
            return x == comp.x() && y == comp.y() && z == comp.z();
        }

        public void closeArray() {
            int l = this.coords.length;
            int i = l - 3;
            if (this.coords[0] != this.coords[i] || this.coords[1] != this.coords[i + 1] || this.coords[2] != this.coords[i + 2]) {
                float[] newCoords = new float[l + 3];
                System.arraycopy(this.coords, 0, newCoords, 0, l);
                newCoords[l] = this.coords[0];
                newCoords[l + 1] = this.coords[1];
                newCoords[l + 2] = this.coords[2];
                this.coords = newCoords;
            }
        }

        public void removeDups() {
            int i;
            Geo[] ga = this.toPointArray();
            Geo[] r = new Geo[ga.length];
            int p = 0;
            for (i = 0; i < ga.length; ++i) {
                if (p != 0 && r[p - 1].equals(ga[i])) continue;
                r[p] = ga[i];
                ++p;
            }
            if (p != ga.length) {
                this.coords = new float[p * 3];
                for (i = 0; i < p; ++i) {
                    int loc = i * 3;
                    Geo geo = r[i];
                    this.coords[loc] = (float)geo.x();
                    this.coords[loc + 1] = (float)geo.y();
                    this.coords[loc + 2] = (float)geo.z();
                }
            }
        }
    }

    public static abstract class Adapter
    implements GeoArray {
        public Geo[] toPointArray() {
            int size = this.getSize();
            Geo[] geos = new Geo[size];
            for (int i = 0; i < size; ++i) {
                geos[i] = this.get(i, new Geo());
            }
            return geos;
        }

        public double[] toLLDegrees() {
            int size = this.getSize();
            double[] coords = new double[size * 2];
            Geo storage = new Geo();
            for (int i = 0; i < size; ++i) {
                this.get(i, storage);
                int loc = i * 2;
                coords[loc] = storage.getLatitude();
                coords[loc + 1] = storage.getLongitude();
            }
            return coords;
        }

        public double[] toLLRadians() {
            int size = this.getSize();
            double[] coords = new double[size * 2];
            Geo storage = new Geo();
            for (int i = 0; i < size; ++i) {
                this.get(i, storage);
                int loc = i * 2;
                coords[loc] = storage.getLatitudeRadians();
                coords[loc + 1] = storage.getLongitudeRadians();
            }
            return coords;
        }

        public double area() {
            int count = 0;
            double area = 0.0;
            Geo v0 = this.get(0, new Geo());
            Geo v1 = this.get(1, new Geo());
            Geo p0 = new Geo(v0);
            Geo p1 = new Geo(v1);
            Geo p2 = this.get(this.getSize() - 1, new Geo());
            boolean closed = p0.equals(p2);
            int size = this.getSize() - (closed ? 1 : 0);
            for (int i = 2; i < size; ++i) {
                ++count;
                this.get(i, p2);
                area += Geo.angle(p0, p1, p2);
                p0.initialize(p1);
                p1.initialize(p2);
            }
            ++count;
            p2.initialize(v0);
            area += Geo.angle(p0, p1, p2);
            p0.initialize(p1);
            p1.initialize(p2);
            p2.initialize(v1);
            return (area += Geo.angle(p0, p1, p2)) - (double)(++count - 2) * Math.PI;
        }

        public double distance(Geo pnt, Geo closestPoint) {
            double ret;
            double testDist = ret = java.lang.Double.POSITIVE_INFINITY;
            int size = this.getSize();
            Geo p0 = this.get(0, new Geo());
            Geo p1 = new Geo();
            Geo intersect = new Geo();
            for (int i = 1; i < size; ++i) {
                this.get(i, p1);
                if (p0.equals(p1)) continue;
                testDist = Intersection.pointCircleDistance(p0, p1, pnt);
                System.out.println("testing " + p0 + ", " + p1 + ", getting distance of " + testDist);
                if (testDist < ret) {
                    intersect = p0.intersect(p1, pnt, intersect);
                    System.out.println("candidate received, gc intersected at " + intersect);
                    if (Intersection.isOnSegment(p0, p1, intersect)) {
                        ret = testDist;
                        if (closestPoint != null) {
                            closestPoint.initialize(intersect);
                        }
                    }
                }
                p0.initialize(p1);
            }
            return ret;
        }
    }

    public static interface Mutable
    extends GeoArray {
        public void set(int var1, Geo var2);

        public void set(int var1, double var2, double var4, double var6);

        public void set(int var1, double var2, double var4, boolean var6);
    }
}

