/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.event;

import com.bbn.openmap.MapBean;
import com.bbn.openmap.event.CoordMouseMode;
import com.bbn.openmap.omGraphics.OMCircle;
import com.bbn.openmap.omGraphics.OMPoint;
import com.bbn.openmap.omGraphics.OMText;
import com.bbn.openmap.proj.GreatCircle;
import com.bbn.openmap.proj.ProjMath;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.util.PropUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.text.Format;
import java.util.Properties;

public class RangeRingsMouseMode
extends CoordMouseMode {
    private static final long serialVersionUID = 6208201699394207932L;
    public static final transient String modeID = "RangeRings";
    public static final String NUM_RINGS_PROPERTY = "numRings";
    public transient DecimalFormat df = new DecimalFormat("0.###");
    protected Format distanceFormat;
    protected int numRings = 3;
    protected LatLonPoint origin = null;
    protected LatLonPoint intermediateDest = null;
    protected LatLonPoint destination = null;
    protected MapBean mapBean;

    public RangeRingsMouseMode() {
        this(true);
    }

    public RangeRingsMouseMode(boolean shouldConsumeEvents) {
        super(modeID, shouldConsumeEvents);
        this.init();
    }

    public RangeRingsMouseMode(String name, boolean shouldConsumeEvents) {
        super(name, shouldConsumeEvents);
        this.init();
    }

    protected void init() {
        this.setModeCursor(Cursor.getPredefinedCursor(1));
    }

    public MapBean getMapBean() {
        return this.mapBean;
    }

    public void setMapBean(MapBean aMap) {
        this.mapBean = aMap;
    }

    public Format getDistanceFormat() {
        return this.distanceFormat;
    }

    public void setDistanceFormat(Format distanceFormat) {
        this.distanceFormat = distanceFormat;
        this.redraw();
    }

    public int getNumRings() {
        return this.numRings;
    }

    public void setNumRings(int numRings) {
        this.numRings = numRings;
        this.redraw();
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getSource() instanceof MapBean) {
            this.setMapBean((MapBean)e.getSource());
            if (e.getClickCount() >= 2) {
                this.cleanUp();
                this.redraw();
            }
        }
    }

    public void mousePressed(MouseEvent e) {
        e.getComponent().requestFocus();
    }

    public void mouseReleased(MouseEvent e) {
        if (e.getComponent().hasFocus() && e.getSource() instanceof MapBean) {
            this.setMapBean((MapBean)e.getSource());
            LatLonPoint pt = this.getMapBean().getProjection().inverse(e.getPoint(), new LatLonPoint.Double());
            if (this.origin == null || this.origin != null && this.destination != null) {
                this.cleanUp();
                this.redraw();
                this.origin = pt;
                this.destination = null;
                this.startUp();
            } else {
                this.destination = pt;
                this.finished();
            }
            this.redraw();
        }
    }

    public void mouseMoved(MouseEvent e) {
        if (e.getSource() instanceof MapBean) {
            this.setMapBean((MapBean)e.getSource());
            if (this.origin != null) {
                this.intermediateDest = this.getMapBean().getProjection().inverse(e.getPoint(), new LatLonPoint.Double());
                this.fireMouseLocation(e);
                this.update();
                this.redraw();
            } else {
                this.fireMouseLocation(e);
            }
        }
    }

    public void mouseEntered(MouseEvent e) {
        if (e.getSource() instanceof MapBean) {
            this.setMapBean((MapBean)e.getSource());
        }
    }

    public void redraw() {
        MapBean mb = this.getMapBean();
        if (mb != null) {
            mb.repaint();
        }
    }

    public void listenerPaint(Graphics g) {
        if (this.origin != null) {
            this.paintOrigin(g);
            if (this.destination != null) {
                this.paintRangeRings(this.destination, g);
            } else if (this.intermediateDest != null) {
                this.paintRangeRings(this.intermediateDest, g);
            }
        }
    }

    protected void paintOrigin() {
        MapBean mb = this.getMapBean();
        if (mb != null) {
            Graphics g = mb.getGraphics(true);
            this.paintOrigin(g);
        }
    }

    protected void paintOrigin(Graphics graphics) {
        MapBean mb = this.getMapBean();
        if (mb == null) {
            return;
        }
        this.paintOriginPoint(graphics);
        this.paintOriginLabel(graphics);
    }

    protected void paintOriginPoint(Graphics graphics) {
        MapBean mb = this.getMapBean();
        Projection proj = mb.getProjection();
        OMPoint pt = new OMPoint((float)this.origin.getY(), (float)this.origin.getX());
        Graphics2D g = (Graphics2D)graphics;
        g.setPaintMode();
        g.setColor(Color.BLACK);
        this.preparePoint(pt);
        pt.generate(proj);
        pt.render(g);
    }

    protected void paintOriginLabel(Graphics graphics) {
        MapBean mb = this.getMapBean();
        Projection proj = mb.getProjection();
        Point2D pt = proj.forward(this.origin);
        String infoText = this.getOriginLabel();
        Graphics2D g = (Graphics2D)graphics;
        Rectangle2D r = g.getFontMetrics().getStringBounds(infoText, graphics);
        pt.setLocation(pt.getX() - r.getWidth() / 2.0, pt.getY() - r.getHeight() / 2.0);
        OMText text = new OMText((int)pt.getX(), (int)pt.getY(), infoText, 0);
        g.setPaintMode();
        g.setColor(Color.BLACK);
        this.prepareLabel(text);
        text.generate(proj);
        text.render(g);
    }

    protected void paintRangeRings(LatLonPoint dest) {
        MapBean mb = this.getMapBean();
        if (mb != null) {
            Graphics g = mb.getGraphics(true);
            this.paintRangeRings(dest, g);
        }
    }

    protected void paintRangeRings(LatLonPoint dest, Graphics graphics) {
        MapBean mb = this.getMapBean();
        if (mb == null) {
            return;
        }
        Projection proj = mb.getProjection();
        AffineTransform xyTranslation = this.getTranslation(this.origin, dest, proj);
        LatLonPoint p = null;
        for (int i = 0; i < Math.max(1, this.numRings); ++i) {
            p = p == null ? dest : this.translate(p, xyTranslation, proj);
            this.paintCircle(p, graphics);
            this.paintLabel(p, graphics);
        }
    }

    protected void paintCircle(LatLonPoint dest) {
        MapBean mb = this.getMapBean();
        if (mb != null) {
            Graphics g = mb.getGraphics(true);
            this.paintCircle(dest, g);
        }
    }

    protected void paintCircle(LatLonPoint dest, Graphics graphics) {
        double oLat = this.origin.getY();
        double oLon = this.origin.getX();
        double radphi1 = ProjMath.degToRad(oLat);
        double radlambda0 = ProjMath.degToRad(oLon);
        double radphi = ProjMath.degToRad(dest.getY());
        double radlambda = ProjMath.degToRad(dest.getX());
        double dRad = GreatCircle.sphericalDistance(radphi1, radlambda0, radphi, radlambda);
        float rad = (float)ProjMath.radToDeg(dRad);
        OMCircle circle = new OMCircle((float)oLat, (float)oLon, rad);
        this.prepareCircle(circle);
        Projection proj = this.getMapBean().getProjection();
        circle.generate(proj);
        circle.render(graphics);
    }

    protected void paintLabel(LatLonPoint dest) {
        MapBean mb = this.getMapBean();
        if (mb != null) {
            Graphics g = mb.getGraphics(true);
            this.paintLabel(dest, g);
        }
    }

    protected void paintLabel(LatLonPoint dest, Graphics graphics) {
        String infoText = this.getLabelFor(dest);
        Graphics2D g = (Graphics2D)graphics;
        Rectangle2D r = g.getFontMetrics().getStringBounds(infoText, graphics);
        double th = r.getHeight();
        LatLonPoint.Double llp = new LatLonPoint.Double(this.origin);
        double distance = llp.distance(dest);
        if (((LatLonPoint)llp).getLatitude() > 0.0f) {
            ((LatLonPoint)llp).setLatLon(Math.toRadians(((LatLonPoint)llp).getLatitude()) - distance, Math.toRadians(((LatLonPoint)llp).getLongitude()), true);
        } else {
            ((LatLonPoint)llp).setLatLon(Math.toRadians(((LatLonPoint)llp).getLatitude()) + distance, Math.toRadians(((LatLonPoint)llp).getLongitude()), true);
            th = -th / 2.0;
        }
        Projection proj = this.getMapBean().getProjection();
        Point2D pt = proj.forward(llp);
        pt.setLocation(pt.getX() - r.getWidth() / 2.0, pt.getY() - th);
        OMText text = new OMText((int)pt.getX(), (int)pt.getY(), infoText, 0);
        g.setPaintMode();
        g.setColor(Color.BLACK);
        this.prepareLabel(text);
        text.generate(proj);
        text.render(g);
    }

    protected void preparePoint(OMPoint point) {
    }

    protected void prepareCircle(OMCircle circle) {
    }

    protected void prepareLabel(OMText text) {
        text.setLinePaint(Color.BLACK);
        text.setTextMatteColor(this.getMapBean().getBackground());
        text.setTextMatteStroke(new BasicStroke(4.0f));
    }

    protected String getOriginLabel() {
        return "(" + this.df.format(this.origin.getY()) + ", " + this.df.format(this.origin.getX()) + ")";
    }

    protected String getLabelFor(LatLonPoint dest) {
        Format distFormat = this.getDistanceFormat();
        double distance = this.origin.distance(dest);
        if (distFormat == null) {
            return Double.toString(distance);
        }
        return distFormat.format(new Double(distance));
    }

    protected void startUp() {
    }

    protected void update() {
    }

    protected void finished() {
    }

    protected void cleanUp() {
        this.origin = null;
        this.intermediateDest = null;
        this.destination = null;
    }

    private AffineTransform getTranslation(LatLonPoint pt1, LatLonPoint pt2, Projection proj) {
        Point2D p1 = proj.forward(pt1);
        Point2D p2 = proj.forward(pt2);
        return AffineTransform.getTranslateInstance(p2.getX() - p1.getX(), p2.getY() - p1.getY());
    }

    private LatLonPoint translate(LatLonPoint pt, AffineTransform xyTranslation, Projection proj) {
        Point2D p = proj.forward(pt);
        xyTranslation.transform(p, p);
        return proj.inverse(p, new LatLonPoint.Double());
    }

    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.numRings = PropUtils.intFromProperties(props, prefix + NUM_RINGS_PROPERTY, this.numRings);
    }

    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        String prefix = PropUtils.getScopedPropertyPrefix(this.getPropertyPrefix());
        props.setProperty(prefix + NUM_RINGS_PROPERTY, Integer.toString(this.numRings));
        return props;
    }

    public Properties getPropertyInfo(Properties list) {
        list = super.getPropertyInfo(list);
        list.setProperty(NUM_RINGS_PROPERTY, "Number of range rings to be drawn (minimum=1; default=3).");
        return list;
    }
}

