/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.util;

import com.bbn.openmap.util.HashCodeUtil;
import java.awt.geom.Point2D;

public class DataBounds {
    protected Point2D min;
    protected Point2D max;
    protected DataBounds hardLimits;
    boolean yDirUp = true;

    public DataBounds() {
    }

    public DataBounds(double minx, double miny, double maxx, double maxy) {
        this.add(minx, miny);
        this.add(maxx, maxy);
    }

    public DataBounds(Point2D minP, Point2D maxP) {
        this.add(minP);
        this.add(maxP);
    }

    public Point2D getCenter() {
        if (this.min != null) {
            double minx = this.min.getX();
            double miny = this.min.getY();
            double maxx = this.max.getX();
            double maxy = this.max.getY();
            return new Point2D.Double((minx + maxx) / 2.0, (miny + maxy) / 2.0);
        }
        return null;
    }

    public String toString() {
        return "DataBounds| min:" + this.min + " max:" + this.max;
    }

    public Point2D getMax() {
        return this.max;
    }

    public Point2D getMin() {
        return this.min;
    }

    public void add(double x, double y) {
        if (this.min == null) {
            this.min = new Point2D.Double(x, y);
            this.max = new Point2D.Double(x, y);
        } else {
            double minx = this.min.getX();
            double miny = this.min.getY();
            double maxx = this.max.getX();
            double maxy = this.max.getY();
            if (minx > x) {
                minx = x;
            }
            if (miny > y) {
                miny = y;
            }
            if (maxx < x) {
                maxx = x;
            }
            if (maxy < y) {
                maxy = y;
            }
            if (this.hardLimits != null) {
                double hlminx = this.hardLimits.min.getX();
                double hlminy = this.hardLimits.min.getY();
                double hlmaxx = this.hardLimits.max.getX();
                double hlmaxy = this.hardLimits.max.getY();
                minx = this.setInRange(hlmaxx, hlminx, minx);
                maxx = this.setInRange(hlmaxx, hlminx, maxx);
                miny = this.setInRange(hlmaxy, hlminy, miny);
                maxy = this.setInRange(hlmaxy, hlminy, maxy);
            }
            this.min.setLocation(minx, miny);
            this.max.setLocation(maxx, maxy);
        }
    }

    protected double setInRange(double hi, double lo, double val) {
        if (val > hi) {
            val = hi;
        }
        if (val < lo) {
            val = lo;
        }
        return val;
    }

    public void add(Point2D point) {
        this.add(point.getX(), point.getY());
    }

    public boolean contains(Point2D query) {
        double x = query.getX();
        double y = query.getY();
        return x + 1.0 >= this.min.getX() && x - 1.0 <= this.max.getX() && y + 1.0 >= this.min.getY() && y - 1.0 <= this.max.getY();
    }

    public double getWidth() {
        return this.max.getX() - this.min.getX();
    }

    public double getHeight() {
        return this.max.getY() - this.min.getY();
    }

    public DataBounds getHardLimits() {
        return this.hardLimits;
    }

    public void setHardLimits(DataBounds hardLimits) {
        this.hardLimits = hardLimits;
    }

    public boolean isyDirUp() {
        return this.yDirUp;
    }

    public void setyDirUp(boolean yDirUp) {
        this.yDirUp = yDirUp;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DataBounds) {
            DataBounds dobj = (DataBounds)obj;
            boolean match = this.min == null && dobj.getMin() == null && this.max == null && dobj.getMax() == null;
            boolean match2 = false;
            try {
                match2 = this.getMin().equals(dobj.getMin()) && this.getMax().equals(dobj.getMax());
            }
            catch (NullPointerException npe) {
                // empty catch block
            }
            return this.yDirUp == dobj.yDirUp && (match || match2);
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        if (this.max != null) {
            result = HashCodeUtil.hash(result, this.max.getY());
            result = HashCodeUtil.hash(result, this.max.getX());
        }
        if (this.min != null) {
            result = HashCodeUtil.hash(result, this.min.getY());
            result = HashCodeUtil.hash(result, this.min.getX());
        }
        result = HashCodeUtil.hash(result, this.yDirUp);
        return result;
    }
}

