/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.util;

import com.bbn.openmap.util.Tokenizer;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Reader;

public class CSVTokenizer
extends Tokenizer {
    boolean numberReadAsString = false;
    protected Object lastTokened = NEWLINE;

    public CSVTokenizer(Reader in) {
        super(in);
    }

    public CSVTokenizer(Reader in, boolean numberReadAsString) {
        super(in);
        this.numberReadAsString = numberReadAsString;
    }

    public Object token() {
        int c = this.next();
        Object ret = null;
        if (c == 44) {
            if (this.lastTokened == NEWLINE) {
                this.putback(c);
                ret = EMPTY;
            } else {
                ret = this.tokenAfterComma();
            }
        } else {
            ret = c == 10 ? NEWLINE : (c == 34 ? this.tokenString(this.next()) : (c == 92 ? this.tokenString(c) : ((c == 45 || c == 46 || this.isDigit(c)) && !this.numberReadAsString ? this.tokenNumber(c) : (c == -1 ? EOF : this.tokenAny(c)))));
        }
        this.lastTokened = ret;
        return ret;
    }

    protected Object tokenAfterComma() {
        int c = this.next();
        if (c == 44 || c == 10) {
            this.putback(c);
            return EMPTY;
        }
        if (c == 34) {
            return this.tokenString(this.next());
        }
        if (c == 92) {
            return this.tokenString(c);
        }
        if ((c == 45 || c == 46 || this.isDigit(c)) && !this.numberReadAsString) {
            return this.tokenNumber(c);
        }
        if (c == -1) {
            return EOF;
        }
        return this.tokenAny(c);
    }

    Object tokenString(int c) {
        while (true) {
            if (c == 92) {
                this.bpush(this.next());
                c = this.next();
                continue;
            }
            if (c == 34) {
                c = this.next();
                if (!this.isDelimiter(c)) continue;
                return this.bclear();
            }
            if (!this.isAny(c)) break;
            this.bpush(c);
            c = this.next();
        }
        return this.bclear();
    }

    boolean isDelimiter(int c) {
        if (c == 44 || c == -1 || c == 10) {
            this.putback(c);
            return true;
        }
        return false;
    }

    Object tokenNumber(int c) {
        Object result = this.tokenAny(c);
        try {
            Double d = new Double((String)result);
            return d;
        }
        catch (NumberFormatException e) {
            return result;
        }
    }

    Object tokenAny(int c) {
        while (!this.isDelimiter(c)) {
            this.bpush(c);
            c = this.next();
        }
        return this.bclear();
    }

    public static void main(String[] args) {
        try {
            CSVTokenizer csv = new CSVTokenizer(new BufferedReader(new FileReader(args[0])));
            while (true) {
                Object token;
                if (csv.isEOF(token = csv.token())) {
                    return;
                }
                System.out.println(token);
            }
        }
        catch (Exception e) {
            System.out.println(e);
            return;
        }
    }
}

