/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.proj.coords;

import com.bbn.openmap.MoreMath;
import com.bbn.openmap.proj.GreatCircle;
import com.bbn.openmap.proj.ProjMath;
import java.awt.geom.Point2D;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public abstract class LatLonPoint
extends Point2D
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 4416029542303298672L;
    public static final double NORTH_POLE = 90.0;
    public static final double SOUTH_POLE = -90.0;
    public static final double DATELINE = 180.0;
    public static final double LON_RANGE = 360.0;
    public static final double EQUIVALENT_TOLERANCE = 1.0E-5;

    protected LatLonPoint() {
    }

    public static LatLonPoint getFloat(Point2D pt2D) {
        if (pt2D instanceof Float) {
            return (Float)pt2D;
        }
        return new Float(pt2D);
    }

    public static LatLonPoint getDouble(Point2D pt2D) {
        if (pt2D instanceof Double) {
            return (Double)pt2D;
        }
        return new Double(pt2D);
    }

    public abstract void setLatLon(double var1, double var3);

    public abstract void setLatLon(double var1, double var3, boolean var5);

    public abstract float getLongitude();

    public abstract float getLatitude();

    public abstract double getRadLon();

    public abstract double getRadLat();

    public abstract void setLatitude(double var1);

    public abstract void setLongitude(double var1);

    public void setLatLon(LatLonPoint llp) {
        this.setLatLon(llp.getY(), llp.getX(), false);
    }

    public static final float normalizeLatitude(float lat) {
        return (float)LatLonPoint.normalizeLatitude((double)lat);
    }

    public static final double normalizeLatitude(double lat) {
        if (lat > 90.0) {
            lat = 90.0;
        }
        if (lat < -90.0) {
            lat = -90.0;
        }
        return lat;
    }

    public static final float wrapLongitude(float lon) {
        return (float)LatLonPoint.wrapLongitude((double)lon);
    }

    public static final double wrapLongitude(double lon) {
        if (lon < -180.0 || lon > 180.0) {
            lon += 180.0;
            lon = (lon %= 360.0) < 0.0 ? 180.0 + lon : -180.0 + lon;
        }
        return lon;
    }

    public static boolean isInvalidLatitude(double lat) {
        return lat > 90.0 || lat < -90.0;
    }

    public static boolean isInvalidLongitude(double lon) {
        return lon < -180.0 || lon > 180.0;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LatLonPoint pt = (LatLonPoint)obj;
        return MoreMath.approximately_equal(this.getY(), pt.getY(), 1.0E-5) && MoreMath.approximately_equal(this.getX(), pt.getX(), 1.0E-5);
    }

    public double distance(LatLonPoint toPoint) {
        return GreatCircle.sphericalDistance(this.getRadLat(), this.getRadLon(), toPoint.getRadLat(), toPoint.getRadLon());
    }

    public double azimuth(LatLonPoint toPoint) {
        return GreatCircle.sphericalAzimuth(this.getRadLat(), this.getRadLon(), toPoint.getRadLat(), toPoint.getRadLon());
    }

    public LatLonPoint getPoint(double distance, double azimuth) {
        return GreatCircle.sphericalBetween(this.getRadLat(), this.getRadLon(), distance, azimuth);
    }

    public static class Double
    extends LatLonPoint {
        private static final long serialVersionUID = -7463055211717523471L;
        protected double lat;
        protected double lon;
        protected transient double radLat;
        protected transient double radLon;

        public Double() {
        }

        public Double(double lat, double lon) {
            this.setLatLon(lat, lon, false);
        }

        public Double(double lat, double lon, boolean isRadian) {
            this.setLatLon(lat, lon, isRadian);
        }

        public Double(LatLonPoint llp) {
            this.setLatLon(llp.getY(), llp.getX(), false);
        }

        public Double(Point2D pt2D) {
            this.setLatLon(pt2D.getY(), pt2D.getX(), false);
        }

        public void setLocation(double x, double y) {
            this.setLatLon(y, x, false);
        }

        public void setLatLon(double lat, double lon) {
            this.setLatLon(lat, lon, false);
        }

        public void setLatLon(double lat, double lon, boolean isRadians) {
            if (isRadians) {
                this.radLat = lat;
                this.radLon = lon;
                this.lat = ProjMath.radToDeg(lat);
                this.lon = ProjMath.radToDeg(lon);
            } else {
                this.lat = Double.normalizeLatitude(lat);
                this.lon = Double.wrapLongitude(lon);
                this.radLat = ProjMath.degToRad(lat);
                this.radLon = ProjMath.degToRad(lon);
            }
        }

        public double getX() {
            return this.lon;
        }

        public double getY() {
            return this.lat;
        }

        public float getLatitude() {
            return (float)this.lat;
        }

        public float getLongitude() {
            return (float)this.lon;
        }

        public double getRadLon() {
            return this.radLon;
        }

        public double getRadLat() {
            return this.radLat;
        }

        public void setLatitude(double lat) {
            this.lat = Double.normalizeLatitude(lat);
            this.radLat = ProjMath.degToRad(lat);
        }

        public void setLongitude(double lon) {
            this.lon = Double.wrapLongitude(lon);
            this.radLon = ProjMath.degToRad(lon);
        }

        public LatLonPoint getPoint(double dist, double az) {
            return GreatCircle.sphericalBetween(this.radLat, this.radLon, dist, az);
        }

        public void write(DataOutputStream s) throws IOException {
            s.writeDouble(this.lat);
            s.writeDouble(this.lon);
        }

        public void read(DataInputStream s) throws IOException {
            this.setLatLon(s.readDouble(), s.readDouble(), false);
        }

        public void read(DataInputStream s, boolean inRadians) throws IOException {
            this.setLatLon(s.readDouble(), s.readDouble(), inRadians);
        }

        private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
            stream.defaultReadObject();
            this.lat = Double.normalizeLatitude(this.lat);
            this.lon = Double.wrapLongitude(this.lon);
            this.radLat = ProjMath.degToRad(this.lat);
            this.radLon = ProjMath.degToRad(this.lon);
        }

        public String toString() {
            return "LatLonPoint.Double[lat=" + this.lat + ",lon=" + this.lon + "]";
        }
    }

    public static class Float
    extends LatLonPoint {
        private static final long serialVersionUID = -2447464428275551182L;
        protected float lat;
        protected float lon;
        protected transient float radLat;
        protected transient float radLon;

        public Float() {
        }

        public Float(float lat, float lon) {
            this.setLatLon(lat, lon, false);
        }

        public Float(float lat, float lon, boolean isRadian) {
            this.setLatLon(lat, lon, isRadian);
        }

        public Float(LatLonPoint llp) {
            this.setLatLon(llp.getLatitude(), llp.getLongitude(), false);
        }

        public Float(Point2D pt2D) {
            this.setLatLon(pt2D.getY(), pt2D.getX(), false);
        }

        public void setLocation(float x, float y) {
            this.setLatLon(y, x, false);
        }

        public void setLocation(double x, double y) {
            this.setLatLon((float)y, (float)x, false);
        }

        public void setLatLon(float lat, float lon) {
            this.setLatLon(lat, lon, false);
        }

        public void setLatLon(double lat, double lon) {
            this.setLatLon((float)lat, (float)lon, false);
        }

        public void setLatLon(double lat, double lon, boolean isRadians) {
            if (isRadians) {
                this.radLat = (float)lat;
                this.radLon = (float)lon;
                this.lat = (float)ProjMath.radToDeg(lat);
                this.lon = (float)ProjMath.radToDeg(lon);
            } else {
                this.lat = (float)Double.normalizeLatitude(lat);
                this.lon = (float)Double.wrapLongitude(lon);
                this.radLat = (float)ProjMath.degToRad(lat);
                this.radLon = (float)ProjMath.degToRad(lon);
            }
        }

        public void setLatLon(float lat, float lon, boolean isRadians) {
            if (isRadians) {
                this.radLat = lat;
                this.radLon = lon;
                this.lat = ProjMath.radToDeg(lat);
                this.lon = ProjMath.radToDeg(lon);
            } else {
                this.lat = Float.normalizeLatitude(lat);
                this.lon = Float.wrapLongitude(lon);
                this.radLat = ProjMath.degToRad(lat);
                this.radLon = ProjMath.degToRad(lon);
            }
        }

        public double getX() {
            return this.lon;
        }

        public double getY() {
            return this.lat;
        }

        public float getLongitude() {
            return this.lon;
        }

        public float getLatitude() {
            return this.lat;
        }

        public double getRadLon() {
            return this.radLon;
        }

        public double getRadLat() {
            return this.radLat;
        }

        public void setLatitude(float lat) {
            this.lat = Float.normalizeLatitude(lat);
            this.radLat = ProjMath.degToRad(lat);
        }

        public void setLatitude(double lat) {
            this.setLatitude((float)lat);
        }

        public void setLongitude(float lon) {
            this.lon = Float.wrapLongitude(lon);
            this.radLon = ProjMath.degToRad(lon);
        }

        public void setLongitude(double lon) {
            this.setLongitude((float)lon);
        }

        public LatLonPoint getPoint(float dist, float az) {
            return GreatCircle.sphericalBetween(this.radLat, this.radLon, dist, az);
        }

        public void write(DataOutputStream s) throws IOException {
            s.writeFloat(this.lat);
            s.writeFloat(this.lon);
        }

        public void read(DataInputStream s) throws IOException {
            this.setLatLon(s.readFloat(), s.readFloat(), false);
        }

        public void read(DataInputStream s, boolean inRadians) throws IOException {
            this.setLatLon(s.readFloat(), s.readFloat(), inRadians);
        }

        private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
            stream.defaultReadObject();
            this.lat = Float.normalizeLatitude(this.lat);
            this.lon = Float.wrapLongitude(this.lon);
            this.radLat = ProjMath.degToRad(this.lat);
            this.radLon = ProjMath.degToRad(this.lon);
        }

        public String toString() {
            return "LatLonPoint.Float[lat=" + this.lat + ",lon=" + this.lon + "]";
        }
    }
}

