/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics.time;

import com.bbn.openmap.omGraphics.time.TemporalRecord;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TemporalSupport {
    public static Logger logger = Logger.getLogger("com.bbn.openmap.omGraphics.time.TemporalSupport");
    protected TreeSet<? extends TemporalRecord> temporals;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends TemporalRecord> T getPosition(long time, boolean interpolate) {
        TemporalRecord previous = null;
        TemporalRecord next = null;
        TreeSet<? extends TemporalRecord> treeSet = this.temporals;
        synchronized (treeSet) {
            Iterator<T> it = this.iterator();
            while (it.hasNext()) {
                TemporalRecord temporal = (TemporalRecord)it.next();
                long recTimeStamp = temporal.getTime();
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("evaluating: " + temporal + " vs " + time);
                }
                if (recTimeStamp < time) {
                    previous = temporal;
                    this.updateForTemporal(time, temporal);
                    continue;
                }
                if (recTimeStamp > time) {
                    next = temporal;
                    break;
                }
                this.updateForTemporal(time, temporal);
                return (T)temporal;
            }
        }
        TemporalRecord pos = null;
        if (previous != null && !interpolate) {
            return (T)previous;
        }
        if (previous == null) {
            if (next != null && logger.isLoggable(Level.FINER)) {
                logger.finer("premature time, invisible: " + next.toString());
            }
        } else {
            pos = next == null ? previous : this.interpolate(time, previous, next);
        }
        return (T)pos;
    }

    protected void updateForTemporal(long time, TemporalRecord temporal) {
    }

    protected TemporalRecord interpolate(long time, TemporalRecord previous, TemporalRecord next) {
        long midTime = previous.getTime() + (next.getTime() - previous.getTime()) / 2L;
        if (time < midTime) {
            return previous;
        }
        return next;
    }

    public <T extends TemporalRecord> TreeSet<T> getTemporals() {
        if (this.temporals == null) {
            this.temporals = this.createTemporalSet();
        }
        return this.temporals;
    }

    public <T extends TemporalRecord> void setTemporals(TreeSet<T> temporals) {
        this.temporals = temporals;
    }

    public abstract <T extends TemporalRecord> TreeSet<T> createTemporalSet();

    public abstract <T extends TemporalRecord> Iterator<T> iterator();

    public void add(TemporalRecord tr) {
        this.getTemporals().add(tr);
    }

    public boolean remove(TemporalRecord tr) {
        return this.getTemporals().remove(tr);
    }

    public void clear() {
        this.temporals.clear();
    }
}

