/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics.geom;

import com.bbn.openmap.omGraphics.OMGeometry;
import com.bbn.openmap.omGraphics.OMGraphicConstants;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BasicGeometry
implements OMGeometry,
Serializable,
OMGraphicConstants {
    protected int lineType = 0;
    protected transient boolean needToRegenerate = true;
    protected Object appObject;
    protected boolean visible = true;
    protected transient GeneralPath shape = null;
    protected static final String APP_OBJECT_KEY = "app_object_key";
    protected static final String ATT_MAP_KEY = "att_map_key";

    @Override
    public void setLineType(int value) {
        if (this.lineType == value) {
            return;
        }
        this.setNeedToRegenerate(true);
        this.lineType = value;
    }

    @Override
    public int getLineType() {
        return this.lineType;
    }

    @Override
    public abstract int getRenderType();

    @Override
    public void setNeedToRegenerate(boolean value) {
        this.needToRegenerate = value;
        if (value) {
            this.shape = null;
        }
    }

    @Override
    public boolean getNeedToRegenerate() {
        return this.needToRegenerate;
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void select() {
    }

    @Override
    public void deselect() {
    }

    @Override
    public synchronized void setAppObject(Object obj) {
        this.setAppObject(obj, true);
    }

    protected synchronized void setAppObject(Object obj, boolean checkToReplaceObjWithMap) {
        if (checkToReplaceObjWithMap && this.checkAttributeMap()) {
            this.putAttribute(APP_OBJECT_KEY, obj);
        } else {
            this.appObject = obj;
        }
    }

    @Override
    public synchronized Object getAppObject() {
        return this.getAppObject(true);
    }

    protected synchronized Object getAppObject(boolean checkForObjOnMap) {
        if (checkForObjOnMap && this.checkAttributeMap()) {
            return this.getAttribute(APP_OBJECT_KEY);
        }
        return this.appObject;
    }

    protected void replaceAppObjectWithAttributeMap() {
        if (!this.checkAttributeMap()) {
            Object appObj = this.getAppObject(false);
            Map<Object, Object> attributes = this.createAttributeMap();
            attributes.put(ATT_MAP_KEY, attributes);
            this.setAppObject(attributes, false);
            if (appObj != null) {
                attributes.put(APP_OBJECT_KEY, appObj);
            }
        }
    }

    protected boolean checkAttributeMap() {
        return this.checkAttributeMap(this.getAppObject(false));
    }

    protected boolean checkAttributeMap(Object obj) {
        return obj instanceof Map && ((Map)obj).get(ATT_MAP_KEY) == obj;
    }

    protected Map<Object, Object> getAttributeMap() {
        this.replaceAppObjectWithAttributeMap();
        return (Map)this.getAppObject(false);
    }

    protected Map<Object, Object> createAttributeMap() {
        return new Hashtable<Object, Object>();
    }

    @Override
    public void putAttribute(Object key, Object value) {
        if (key != null && value != null) {
            this.getAttributeMap().put(key, value);
        }
    }

    @Override
    public Object getAttribute(Object key) {
        Object appObj;
        if (key != null && (appObj = this.getAppObject(false)) instanceof Map) {
            return ((Map)appObj).get(key);
        }
        return null;
    }

    @Override
    public Object removeAttribute(Object key) {
        Object appObj = this.getAppObject(false);
        if (appObj instanceof Map) {
            return ((Map)appObj).remove(key);
        }
        return null;
    }

    @Override
    public void clearAttributes() {
        Object appObj = this.getAppObject(false);
        if (appObj instanceof Map) {
            ((Map)appObj).clear();
        }
    }

    @Override
    public Map<Object, Object> getAttributes() {
        Object appObj = this.getAppObject(false);
        if (this.checkAttributeMap(appObj)) {
            return (Map)appObj;
        }
        return null;
    }

    @Override
    public void setAttributes(Map<Object, Object> atts) {
        if (atts == null) {
            return;
        }
        if (!this.checkAttributeMap()) {
            if (this.appObject != null) {
                atts.put(APP_OBJECT_KEY, this.appObject);
            }
        } else {
            Object appObj = this.getAttribute(APP_OBJECT_KEY);
            if (appObj != null) {
                atts.put(APP_OBJECT_KEY, appObj);
            }
        }
        atts.put(ATT_MAP_KEY, atts);
        this.setAppObject(atts, false);
    }

    @Override
    public String getDescription() {
        String cname = this.getClass().getName();
        int lastPeriod = cname.lastIndexOf(46);
        if (lastPeriod != -1) {
            cname = cname.substring(lastPeriod + 1);
        }
        return cname;
    }

    @Override
    public abstract boolean generate(Projection var1);

    @Override
    public synchronized boolean isRenderable() {
        return !this.getNeedToRegenerate() && this.isVisible() && this.shape != null;
    }

    @Override
    public synchronized void fill(Graphics g) {
        if (this.isRenderable()) {
            ((Graphics2D)g).fill(this.shape);
        }
    }

    @Override
    public synchronized void draw(Graphics g) {
        if (this.isRenderable()) {
            ((Graphics2D)g).draw(this.shape);
        }
    }

    @Override
    public void render(Graphics g) {
        this.fill(g);
        this.draw(g);
    }

    @Override
    public float distanceToEdge(double x, double y) {
        float distance = Float.POSITIVE_INFINITY;
        if (this.getNeedToRegenerate() || this.shape == null) {
            return distance;
        }
        PathIterator pi2 = this.shape.getPathIterator(null);
        FlatteningPathIterator pi = new FlatteningPathIterator(pi2, 0.25);
        double[] coords = new double[6];
        int count = 0;
        double startPntX = 0.0;
        double startPntY = 0.0;
        double endPntX = 0.0;
        double endPntY = 0.0;
        while (!pi.isDone()) {
            int type = pi.currentSegment(coords);
            if (type == 1) {
                startPntX = endPntX;
                startPntY = endPntY;
                float dist = (float)Line2D.ptSegDist(startPntX, startPntY, endPntX = coords[0], endPntY = coords[1], x, y);
                if (dist < distance) {
                    distance = dist;
                }
                if (Debug.debugging("omgraphicdetail")) {
                    Debug.output("Type: " + type + "(" + count++ + "), " + startPntX + ", " + startPntY + ", " + endPntX + ", " + endPntY + ", " + x + ", " + y + ", distance: " + distance);
                }
            } else {
                startPntX = coords[0];
                startPntY = coords[1];
                endPntX = coords[0];
                endPntY = coords[1];
            }
            pi.next();
        }
        return distance;
    }

    @Override
    public float distance(double x, double y) {
        return this._distance(x, y);
    }

    protected float _distance(double x, double y) {
        float distance = Float.POSITIVE_INFINITY;
        if (this.getNeedToRegenerate() || this.shape == null) {
            return distance;
        }
        if (this.shape.contains(x, y)) {
            return 0.0f;
        }
        return this.distanceToEdge(x, y);
    }

    @Override
    public boolean contains(double x, double y) {
        GeneralPath shape = this.getShape();
        boolean ret = false;
        if (shape != null) {
            ret = shape.contains(x, y);
        }
        return ret;
    }

    @Override
    public boolean regenerate(Projection proj) {
        if (proj == null) {
            return false;
        }
        if (this.getNeedToRegenerate()) {
            return this.generate(proj);
        }
        return false;
    }

    @Override
    public GeneralPath getShape() {
        return this.shape;
    }

    @Override
    public synchronized void setShape(GeneralPath gp) {
        this.shape = gp;
    }

    public static GeneralPath createShape(float[] xpoints, float[] ypoints, boolean isPolygon) {
        return BasicGeometry.createShape(xpoints, ypoints, 0, xpoints.length, isPolygon);
    }

    public static GeneralPath createShape(float[] xpoints, float[] ypoints, int startIndex, int length, boolean isPolygon) {
        if (xpoints == null || ypoints == null) {
            return null;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (length > xpoints.length - startIndex) {
            length = xpoints.length - startIndex - 1;
        }
        GeneralPath path = new GeneralPath(0, length);
        if (length > startIndex) {
            path.moveTo(xpoints[startIndex], ypoints[startIndex]);
            for (int j = startIndex + 1; j < length; ++j) {
                path.lineTo(xpoints[j], ypoints[j]);
            }
            if (isPolygon) {
                path.closePath();
            }
        }
        return path;
    }

    public static void describeShapeDetail(Shape shape) {
        BasicGeometry.describeShapeDetail(shape, 0.25);
    }

    public static void describeShapeDetail(Shape shape, double flattening) {
        PathIterator pi2 = shape.getPathIterator(null);
        FlatteningPathIterator pi = new FlatteningPathIterator(pi2, flattening);
        double[] coords = new double[6];
        int pointCount = 0;
        Debug.output(" -- start describeShapeDetail with flattening[" + flattening + "]");
        while (!pi.isDone()) {
            int type = pi.currentSegment(coords);
            Debug.output(" Shape point [" + type + "] (" + pointCount++ + ") " + coords[0] + ", " + coords[1]);
            pi.next();
        }
        Debug.output(" -- end (" + pointCount + ")");
    }

    public static GeneralPath appendShapeEdge(GeneralPath toShape, float[] xpoints, float[] ypoints) {
        return BasicGeometry.appendShapeEdge(toShape, xpoints, ypoints, 0, xpoints.length);
    }

    public static GeneralPath appendShapeEdge(GeneralPath toShape, float[] xpoints, float[] ypoints, int startIndex, int length) {
        return BasicGeometry.appendShapeEdge(toShape, BasicGeometry.createShape(xpoints, ypoints, startIndex, length, false));
    }

    public static GeneralPath appendShapeEdge(GeneralPath toShape, GeneralPath addShape) {
        return BasicGeometry.appendShapeEdge(toShape, addShape, true);
    }

    public static GeneralPath appendShapeEdge(GeneralPath toShape, GeneralPath addShape, boolean lineTo) {
        boolean DEBUG = Debug.debugging("arealist");
        int pointCount = 0;
        if (addShape == null) {
            return toShape;
        }
        if (toShape == null) {
            return addShape;
        }
        PathIterator pi2 = addShape.getPathIterator(null);
        FlatteningPathIterator pi = new FlatteningPathIterator(pi2, 0.25);
        double[] coords = new double[6];
        while (!pi.isDone()) {
            int type = pi.currentSegment(coords);
            if (lineTo) {
                if (DEBUG) {
                    Debug.output(" adding point [" + type + "] (" + pointCount++ + ") " + (float)coords[0] + ", " + (float)coords[1]);
                }
                toShape.lineTo((float)coords[0], (float)coords[1]);
            } else {
                if (DEBUG) {
                    Debug.output("Creating new shape, first point " + (float)coords[0] + ", " + (float)coords[1]);
                }
                toShape.moveTo((float)coords[0], (float)coords[1]);
                lineTo = true;
            }
            pi.next();
        }
        if (DEBUG) {
            Debug.output(" -- end point (" + pointCount + ")");
        }
        return toShape;
    }

    public static GeneralPath createBoxShape(float x, float y, int width, int height) {
        float[] xs = new float[4];
        float[] ys = new float[4];
        xs[0] = x;
        ys[0] = y;
        xs[1] = x + (float)width;
        ys[1] = y;
        xs[2] = x + (float)width;
        ys[2] = y + (float)height;
        xs[3] = x;
        ys[3] = y + (float)height;
        return BasicGeometry.createShape(xs, ys, true);
    }

    @Override
    public void restore(OMGeometry source) {
        this.lineType = source.getLineType();
        this.visible = source.isVisible();
        Map<Object, Object> attributes = source.getAttributes();
        if (attributes != null) {
            Map<Object, Object> nAttributes = this.createAttributeMap();
            nAttributes.putAll(attributes);
            nAttributes.put(ATT_MAP_KEY, nAttributes);
        }
        this.needToRegenerate = true;
    }
}

