/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics;

import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGrid;
import com.bbn.openmap.omGraphics.OMList;
import com.bbn.openmap.omGraphics.grid.OMGridGenerator;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.HandleError;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.io.EOFException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OMGraphicList
extends OMList<OMGraphic>
implements Serializable {
    public OMGraphicList() {
        this(10);
    }

    public OMGraphicList(int initialCapacity) {
        this.graphics = Collections.synchronizedList(new ArrayList(initialCapacity));
    }

    public OMGraphicList(Collection<OMGraphic> c) {
        this.graphics.addAll(c);
    }

    public Iterator<OMGraphic> iteratorCopy() {
        return new OMGraphicList(this.graphics).iterator();
    }

    public ListIterator<OMGraphic> listIteratorCopy() {
        return new OMGraphicList(this.graphics).listIterator();
    }

    public ListIterator<OMGraphic> listIteratorCopy(int size) {
        return new OMGraphicList(this.graphics).listIterator(size);
    }

    @Override
    public synchronized boolean add(OMGraphic g) {
        this.checkForDuplicate(g);
        return this.graphics.add(g);
    }

    public synchronized void setOMGraphicAt(OMGraphic graphic, int index) {
        this.graphics.set(index, graphic);
    }

    public synchronized OMGraphic getOMGraphicAt(int index) {
        return this.get(index);
    }

    @Override
    public synchronized OMGraphic get(int location) {
        return (OMGraphic)this.graphics.get(location);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStroke(Stroke stroke) {
        super.setStroke(stroke);
        OMGraphicList oMGraphicList = this;
        synchronized (oMGraphicList) {
            for (OMGraphic omg : this) {
                omg.setStroke(stroke);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFillPaint(Paint paint) {
        super.setFillPaint(paint);
        OMGraphicList oMGraphicList = this;
        synchronized (oMGraphicList) {
            for (OMGraphic omg : this) {
                omg.setFillPaint(paint);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTextureMask(TexturePaint texture) {
        super.setTextureMask(texture);
        OMGraphicList oMGraphicList = this;
        synchronized (oMGraphicList) {
            for (OMGraphic omg : this) {
                omg.setTextureMask(texture);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLinePaint(Paint paint) {
        super.setLinePaint(paint);
        OMGraphicList oMGraphicList = this;
        synchronized (oMGraphicList) {
            for (OMGraphic omg : this) {
                omg.setLinePaint(paint);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSelectPaint(Paint paint) {
        super.setSelectPaint(paint);
        OMGraphicList oMGraphicList = this;
        synchronized (oMGraphicList) {
            for (OMGraphic omg : this) {
                omg.setSelectPaint(paint);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMattingPaint(Paint paint) {
        super.setMattingPaint(paint);
        OMGraphicList oMGraphicList = this;
        synchronized (oMGraphicList) {
            for (OMGraphic omg : this) {
                omg.setMattingPaint(paint);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMatted(boolean value) {
        super.setMatted(value);
        OMGraphicList oMGraphicList = this;
        synchronized (oMGraphicList) {
            for (OMGraphic omg : this) {
                omg.setMatted(value);
            }
        }
    }

    public synchronized void setGridGenerator(OMGridGenerator generator, Projection proj) {
        for (OMGraphic graphic : this) {
            if (!(graphic instanceof OMGrid)) continue;
            ((OMGrid)graphic).setGenerator(generator);
            if (proj == null) continue;
            graphic.generate(proj);
        }
    }

    public synchronized List<OMGraphic> getTargets() {
        if (this.graphics == null) {
            this.graphics = new ArrayList();
        }
        return this.graphics;
    }

    public synchronized void setTargets(List<OMGraphic> list) {
        this.graphics = list;
    }

    public void readGraphics(URL cacheURL) throws IOException {
        try {
            ObjectInputStream objstream = new ObjectInputStream(cacheURL.openStream());
            if (Debug.debugging("omgraphics")) {
                Debug.output("OMGraphicList: Opened " + cacheURL.toString());
            }
            this.readGraphics(objstream);
            objstream.close();
            if (Debug.debugging("omgraphics")) {
                Debug.output("OMGraphicList: closed " + cacheURL.toString());
            }
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            throw new HandleError(aioobe);
        }
        catch (ClassCastException cce) {
            cce.printStackTrace();
        }
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void readGraphics(ObjectInputStream objstream) throws IOException {
        Debug.message("omgraphics", "OMGraphicList: Reading cached graphics");
        try {
            while (true) lbl-1000:
            // 3 sources

            {
                try {
                    while (true) {
                        omg = (OMGraphic)objstream.readObject();
                        this.add(omg);
                    }
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
                catch (OptionalDataException ode) {
                    ode.printStackTrace();
                    continue;
                }
                break;
            }
        }
        catch (EOFException var2_5) {
            return;
        }
        ** GOTO lbl-1000
    }

    public void writeGraphics(String graphicsSaveFile) throws IOException {
        FileOutputStream ostream = new FileOutputStream(graphicsSaveFile);
        ObjectOutputStream objectstream = new ObjectOutputStream(ostream);
        this.writeGraphics(objectstream);
        objectstream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void writeGraphics(ObjectOutputStream objectstream) throws IOException {
        List list = this.graphics;
        synchronized (list) {
            for (OMGraphic g : this) {
                try {
                    objectstream.writeObject(g);
                }
                catch (IOException e) {
                    Debug.error("OMGraphicList: Couldn't write object " + g + "\nOMGraphicList: Reason: " + e.toString());
                }
            }
        }
        objectstream.close();
    }

    @Override
    public void sort() {
    }

    @Override
    protected OMGraphic objectToOMGraphic(Object obj) {
        if (obj instanceof OMGraphic) {
            return (OMGraphic)obj;
        }
        return null;
    }

    @Override
    public synchronized Object clone() {
        OMGraphicList omgl = new OMGraphicList(this.size());
        for (OMGraphic omg : this) {
            if (omg instanceof OMGraphicList) {
                omgl.add((OMGraphic)((OMGraphicList)omg).clone());
                continue;
            }
            omgl.graphics.add(omg);
        }
        return omgl;
    }

    @Override
    public OMList<OMGraphic> create() {
        return new OMGraphicList();
    }

    @Override
    protected OMList.OMDist<OMGraphic> createDist() {
        return new OMList.OMDist<OMGraphic>();
    }

    @Override
    public void add(int index, OMGraphic element) {
        this.setNeedToRegenerate(true);
        super.add(index, element);
    }

    @Override
    public boolean addAll(Collection<? extends OMGraphic> c) {
        this.setNeedToRegenerate(true);
        return this.graphics.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends OMGraphic> c) {
        this.setNeedToRegenerate(true);
        return this.graphics.addAll(index, c);
    }

    @Override
    public OMGraphic set(int index, OMGraphic element) {
        this.setNeedToRegenerate(true);
        return this.graphics.set(index, element);
    }

    @Override
    public OMGraphic remove(int location) {
        OMGraphic obj = (OMGraphic)super.remove(location);
        if (obj != null) {
            this.setNeedToRegenerate(true);
        }
        return obj;
    }
}

