/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics;

import com.bbn.openmap.omGraphics.OMCircle;
import com.bbn.openmap.omGraphics.OMGeometry;
import com.bbn.openmap.proj.GeoProj;
import com.bbn.openmap.proj.Length;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.util.Debug;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;

public class OMEllipse
extends OMCircle {
    protected double majorAxisSpan;
    protected double minorAxisSpan;
    protected transient double[] rawllpts;

    public OMEllipse(LatLonPoint centerPoint, double majorAxisSpan, double minorAxisSpan, Length units, double rotateAngle) {
        this.setRenderType(1);
        this.setLineType(3);
        this.setCenter(centerPoint);
        this.setAxis(majorAxisSpan, minorAxisSpan, units);
        this.setRotationAngle(rotateAngle);
    }

    public OMEllipse(int x1, int y1, int majorAxisSpan, int minorAxisSpan, double rotateAngle) {
        super(x1, y1, majorAxisSpan, minorAxisSpan);
        this.setRotationAngle(rotateAngle);
    }

    public OMEllipse(LatLonPoint centerPoint, int w, int h, double rotateAngle) {
        super(centerPoint.getY(), centerPoint.getX(), 0, 0, w, h);
        this.setRotationAngle(rotateAngle);
    }

    public OMEllipse(LatLonPoint centerPoint, int offset_x1, int offset_y1, int w, int h, double rotateAngle) {
        super(centerPoint.getY(), centerPoint.getX(), offset_x1, offset_y1, w, h);
        this.setRotationAngle(rotateAngle);
    }

    public void setAxis(double majorAxis, double minorAxis, Length units) {
        if (units == null) {
            units = Length.RADIAN;
        }
        this.majorAxisSpan = units.toRadians(majorAxis);
        this.minorAxisSpan = units.toRadians(minorAxis);
        this.rawllpts = null;
        this.setNeedToRegenerate(true);
    }

    public void setCenter(LatLonPoint llp) {
        super.setCenter(llp);
        this.rawllpts = null;
    }

    public double getMajorAxis() {
        return this.majorAxisSpan;
    }

    public double getMinorAxis() {
        return this.minorAxisSpan;
    }

    public double[] getLatLonPoints() {
        return this.rawllpts;
    }

    public double[] createLatLonPoints() {
        int i;
        int nMax = 72;
        double angle = -Math.PI;
        double angleInc = Math.PI * 2 / (double)nMax;
        double[] distance = new double[nMax + 1];
        double[] azimuth = new double[nMax + 1];
        double[] llPoints = new double[2 * (nMax + 1)];
        double a = this.majorAxisSpan / 2.0;
        double b = this.minorAxisSpan / 2.0;
        for (i = 0; i < nMax; ++i) {
            double x = Math.sqrt(a * a * b * b / (b * b + a * a * Math.pow(Math.tan(angle), 2.0)));
            double yt = x * x / (a * a);
            if (yt > 1.0) {
                yt = 1.0;
            }
            double y = Math.sqrt((1.0 - yt) * (b * b));
            distance[i] = Math.sqrt(Math.pow(x, 2.0) + Math.pow(y, 2.0));
            azimuth[i] = (float)angle + 1.5707964f + (float)this.getRotationAngle();
            if (Debug.debugging("ellipse")) {
                Debug.output(" " + i + " " + Math.toDegrees(azimuth[i]) + " ( " + distance[i] + " ) " + (Debug.debugging("ellipsedetail") ? "[from x:" + x + ", y:" + y + ", a:" + a + ", b:" + b + "]" : ""));
            }
            angle += angleInc;
        }
        distance[nMax] = distance[0];
        azimuth[nMax] = azimuth[0];
        int nCounter = 0;
        for (i = 0; i < nMax + 1; ++i) {
            LatLonPoint llPt = this.center.getPoint((float)distance[i], azimuth[i]);
            llPoints[nCounter++] = llPt.getRadLat();
            llPoints[nCounter++] = llPt.getRadLon();
        }
        return llPoints;
    }

    public boolean generate(Projection proj) {
        if (this.renderType == 2 || this.renderType == 3) {
            return super.generate(proj);
        }
        this.setShape(null);
        if (proj == null) {
            Debug.message("omgraphic", "OMEllipse: null projection in generate!");
            return false;
        }
        if (this.rawllpts == null) {
            this.rawllpts = this.createLatLonPoints();
        }
        ArrayList<float[]> vector = null;
        if (proj instanceof GeoProj) {
            vector = ((GeoProj)proj).forwardPoly(this.rawllpts, this.getLineType(), -1, true);
            int size = vector.size();
            for (int i = 0; i < size; i += 2) {
                GeneralPath gp = OMEllipse.createShape(vector.get(i), vector.get(i + 1), true);
                if (this.shape == null) {
                    this.setShape(gp);
                    continue;
                }
                this.shape.append(gp, false);
            }
        } else {
            Ellipse2D.Float ellipse = new Ellipse2D.Float((float)this.center.getX(), (float)this.center.getY(), (float)this.majorAxisSpan, (float)this.minorAxisSpan);
            this.setShape(new GeneralPath(proj.forwardShape(ellipse)));
        }
        this.setNeedToRegenerate(false);
        return true;
    }

    public void restore(OMGeometry source) {
        super.restore(source);
        if (source instanceof OMEllipse) {
            OMEllipse ellipse = (OMEllipse)source;
            this.majorAxisSpan = ellipse.majorAxisSpan;
            this.minorAxisSpan = ellipse.minorAxisSpan;
        }
    }
}

