/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.vpf;

import com.bbn.openmap.io.BinaryBufferedFile;
import com.bbn.openmap.io.BinaryFile;
import com.bbn.openmap.io.FormatException;
import java.io.IOException;

public class DcwVariableLengthIndexFile {
    private final int[] offsettable;
    private final int recordCount;
    private final int endOfFileOffset;

    public DcwVariableLengthIndexFile(String filename, boolean msbfirst) throws FormatException, IOException {
        this(new BinaryBufferedFile(filename), msbfirst);
    }

    public DcwVariableLengthIndexFile(BinaryFile inputstream, boolean msbfirst) throws FormatException {
        try {
            inputstream.byteOrder(msbfirst);
            this.recordCount = inputstream.readInteger();
            inputstream.readInteger();
            this.offsettable = new int[this.recordCount * 2];
            inputstream.readIntegerArray(this.offsettable, 0, this.recordCount * 2);
            this.endOfFileOffset = this.offsettable[this.offsettable.length - 2] + this.offsettable[this.offsettable.length - 1];
            inputstream.close();
        }
        catch (IOException i) {
            throw new FormatException("IOException with " + inputstream.getName() + ": " + i.getMessage());
        }
    }

    public int recordOffset(int recordNumber) {
        return this.recordCount < recordNumber ? this.endOfFileOffset : this.offsettable[(recordNumber - 1) * 2];
    }

    public int recordSize(int recordNumber) {
        return this.recordCount < recordNumber ? 0 : this.offsettable[(recordNumber - 1) * 2 + 1];
    }

    public int getRecordCount() {
        return this.recordCount;
    }

    public void close() {
    }
}

