/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.rpf;

import com.bbn.openmap.layer.rpf.RpfLayer;
import com.bbn.openmap.layer.util.DataPathWanderer;
import com.bbn.openmap.util.ArgParser;
import com.bbn.openmap.util.Debug;
import java.io.File;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RpfDataPathWanderer
extends DataPathWanderer {
    public RpfDataPathWanderer() {
        this.setCallback(this);
    }

    public Class<RpfLayer> getDataUserClass() {
        return RpfLayer.class;
    }

    @Override
    protected boolean handleDirectory(File directory, String[] contentNames) throws SecurityException {
        if (directory.getName().equalsIgnoreCase("RPF")) {
            boolean foundRPFDir = false;
            for (String childName : contentNames) {
                if (!childName.equalsIgnoreCase("A.TOC")) continue;
                foundRPFDir = true;
                break;
            }
            if (foundRPFDir) {
                this.addDataPath(directory.getAbsolutePath());
                return true;
            }
        }
        return super.handleDirectory(directory, contentNames);
    }

    @Override
    public boolean handleDirectory(File directory) {
        return true;
    }

    @Override
    public boolean handleFile(File file) {
        return true;
    }

    @Override
    public String getPrettyName() {
        return "RPF Layer";
    }

    @Override
    public boolean isMultiPathLayer() {
        return true;
    }

    public static void main(String[] argv) {
        Debug.init();
        ArgParser ap = new ArgParser("Wanderer");
        if (argv.length == 0) {
            ap.bail("", true);
        }
        String[] dirs = argv;
        RpfDataPathWanderer wanderer = new RpfDataPathWanderer();
        for (int i = 0; i < dirs.length; ++i) {
            wanderer.handleEntry(new File(dirs[i]));
        }
        for (String path : wanderer.getDataPaths()) {
            System.out.println("found: " + path);
        }
    }
}

