/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.rpf;

import com.bbn.openmap.io.BinaryBufferedFile;
import com.bbn.openmap.io.BinaryFile;
import com.bbn.openmap.io.FormatException;
import com.bbn.openmap.layer.rpf.RpfFileSections;
import com.bbn.openmap.layer.rpf.RpfHeader;
import com.bbn.openmap.util.Debug;
import java.awt.Color;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public class RpfColortable {
    public static final int CADRG_COLORS = 216;
    public static final int COLORS_216 = 0;
    public static final int COLORS_32 = 1;
    public static final int COLORS_16 = 2;
    public static final int CIB_SPEC_CODE_ID = 3;
    public static final int DEFAULT_OPAQUENESS = 255;
    public int[] colorConvTable = new int[216];
    protected int reducedColorTable = 0;
    protected int numColors = 0;
    protected boolean Cib = false;
    protected int opaqueness = 255;
    public Color[] colors = null;
    public char zone;
    public String seriesCode;
    protected int tocNumber = -1;
    protected int entryNumber = -1;

    public RpfColortable() {
        this(216, 255, false);
    }

    public RpfColortable(int nColors) {
        this(nColors, 255, false);
    }

    public RpfColortable(int nColors, int opaque, boolean cib) {
        this.setNumColors(nColors);
        this.setOpaqueness(opaque);
        this.setCib(cib);
    }

    public void setFrom(RpfColortable colortable) {
        this.colors = colortable.colors;
        this.reducedColorTable = colortable.reducedColorTable;
        this.colorConvTable = colortable.colorConvTable;
        this.Cib = colortable.Cib;
        this.opaqueness = colortable.opaqueness;
        this.zone = colortable.zone;
    }

    public void setOpaqueness(int value) {
        this.opaqueness = value;
        if (this.colors != null) {
            for (int i = 0; i < this.colors.length; ++i) {
                Color tmp = this.colors[i];
                this.colors[i] = new Color(tmp.getRed(), tmp.getGreen(), tmp.getBlue(), this.opaqueness);
            }
        }
    }

    public int getOpaqueness() {
        return this.opaqueness;
    }

    public void setOpaquePercent(int percent) {
        this.setOpaqueness((int)((double)percent * 2.55));
    }

    public int getOpaquePercent() {
        return (int)((double)this.opaqueness * 100.0 / 255.0);
    }

    public void setNumColors(int numColorsValue) {
        this.numColors = numColorsValue;
        this.reducedColorTable = this.numColors >= 216 ? 0 : (this.numColors >= 32 ? 1 : 2);
    }

    public int getNumColors() {
        return this.numColors;
    }

    public int getColorTableReduction() {
        return this.reducedColorTable;
    }

    public void setCib(boolean value) {
        this.Cib = value;
    }

    public boolean isCib() {
        return this.Cib;
    }

    public void setATOCIndexes(int tocIndex, int entryIndex) {
        this.tocNumber = tocIndex;
        this.entryNumber = entryIndex;
    }

    public boolean isSameATOCIndexes(int tocIndex, int entryIndex) {
        return tocIndex == this.tocNumber && entryIndex == this.entryNumber;
    }

    public int getTocNumber() {
        return this.tocNumber;
    }

    public int getEntryNumber() {
        return this.entryNumber;
    }

    public Color[] parseColorLookUpTable(BinaryFile binFile, RpfFileSections.RpfLocationRecord[] loc) {
        if (Debug.debugging("rpfcolortable")) {
            Debug.output("RpfColortable:  creating new colors for colortable.");
        }
        Color[] rgb = new Color[216];
        int offsetRecordLength = 17;
        if (Debug.debugging("rpfdetail")) {
            Debug.output("ENTER PARSE Colortable");
        }
        try {
            int blue;
            int green;
            int alpha;
            int red;
            int j;
            boolean foundLUT;
            long ncr;
            int i;
            if (Debug.debugging("rpfdetail")) {
                Debug.output("RpfColortable: Color/gray section subheader (ID=134) location: " + loc[0].componentLocation);
            }
            binFile.seek(loc[0].componentLocation);
            int numColorOffsetRecs = binFile.read();
            int numColorConvOffsetRecs = binFile.read();
            if (Debug.debugging("rpfdetail")) {
                Debug.output("RpfColortable: numColorOffsetRecs(3): " + numColorOffsetRecs);
                Debug.output("RpfColortable: numColorConvOffsetRecs(2): " + numColorConvOffsetRecs);
            }
            ColorOffset[] colorOffset = new ColorOffset[numColorOffsetRecs];
            if (Debug.debugging("rpfdetail")) {
                Debug.output("RpfColortable: Colormap subsection loc[1]: " + loc[1].componentLocation);
            }
            binFile.seek(loc[1].componentLocation);
            long colormapOffsetTableOffset = binFile.readInteger();
            offsetRecordLength = binFile.readShort();
            if (Debug.debugging("rpfdetail")) {
                Debug.output("RpfColortable: colormapOffsetTableOffset: " + colormapOffsetTableOffset);
                Debug.output("RpfColortable: offsetRecordLength:" + offsetRecordLength);
            }
            if (this.reducedColorTable == 0 || this.Cib) {
                for (i = 0; i < numColorOffsetRecs; ++i) {
                    colorOffset[i] = new ColorOffset();
                    colorOffset[i].tableId = binFile.readShort();
                    colorOffset[i].numColorRecords = (long)binFile.readInteger() & 0xFFFFFFFFL;
                    colorOffset[i].colorElementLength = binFile.read();
                    colorOffset[i].histogramRecordLength = binFile.readShort();
                    colorOffset[i].colorTableOffset = (long)binFile.readInteger() & 0xFFFFFFFFL;
                    colorOffset[i].histogramTableOffset = (long)binFile.readInteger() & 0xFFFFFFFFL;
                    if (Debug.debugging("rpfdetail")) {
                        Debug.output("RpfColortable: Parse_clut: " + i);
                        Debug.output(colorOffset[i].toString());
                    }
                    this.Cib = colorOffset[i].tableId == 3;
                    ncr = colorOffset[i].numColorRecords;
                    foundLUT = ncr == 216L || ncr == 217L;
                    if (Debug.debugging("rpfdetail")) {
                        Debug.output("RpfColortable: foundLUT of desired 216?: " + foundLUT);
                    }
                    if (!foundLUT) continue;
                    binFile.seek(loc[1].componentLocation + colorOffset[i].colorTableOffset);
                    if (ncr >= 216L) {
                        if (Debug.debugging("rpf")) {
                            Debug.error("RpfColortable: ncr is not correct, wingin' it (" + ncr + ")");
                        }
                        ncr = 216L;
                    }
                    j = 0;
                    while ((long)j < ncr) {
                        this.colorConvTable[j] = j;
                        if (this.Cib) {
                            red = binFile.read() & 0xFF;
                            alpha = this.opaqueness;
                            green = red;
                            blue = red;
                        } else {
                            red = binFile.read() & 0xFF;
                            green = binFile.read() & 0xFF;
                            blue = binFile.read() & 0xFF;
                            alpha = binFile.read();
                            alpha = this.opaqueness;
                            if (ncr == 217L && rgb[(int)(ncr - 1L)] == null) {
                                alpha = 255;
                                red = 255;
                                green = 255;
                                blue = 255;
                                rgb[(int)(ncr - 1L)] = new Color(red, green, blue, alpha);
                            }
                        }
                        rgb[j] = new Color(red, green, blue, alpha);
                        if (Debug.debugging("rpfcolortable")) {
                            if (j == 0) {
                                Debug.output("RpfColortable:\n\n---Full color table---\n");
                            }
                            Debug.output("RpfColortable:red: " + red + ", green: " + green + ", blue: " + blue + ", alpha: " + alpha);
                        }
                        ++j;
                    }
                    break;
                }
            } else {
                if (Debug.debugging("rpfdetail")) {
                    Debug.output("RpfColortable: color converter subsection loc[2]:" + loc[2].componentLocation);
                }
                binFile.seek(loc[2].componentLocation);
                long colorConvOffsetTableOffset = binFile.readInteger();
                short colorConvOffsetRecl = binFile.readShort();
                short colorConvRecl = binFile.readShort();
                if (Debug.debugging("rpfdetail")) {
                    Debug.output("RpfColortable: colorConvOffsetTableOffset:" + colorConvOffsetTableOffset);
                    Debug.output("RpfColortable: colorConvOffsetRecl:" + colorConvOffsetRecl);
                    Debug.output("RpfColortable: colorConvRecl:" + colorConvRecl);
                }
                ColorConversionTable[] cct = new ColorConversionTable[numColorConvOffsetRecs];
                for (i = 0; i < numColorConvOffsetRecs; ++i) {
                    cct[i] = new ColorConversionTable();
                    cct[i].colorConvTableId = binFile.readShort();
                    cct[i].colorConvNumRecs = binFile.readInteger();
                    cct[i].colorConvTableOffset = binFile.readInteger();
                    cct[i].colorConvSourceTableOffset = binFile.readInteger();
                    cct[i].colorConvTargetTableOffset = binFile.readInteger();
                    if (!Debug.debugging("rpfdetail")) continue;
                    Debug.output("RpfColortable: color conversion table - " + i);
                    Debug.output(cct[i].toString());
                }
                colorOffset = new ColorOffset[numColorConvOffsetRecs];
                for (i = 0; i < numColorConvOffsetRecs; ++i) {
                    binFile.seek(loc[1].componentLocation + cct[i].colorConvTargetTableOffset);
                    colorOffset[i] = new ColorOffset();
                    colorOffset[i].tableId = binFile.readShort();
                    ncr = colorOffset[i].numColorRecords = (long)binFile.readInteger();
                    foundLUT = (ncr == 32L || ncr == 33L) && this.reducedColorTable == 1 || (ncr == 16L || ncr == 17L) && this.reducedColorTable == 2;
                    if (Debug.debugging("rpfdetail")) {
                        Debug.output("RpfColortable: foundLUT?:" + foundLUT);
                    }
                    if (!foundLUT) continue;
                    colorOffset[i].colorElementLength = binFile.read();
                    colorOffset[i].histogramRecordLength = binFile.readShort();
                    colorOffset[i].colorTableOffset = binFile.readInteger();
                    colorOffset[i].histogramTableOffset = binFile.readInteger();
                    if (Debug.debugging("rpfdetail")) {
                        Debug.output("RpfColortable: Parse_clut: " + i);
                        Debug.output(colorOffset[i].toString());
                    }
                    binFile.seek(loc[1].componentLocation + colorOffset[i].colorTableOffset);
                    j = 0;
                    while ((long)j < ncr) {
                        red = binFile.read() & 0xFF;
                        green = binFile.read() & 0xFF;
                        blue = binFile.read() & 0xFF;
                        alpha = binFile.read();
                        alpha = this.opaqueness;
                        if (ncr == 217L && rgb[(int)(ncr - 1L)] == null) {
                            alpha = this.opaqueness;
                            red = 255;
                            green = 255;
                            blue = 255;
                            rgb[(int)(ncr - 1L)] = new Color(red, green, blue, alpha);
                        }
                        rgb[j] = new Color(red, green, blue, alpha);
                        if (Debug.debugging("rpfcolortable")) {
                            if (j == 0) {
                                Debug.output("RpfColortable:\n\n---CCT color table---\n");
                            }
                            Debug.output("RpfColortable: red:" + red + ", green:" + green + ", blue:" + blue + ", alpha: " + alpha);
                        }
                        ++j;
                    }
                    binFile.seek(loc[2].componentLocation + cct[i].colorConvTableOffset);
                    if (Debug.debugging("rpfdetail")) {
                        Debug.output("RpfColortable: i:" + i + ", colorConvTableOffset[i]:" + cct[i].colorConvTableOffset);
                        Debug.output("RpfColortable: Read cct values at file location:" + binFile.getFilePointer());
                    }
                    j = 0;
                    while ((long)j < cct[i].colorConvNumRecs) {
                        this.colorConvTable[j] = binFile.readInteger();
                        if (Debug.debugging("rpfcolortable")) {
                            Debug.output("RpfColortable: j:" + j + ", colorConvTable[j]:" + this.colorConvTable[j]);
                        }
                        ++j;
                    }
                    break;
                }
            }
            if (this.reducedColorTable == 0) {
                if (Debug.debugging("rpfdetail")) {
                    Debug.output("RpfColortable: WARNING - Full 216 colors being used\n");
                }
                for (j = 0; j < 216; ++j) {
                    this.colorConvTable[j] = j;
                }
            }
            if (this.Cib && this.reducedColorTable != 0) {
                int midoffset;
                int divisor;
                if (this.reducedColorTable == 1) {
                    divisor = 8;
                    midoffset = 4;
                } else {
                    divisor = 16;
                    midoffset = 8;
                }
                for (j = 0; j < 216; ++j) {
                    red = rgb[j].getRed() / divisor * divisor + midoffset;
                    green = rgb[j].getGreen() / divisor * divisor + midoffset;
                    blue = rgb[j].getBlue() / divisor * divisor + midoffset;
                    alpha = rgb[j].getAlpha();
                    rgb[j] = new Color(red, green, blue, alpha);
                    if (!Debug.debugging("rpfcolortable")) continue;
                    if (j == 0) {
                        Debug.output("RpfColortable:\n\n---Final color table CIB---\n");
                    }
                    Debug.output("RpfColortable: Color " + j + " red: " + rgb[j].getRed() + ", green: " + rgb[j].getGreen() + ", blue: " + rgb[j].getBlue());
                }
            } else if (this.reducedColorTable != 0) {
                for (j = 0; j < 216; ++j) {
                    red = rgb[this.colorConvTable[j]].getRed();
                    green = rgb[this.colorConvTable[j]].getGreen();
                    blue = rgb[this.colorConvTable[j]].getBlue();
                    alpha = rgb[this.colorConvTable[j]].getAlpha();
                    rgb[j] = new Color(red, green, blue, alpha);
                    if (!Debug.debugging("rpfcolortable")) continue;
                    if (j == 0) {
                        Debug.output("RpfColortable:\n\n---Final color table---\n");
                    }
                    Debug.output("RpfColortable: Color " + j + " red: " + rgb[j].getRed() + ", green: " + rgb[j].getGreen() + ", blue: " + rgb[j].getBlue());
                }
            }
            if (Debug.debugging("rpfdetail")) {
                Debug.output("RpfColortable: LEAVE PARSE Colortable");
            }
        }
        catch (IOException ioe) {
            Debug.error("RpfTocHandler: IO ERROR parsing file!\n" + ioe);
            return null;
        }
        catch (FormatException fe) {
            Debug.error("RpfTocHandler: Format ERROR parsing file!\n" + fe);
            return null;
        }
        this.colors = rgb;
        return rgb;
    }

    public static void main(String[] args) {
        Debug.init(System.getProperties());
        if (args.length != 1) {
            Debug.output("Usage: java RpfColortable <path to RPF frame>");
            return;
        }
        File file = new File(args[0]);
        BinaryBufferedFile binFile = null;
        try {
            binFile = new BinaryBufferedFile(file);
        }
        catch (FileNotFoundException e) {
            Debug.error("RpfHeader: file " + args[0] + " not found");
            System.exit(1);
        }
        catch (IOException ioe) {
            Debug.error("RpfHeader: File IO Error while handling colortable:\n" + ioe);
            System.exit(1);
        }
        RpfColortable tbl = new RpfColortable();
        RpfFileSections rfs = new RpfFileSections();
        RpfHeader head = new RpfHeader();
        head.read(binFile);
        rfs.parse(binFile);
        Color[] colors = rfs.parseColorSection(binFile, tbl);
        if (colors == null) {
            Debug.output("RpfColortable: NOT read successfully!");
        }
    }

    public static class ColorConversionTable {
        public int colorConvTableId;
        public long colorConvNumRecs;
        public long colorConvTableOffset;
        public long colorConvSourceTableOffset;
        public long colorConvTargetTableOffset;

        public String toString() {
            StringBuffer s = new StringBuffer();
            s.append("RpfColortable: colorConvTableId: ").append(this.colorConvTableId).append("\n");
            s.append("RpfColortable: colorConvNumRecs: ").append(this.colorConvNumRecs).append("\n");
            s.append("RpfColortable: colorConvTableOffset: ").append(this.colorConvTableOffset).append("\n");
            s.append("RpfColortable: colorConvSourceTableOffset: ").append(this.colorConvSourceTableOffset).append("\n");
            s.append("RpfColortable: colorConvTargetTableOffset: ").append(this.colorConvTargetTableOffset);
            return s.toString();
        }
    }

    public static class ColorOffset {
        public int tableId;
        public long numColorRecords;
        public int colorElementLength;
        public int histogramRecordLength;
        public long colorTableOffset;
        public long histogramTableOffset;

        public String toString() {
            StringBuffer s = new StringBuffer();
            s.append("RpfColortable: tableId 2:CADRG; 3:CIB): ").append(this.tableId).append("\n");
            s.append("RpfColortable: numColorRecords: ").append(this.numColorRecords).append("\n");
            s.append("RpfColortable: colorElementLength: ").append(this.colorElementLength).append("\n");
            s.append("RpfColortable: histogramRecordLength: ").append(this.histogramRecordLength).append("\n");
            s.append("RpfColortable: colorTableOffset: ").append(this.colorTableOffset).append("\n");
            s.append("RpfColortable: histogramTableOffset: ").append(this.histogramTableOffset);
            return s.toString();
        }
    }
}

