/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.policy;

import com.bbn.openmap.layer.OMGraphicHandlerLayer;
import com.bbn.openmap.layer.policy.StandardRenderPolicy;
import com.bbn.openmap.util.PropUtils;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;

public class RenderingHintsRenderPolicy
extends StandardRenderPolicy {
    public static final String RenderingHintsProperty = "renderingHints";
    protected RenderingHints renderingHints = null;

    public RenderingHintsRenderPolicy() {
        this.setRenderingHints(new RenderingHints(null));
    }

    public RenderingHintsRenderPolicy(OMGraphicHandlerLayer layer) {
        super(layer);
        this.setRenderingHints(new RenderingHints(null));
    }

    public void setRenderingHints(RenderingHints rh) {
        this.renderingHints = rh;
    }

    public RenderingHints getRenderingHints() {
        return this.renderingHints;
    }

    public void paint(Graphics g) {
        g = g.create();
        this.setRenderingHints(g);
        this.setCompositeOnGraphics((Graphics2D)g);
        super.paint(g);
    }

    public void setRenderingHints(Graphics g) {
        if (this.renderingHints != null && g instanceof Graphics2D) {
            Graphics2D g2 = (Graphics2D)g;
            for (Map.Entry<Object, Object> entry : this.renderingHints.entrySet()) {
                RenderingHints.Key key = (RenderingHints.Key)entry.getKey();
                g2.setRenderingHint(key, entry.getValue());
            }
        }
    }

    public void setProperties(String prefix, Properties props) {
        Vector<String> renderingHintsVector;
        super.setProperties(prefix, props);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        String renderingHintsString = props.getProperty(prefix + RenderingHintsProperty);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("RHRP: decoding rendering hints: " + renderingHintsString);
        }
        if ((renderingHintsVector = PropUtils.parseSpacedMarkers(renderingHintsString)) != null) {
            for (String renderingHintKeyString : renderingHintsVector) {
                if (renderingHintKeyString == null) continue;
                String renderingHintValueString = props.getProperty(prefix + renderingHintKeyString);
                if (renderingHintValueString != null) {
                    Object key = null;
                    Object value = null;
                    try {
                        key = RenderingHints.class.getField(renderingHintKeyString).get(null);
                        value = RenderingHints.class.getField(renderingHintValueString).get(null);
                    }
                    catch (NoSuchFieldException nsfe) {
                    }
                    catch (IllegalAccessException iae) {
                        // empty catch block
                    }
                    if (key != null && value != null) {
                        if (this.renderingHints == null) {
                            this.renderingHints = new RenderingHints(null);
                        }
                        this.renderingHints.put(key, value);
                        if (!logger.isLoggable(Level.FINE)) continue;
                        logger.fine("RHRP+++ adding " + renderingHintKeyString + " | " + renderingHintValueString);
                        continue;
                    }
                    if (!logger.isLoggable(Level.FINE)) continue;
                    logger.fine("RHRP--- NOT adding " + renderingHintKeyString + " (" + key + ") | " + renderingHintValueString + " (" + value + ")");
                    continue;
                }
                if (!logger.isLoggable(Level.FINE)) continue;
                logger.fine("RHRP--- NOT adding " + renderingHintKeyString);
            }
        }
    }

    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        return props;
    }

    public Properties getPropertyInfo(Properties props) {
        props = super.getPropertyInfo(props);
        return props;
    }
}

